/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget.vertical;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.ScrollView;
import com.lzy.widget.vertical.ObservableView;

public class VerticalScrollView
extends ScrollView
implements ObservableView {
    private float downX;
    private float downY;

    public VerticalScrollView(Context context) {
        this(context, null);
    }

    public VerticalScrollView(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010080);
    }

    public VerticalScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.downX = ev.getX();
                this.downY = ev.getY();
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                float dx = ev.getX() - this.downX;
                float dy = ev.getY() - this.downY;
                boolean allowParentTouchEvent = Math.abs(dy) > Math.abs(dx) ? (dy > 0.0f ? this.isTop() : this.isBottom()) : true;
                this.getParent().requestDisallowInterceptTouchEvent(!allowParentTouchEvent);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public boolean isTop() {
        if (Build.VERSION.SDK_INT >= 14) {
            return !this.canScrollVertically(-1);
        }
        return this.getScrollY() <= 0;
    }

    @Override
    public boolean isBottom() {
        if (Build.VERSION.SDK_INT >= 14) {
            return !this.canScrollVertically(1);
        }
        return this.getScrollY() + this.getHeight() >= this.computeVerticalScrollRange();
    }

    @Override
    public void goTop() {
        this.scrollTo(0, 0);
    }
}

