/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ScrollView;
import android.widget.Scroller;
import com.lzy.widget.R;

public class PullZoomView
extends ScrollView {
    private static final String TAG_HEADER = "header";
    private static final String TAG_ZOOM = "zoom";
    private static final String TAG_CONTENT = "content";
    private float sensitive = 1.5f;
    private int zoomTime = 500;
    private boolean isParallax = true;
    private boolean isZoomEnable = true;
    private Scroller scroller;
    private boolean isActionDown = false;
    private boolean isZooming = false;
    private ViewGroup.MarginLayoutParams headerParams;
    private int headerHeight;
    private View headerView;
    private View zoomView;
    private View contentView;
    private float lastEventX;
    private float lastEventY;
    private float downX;
    private float downY;
    private int maxY;
    private int touchSlop;
    private OnScrollListener scrollListener;
    private OnPullZoomListener pullZoomListener;
    private boolean scrollFlag = false;
    private boolean isStartScroll = false;

    public void setOnScrollListener(OnScrollListener scrollListener) {
        this.scrollListener = scrollListener;
    }

    public void setOnPullZoomListener(OnPullZoomListener pullZoomListener) {
        this.pullZoomListener = pullZoomListener;
    }

    public PullZoomView(Context context) {
        this(context, null);
    }

    public PullZoomView(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010080);
    }

    public PullZoomView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.PullZoomView);
        this.sensitive = a.getFloat(R.styleable.PullZoomView_pzv_sensitive, this.sensitive);
        this.isParallax = a.getBoolean(R.styleable.PullZoomView_pzv_isParallax, this.isParallax);
        this.isZoomEnable = a.getBoolean(R.styleable.PullZoomView_pzv_isZoomEnable, this.isZoomEnable);
        this.zoomTime = a.getInt(R.styleable.PullZoomView_pzv_zoomTime, this.zoomTime);
        a.recycle();
        this.scroller = new Scroller(this.getContext());
        this.touchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                PullZoomView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                PullZoomView.this.maxY = PullZoomView.this.contentView.getTop();
            }
        });
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.findTagViews((View)this);
        if (this.headerView == null || this.zoomView == null || this.contentView == null) {
            throw new IllegalStateException("content, header, zoom \u90fd\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u8bf7\u5728Xml\u5e03\u5c40\u4e2d\u8bbe\u7f6eTag\uff0c\u6216\u8005\u4f7f\u7528\u5c5e\u6027\u8bbe\u7f6e");
        }
        this.headerParams = (ViewGroup.MarginLayoutParams)this.headerView.getLayoutParams();
        this.headerHeight = this.headerParams.height;
        this.smoothScrollTo(0, 0);
    }

    private void findTagViews(View v) {
        if (v instanceof ViewGroup) {
            ViewGroup vg = (ViewGroup)v;
            for (int i = 0; i < vg.getChildCount(); ++i) {
                View childView = vg.getChildAt(i);
                String tag = (String)childView.getTag();
                if (tag != null) {
                    if (TAG_CONTENT.equals(tag) && this.contentView == null) {
                        this.contentView = childView;
                    }
                    if (TAG_HEADER.equals(tag) && this.headerView == null) {
                        this.headerView = childView;
                    }
                    if (TAG_ZOOM.equals(tag) && this.zoomView == null) {
                        this.zoomView = childView;
                    }
                }
                if (!(childView instanceof ViewGroup)) continue;
                this.findTagViews(childView);
            }
        } else {
            String tag = (String)v.getTag();
            if (tag != null) {
                if (TAG_CONTENT.equals(tag) && this.contentView == null) {
                    this.contentView = v;
                }
                if (TAG_HEADER.equals(tag) && this.headerView == null) {
                    this.headerView = v;
                }
                if (TAG_ZOOM.equals(tag) && this.zoomView == null) {
                    this.zoomView = v;
                }
            }
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.scrollListener != null) {
            this.scrollListener.onScroll(l, t, oldl, oldt);
        }
        if (t >= 0 && t <= this.maxY) {
            this.scrollFlag = true;
            if (this.scrollListener != null) {
                this.scrollListener.onHeaderScroll(t, this.maxY);
            }
        } else if (this.scrollFlag) {
            this.scrollFlag = false;
            if (t < 0) {
                t = 0;
            }
            if (t > this.maxY) {
                t = this.maxY;
            }
            if (this.scrollListener != null) {
                this.scrollListener.onHeaderScroll(t, this.maxY);
            }
        }
        if (t >= this.maxY && this.scrollListener != null) {
            this.scrollListener.onContentScroll(l, t - this.maxY, oldl, oldt - this.maxY);
        }
        if (this.isParallax) {
            if (t >= 0 && t <= this.headerHeight) {
                this.headerView.scrollTo(0, -((int)(0.65 * (double)t)));
            } else {
                this.headerView.scrollTo(0, 0);
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        int action = e.getAction();
        switch (action) {
            case 0: {
                this.downX = e.getX();
                this.downY = e.getY();
                break;
            }
            case 2: {
                float moveY = e.getY();
                if (!(Math.abs(moveY - this.downY) > (float)this.touchSlop)) break;
                return true;
            }
        }
        return super.onInterceptTouchEvent(e);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.isZoomEnable) {
            return super.onTouchEvent(ev);
        }
        float currentX = ev.getX();
        float currentY = ev.getY();
        switch (ev.getActionMasked()) {
            case 0: {
                this.downX = this.lastEventX = currentX;
                this.downY = this.lastEventY = currentY;
                this.scroller.abortAnimation();
                this.isActionDown = true;
                break;
            }
            case 2: {
                if (!this.isActionDown) {
                    this.downX = this.lastEventX = currentX;
                    this.downY = this.lastEventY = currentY;
                    this.scroller.abortAnimation();
                    this.isActionDown = true;
                }
                float shiftX = Math.abs(currentX - this.downX);
                float shiftY = Math.abs(currentY - this.downY);
                float dx = currentX - this.lastEventX;
                float dy = currentY - this.lastEventY;
                this.lastEventY = currentY;
                if (!this.isTop() || !(shiftY > shiftX) || !(shiftY > (float)this.touchSlop)) break;
                int height = (int)((double)((float)this.headerParams.height + dy / this.sensitive) + 0.5);
                if (height <= this.headerHeight) {
                    height = this.headerHeight;
                    this.isZooming = false;
                } else {
                    this.isZooming = true;
                }
                this.headerParams.height = height;
                this.headerView.setLayoutParams((ViewGroup.LayoutParams)this.headerParams);
                if (this.pullZoomListener == null) break;
                this.pullZoomListener.onPullZoom(this.headerHeight, this.headerParams.height);
                break;
            }
            case 1: 
            case 3: {
                this.isActionDown = false;
                if (!this.isZooming) break;
                this.scroller.startScroll(0, this.headerParams.height, 0, -(this.headerParams.height - this.headerHeight), this.zoomTime);
                this.isZooming = false;
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }
        return this.isZooming || super.onTouchEvent(ev);
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.scroller.computeScrollOffset()) {
            this.isStartScroll = true;
            this.headerParams.height = this.scroller.getCurrY();
            this.headerView.setLayoutParams((ViewGroup.LayoutParams)this.headerParams);
            if (this.pullZoomListener != null) {
                this.pullZoomListener.onPullZoom(this.headerHeight, this.headerParams.height);
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        } else if (this.pullZoomListener != null && this.isStartScroll) {
            this.isStartScroll = false;
            this.pullZoomListener.onZoomFinish();
        }
    }

    private boolean isTop() {
        return this.getScrollY() <= 0;
    }

    public void setSensitive(float sensitive) {
        this.sensitive = sensitive;
    }

    public void setIsParallax(boolean isParallax) {
        this.isParallax = isParallax;
    }

    public void setIsZoomEnable(boolean isZoomEnable) {
        this.isZoomEnable = isZoomEnable;
    }

    public void setZoomTime(int zoomTime) {
        this.zoomTime = zoomTime;
    }

    public static abstract class OnPullZoomListener {
        public void onPullZoom(int originHeight, int currentHeight) {
        }

        public void onZoomFinish() {
        }
    }

    public static abstract class OnScrollListener {
        public void onScroll(int l, int t, int oldl, int oldt) {
        }

        public void onHeaderScroll(int currentY, int maxY) {
        }

        public void onContentScroll(int l, int t, int oldl, int oldt) {
        }
    }
}

