/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.LinearLayout;
import android.widget.Scroller;
import com.lzy.widget.HeaderScrollHelper;
import com.lzy.widget.R;

public class HeaderViewPager
extends LinearLayout {
    private static final int DIRECTION_UP = 1;
    private static final int DIRECTION_DOWN = 2;
    private int topOffset = 0;
    private Scroller mScroller;
    private int mTouchSlop;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int sysVersion;
    private View mHeadView;
    private int mHeadHeight;
    private int maxY = 0;
    private int minY = 0;
    private int mCurY;
    private VelocityTracker mVelocityTracker;
    private int mDirection;
    private int mLastScrollerY;
    private boolean mDisallowIntercept;
    private boolean isClickHead;
    private OnScrollListener onScrollListener;
    private HeaderScrollHelper mScrollable;
    private float mDownX;
    private float mDownY;
    private float mLastY;
    private boolean verticalScrollFlag = false;

    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.onScrollListener = onScrollListener;
    }

    public HeaderViewPager(Context context) {
        this(context, null);
    }

    public HeaderViewPager(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HeaderViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.HeaderViewPager);
        this.topOffset = a.getDimensionPixelSize(a.getIndex(R.styleable.HeaderViewPager_hvp_topOffset), this.topOffset);
        a.recycle();
        this.mScroller = new Scroller(context);
        this.mScrollable = new HeaderScrollHelper();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.sysVersion = Build.VERSION.SDK_INT;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mHeadView != null && !this.mHeadView.isClickable()) {
            this.mHeadView.setClickable(true);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mHeadView = this.getChildAt(0);
        this.measureChildWithMargins(this.mHeadView, widthMeasureSpec, 0, 0, 0);
        this.mHeadHeight = this.mHeadView.getMeasuredHeight();
        this.maxY = this.mHeadHeight - this.topOffset;
        super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)heightMeasureSpec) + this.maxY), (int)0x40000000));
    }

    public void requestHeaderViewPagerDisallowInterceptTouchEvent(boolean disallowIntercept) {
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
        this.mDisallowIntercept = disallowIntercept;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        float currentX = ev.getX();
        float currentY = ev.getY();
        float shiftX = Math.abs(currentX - this.mDownX);
        float shiftY = Math.abs(currentY - this.mDownY);
        this.obtainVelocityTracker(ev);
        switch (ev.getAction()) {
            case 0: {
                this.mDisallowIntercept = false;
                this.verticalScrollFlag = false;
                this.mDownX = currentX;
                this.mDownY = currentY;
                this.mLastY = currentY;
                this.checkIsClickHead((int)currentY, this.mHeadHeight, this.getScrollY());
                this.mScroller.abortAnimation();
                break;
            }
            case 2: {
                if (this.mDisallowIntercept) break;
                float deltaY = this.mLastY - currentY;
                this.mLastY = currentY;
                if (shiftX > (float)this.mTouchSlop && shiftX > shiftY) {
                    this.verticalScrollFlag = false;
                } else if (shiftY > (float)this.mTouchSlop && shiftY > shiftX) {
                    this.verticalScrollFlag = true;
                }
                if (!this.verticalScrollFlag || this.isStickied() && !this.mScrollable.isTop() && !this.isClickHead) break;
                this.scrollBy(0, (int)((double)deltaY + 0.5));
                this.invalidate();
                break;
            }
            case 1: {
                if (this.verticalScrollFlag) {
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                    float yVelocity = this.mVelocityTracker.getYVelocity();
                    this.mDirection = yVelocity > 0.0f ? 2 : 1;
                    this.mScroller.fling(0, this.getScrollY(), 0, -((int)yVelocity), 0, 0, -2147483647, Integer.MAX_VALUE);
                    this.mLastScrollerY = this.getScrollY();
                    this.invalidate();
                    if ((shiftX > (float)this.mTouchSlop || shiftY > (float)this.mTouchSlop) && (this.isClickHead || !this.isStickied())) {
                        int action = ev.getAction();
                        ev.setAction(3);
                        boolean dd = super.dispatchTouchEvent(ev);
                        ev.setAction(action);
                        return dd;
                    }
                }
                this.recycleVelocityTracker();
                break;
            }
            case 3: {
                this.recycleVelocityTracker();
                break;
            }
        }
        super.dispatchTouchEvent(ev);
        return true;
    }

    private void checkIsClickHead(int downY, int headHeight, int scrollY) {
        this.isClickHead = downY + scrollY <= headHeight;
    }

    private void obtainVelocityTracker(MotionEvent event) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int currY = this.mScroller.getCurrY();
            if (this.mDirection == 1) {
                if (this.isStickied()) {
                    int distance = this.mScroller.getFinalY() - currY;
                    int duration = this.calcDuration(this.mScroller.getDuration(), this.mScroller.timePassed());
                    this.mScrollable.smoothScrollBy(this.getScrollerVelocity(distance, duration), distance, duration);
                    this.mScroller.abortAnimation();
                    return;
                }
                this.scrollTo(0, currY);
                this.invalidate();
            } else {
                if (this.mScrollable.isTop() || this.isClickHead) {
                    int deltaY = currY - this.mLastScrollerY;
                    int toY = this.getScrollY() + deltaY;
                    this.scrollTo(0, toY);
                    if (this.mCurY <= this.minY) {
                        this.mScroller.abortAnimation();
                        return;
                    }
                }
                this.invalidate();
            }
            this.mLastScrollerY = currY;
        }
    }

    @SuppressLint(value={"NewApi"})
    private int getScrollerVelocity(int distance, int duration) {
        if (this.mScroller == null) {
            return 0;
        }
        if (this.sysVersion >= 14) {
            return (int)this.mScroller.getCurrVelocity();
        }
        return distance / duration;
    }

    public void scrollBy(int x, int y) {
        int scrollY = this.getScrollY();
        int toY = scrollY + y;
        if (toY >= this.maxY) {
            toY = this.maxY;
        } else if (toY <= this.minY) {
            toY = this.minY;
        }
        y = toY - scrollY;
        super.scrollBy(x, y);
    }

    public void scrollTo(int x, int y) {
        if (y >= this.maxY) {
            y = this.maxY;
        } else if (y <= this.minY) {
            y = this.minY;
        }
        this.mCurY = y;
        if (this.onScrollListener != null) {
            this.onScrollListener.onScroll(y, this.maxY);
        }
        super.scrollTo(x, y);
    }

    public boolean isStickied() {
        return this.mCurY == this.maxY;
    }

    private int calcDuration(int duration, int timepass) {
        return duration - timepass;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public boolean isHeadTop() {
        return this.mCurY == this.minY;
    }

    public boolean canPtr() {
        return this.verticalScrollFlag && this.mCurY == this.minY && this.mScrollable.isTop();
    }

    public void setTopOffset(int topOffset) {
        this.topOffset = topOffset;
    }

    public void setCurrentScrollableContainer(HeaderScrollHelper.ScrollableContainer scrollableContainer) {
        this.mScrollable.setCurrentScrollableContainer(scrollableContainer);
    }

    public static interface OnScrollListener {
        public void onScroll(int var1, int var2);
    }
}

