/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget;

import android.annotation.SuppressLint;
import android.os.Build;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ScrollView;

public class HeaderScrollHelper {
    private int sysVersion = Build.VERSION.SDK_INT;
    private ScrollableContainer mCurrentScrollableContainer;

    public void setCurrentScrollableContainer(ScrollableContainer scrollableContainer) {
        this.mCurrentScrollableContainer = scrollableContainer;
    }

    private View getScrollableView() {
        if (this.mCurrentScrollableContainer == null) {
            return null;
        }
        return this.mCurrentScrollableContainer.getScrollableView();
    }

    public boolean isTop() {
        View scrollableView = this.getScrollableView();
        if (scrollableView == null) {
            throw new NullPointerException("You should call ScrollableHelper.setCurrentScrollableContainer() to set ScrollableContainer.");
        }
        if (scrollableView instanceof AdapterView) {
            return this.isAdapterViewTop((AdapterView)scrollableView);
        }
        if (scrollableView instanceof ScrollView) {
            return this.isScrollViewTop((ScrollView)scrollableView);
        }
        if (scrollableView instanceof RecyclerView) {
            return this.isRecyclerViewTop((RecyclerView)scrollableView);
        }
        if (scrollableView instanceof WebView) {
            return this.isWebViewTop((WebView)scrollableView);
        }
        throw new IllegalStateException("scrollableView must be a instance of AdapterView|ScrollView|RecyclerView");
    }

    private boolean isRecyclerViewTop(RecyclerView recyclerView) {
        RecyclerView.LayoutManager layoutManager;
        if (recyclerView != null && (layoutManager = recyclerView.getLayoutManager()) instanceof LinearLayoutManager) {
            int firstVisibleItemPosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            View childAt = recyclerView.getChildAt(0);
            if (childAt == null || firstVisibleItemPosition == 0 && childAt.getTop() == 0) {
                return true;
            }
        }
        return false;
    }

    private boolean isAdapterViewTop(AdapterView adapterView) {
        if (adapterView != null) {
            int firstVisiblePosition = adapterView.getFirstVisiblePosition();
            View childAt = adapterView.getChildAt(0);
            if (childAt == null || firstVisiblePosition == 0 && childAt.getTop() == 0) {
                return true;
            }
        }
        return false;
    }

    private boolean isScrollViewTop(ScrollView scrollView) {
        if (scrollView != null) {
            int scrollViewY = scrollView.getScrollY();
            return scrollViewY <= 0;
        }
        return false;
    }

    private boolean isWebViewTop(WebView scrollView) {
        if (scrollView != null) {
            int scrollViewY = scrollView.getScrollY();
            return scrollViewY <= 0;
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    public void smoothScrollBy(int velocityY, int distance, int duration) {
        View scrollableView = this.getScrollableView();
        if (scrollableView instanceof AbsListView) {
            AbsListView absListView = (AbsListView)scrollableView;
            if (this.sysVersion >= 21) {
                absListView.fling(velocityY);
            } else {
                absListView.smoothScrollBy(distance, duration);
            }
        } else if (scrollableView instanceof ScrollView) {
            ((ScrollView)scrollableView).fling(velocityY);
        } else if (scrollableView instanceof RecyclerView) {
            ((RecyclerView)scrollableView).fling(0, velocityY);
        } else if (scrollableView instanceof WebView) {
            ((WebView)scrollableView).flingScroll(0, velocityY);
        }
    }

    public static interface ScrollableContainer {
        public View getScrollableView();
    }
}

