/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.lzy.widget.R;

public class AlphaView
extends View {
    private Bitmap mIconNormal;
    private Bitmap mIconSelected;
    private String mText;
    private int mTextColorNormal = -6710887;
    private int mTextColorSelected = -12140517;
    private int mTextSize = 12;
    private int padding = 5;
    private float mAlpha;
    private Paint mSelectedPaint = new Paint();
    private Rect mIconAvailableRect = new Rect();
    private Rect mIconDrawRect = new Rect();
    private Paint mTextPaint;
    private Rect mTextBound;
    private Paint.FontMetricsInt mFmi;

    public AlphaView(Context context) {
        this(context, null);
    }

    public AlphaView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AlphaView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        BitmapDrawable iconSelected;
        this.mTextSize = (int)TypedValue.applyDimension((int)2, (float)this.mTextSize, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.padding = (int)TypedValue.applyDimension((int)1, (float)this.padding, (DisplayMetrics)this.getResources().getDisplayMetrics());
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AlphaView);
        BitmapDrawable iconNormal = (BitmapDrawable)a.getDrawable(R.styleable.AlphaView_av_tabIconNormal);
        if (iconNormal != null) {
            this.mIconNormal = iconNormal.getBitmap();
        }
        if ((iconSelected = (BitmapDrawable)a.getDrawable(R.styleable.AlphaView_av_tabIconSelected)) != null) {
            this.mIconSelected = iconSelected.getBitmap();
        }
        this.mText = a.getString(R.styleable.AlphaView_av_tabText);
        this.mTextSize = a.getDimensionPixelSize(R.styleable.AlphaView_av_tabTextSize, this.mTextSize);
        this.mTextColorNormal = a.getColor(R.styleable.AlphaView_av_textColorNormal, this.mTextColorNormal);
        this.mTextColorSelected = a.getColor(R.styleable.AlphaView_av_textColorSelected, this.mTextColorSelected);
        a.recycle();
        this.initText();
    }

    private void initText() {
        if (this.mText != null) {
            this.mTextBound = new Rect();
            this.mTextPaint = new Paint();
            this.mTextPaint.setTextSize((float)this.mTextSize);
            this.mTextPaint.setAntiAlias(true);
            this.mTextPaint.setDither(true);
            this.mTextPaint.getTextBounds(this.mText, 0, this.mText.length(), this.mTextBound);
            this.mFmi = this.mTextPaint.getFontMetricsInt();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mText == null && (this.mIconNormal == null || this.mIconSelected == null)) {
            throw new IllegalArgumentException("\u5fc5\u987b\u8bbe\u7f6e tabText \u6216\u8005 tabIconSelected\u3001tabIconNormal \u4e24\u4e2a\uff0c\u6216\u8005\u5168\u90e8\u8bbe\u7f6e");
        }
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int measuredWidth = this.getMeasuredWidth();
        int measuredHeight = this.getMeasuredHeight();
        int availableWidth = measuredWidth - paddingLeft - paddingRight;
        int availableHeight = measuredHeight - paddingTop - paddingBottom;
        if (this.mText != null && this.mIconNormal != null) {
            this.mIconAvailableRect.set(paddingLeft, paddingTop, paddingLeft + availableWidth, paddingTop + (availableHeight -= this.mTextBound.height() + this.padding));
            int textLeft = paddingLeft + (availableWidth - this.mTextBound.width()) / 2;
            int textTop = this.mIconAvailableRect.bottom + this.padding;
            this.mTextBound.set(textLeft, textTop, textLeft + this.mTextBound.width(), textTop + this.mTextBound.height());
        } else if (this.mText == null) {
            this.mIconAvailableRect.set(paddingLeft, paddingTop, paddingLeft + availableWidth, paddingTop + availableHeight);
        } else if (this.mIconNormal == null) {
            int textLeft = paddingLeft + (availableWidth - this.mTextBound.width()) / 2;
            int textTop = paddingTop + (availableHeight - this.mTextBound.height()) / 2;
            this.mTextBound.set(textLeft, textTop, textLeft + this.mTextBound.width(), textTop + this.mTextBound.height());
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int alpha = (int)Math.ceil(this.mAlpha * 255.0f);
        if (this.mIconNormal != null && this.mIconSelected != null) {
            Rect drawRect = this.availableToDrawRect(this.mIconAvailableRect, this.mIconNormal);
            this.mSelectedPaint.reset();
            this.mSelectedPaint.setAntiAlias(true);
            this.mSelectedPaint.setFilterBitmap(true);
            this.mSelectedPaint.setAlpha(255 - alpha);
            canvas.drawBitmap(this.mIconNormal, null, drawRect, this.mSelectedPaint);
            this.mSelectedPaint.reset();
            this.mSelectedPaint.setAntiAlias(true);
            this.mSelectedPaint.setFilterBitmap(true);
            this.mSelectedPaint.setAlpha(alpha);
            canvas.drawBitmap(this.mIconSelected, null, drawRect, this.mSelectedPaint);
        }
        if (this.mText != null) {
            this.mTextPaint.setColor(this.mTextColorNormal);
            this.mTextPaint.setAlpha(255 - alpha);
            canvas.drawText(this.mText, (float)this.mTextBound.left, (float)(this.mTextBound.bottom - this.mFmi.bottom / 2), this.mTextPaint);
            this.mTextPaint.setColor(this.mTextColorSelected);
            this.mTextPaint.setAlpha(alpha);
            canvas.drawText(this.mText, (float)this.mTextBound.left, (float)(this.mTextBound.bottom - this.mFmi.bottom / 2), this.mTextPaint);
        }
    }

    private Rect availableToDrawRect(Rect availableRect, Bitmap bitmap) {
        float hRatio;
        float dx = 0.0f;
        float dy = 0.0f;
        float wRatio = (float)availableRect.width() * 1.0f / (float)bitmap.getWidth();
        if (wRatio > (hRatio = (float)availableRect.height() * 1.0f / (float)bitmap.getHeight())) {
            dx = ((float)availableRect.width() - hRatio * (float)bitmap.getWidth()) / 2.0f;
        } else {
            dy = ((float)availableRect.height() - wRatio * (float)bitmap.getHeight()) / 2.0f;
        }
        int left = (int)((float)availableRect.left + dx + 0.5f);
        int top = (int)((float)availableRect.top + dy + 0.5f);
        int right = (int)((float)availableRect.right - dx + 0.5f);
        int bottom = (int)((float)availableRect.bottom - dy + 0.5f);
        this.mIconDrawRect.set(left, top, right, bottom);
        return this.mIconDrawRect;
    }

    public void setIconAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("\u900f\u660e\u5ea6\u5fc5\u987b\u662f 0.0 - 1.0");
        }
        this.mAlpha = alpha;
        this.invalidateView();
    }

    private void invalidateView() {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            this.invalidate();
        } else {
            this.postInvalidate();
        }
    }
}

