/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget.tab;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.lzy.widget.R;

public class TabTitleIndicator
extends HorizontalScrollView {
    private int indicatorHeight = 4;
    private int indicatorColor = -16743169;
    private int underlineHeight = 2;
    private int underlineColor = 0x1A000000;
    private int dividerWidth = 1;
    private int dividerPaddingTopBottom = 12;
    private int dividerColor = 0x1A000000;
    private int triangleHeight = 4;
    private int tabPaddingLeftRight = 20;
    private int tabTextSizeNormal = 16;
    private int tabTextSizeSelected = 18;
    private int tabTextColorNormal = -10066330;
    private int tabTextColorSelected = -16743169;
    private int tabBackgroundResId = R.drawable.tab_background_selector;
    private int scrollOffset = 100;
    private int visibleCount = 4;
    private LinearLayout tabsContainer;
    private PageListener mPagerChangeListener;
    private ViewPager mViewPager;
    private int tabCount;
    private int tabWidth;
    private int currentPosition = 0;
    private float currentPositionOffset = 0.0f;
    private Paint rectPaint;
    private Paint dividerPaint;
    private Paint trianglePaint;
    private Path trianglePath;
    private boolean isRestoreInstanceState;
    private boolean isDetached = false;

    public TabTitleIndicator(Context context) {
        this(context, null);
    }

    public TabTitleIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TabTitleIndicator(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        System.out.println("TabTitleIndicator");
        this.setFillViewport(true);
        this.setWillNotDraw(false);
        this.tabsContainer = new LinearLayout(context);
        this.tabsContainer.setOrientation(0);
        this.tabsContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.tabsContainer);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.scrollOffset = (int)TypedValue.applyDimension((int)1, (float)this.scrollOffset, (DisplayMetrics)dm);
        this.indicatorHeight = (int)TypedValue.applyDimension((int)1, (float)this.indicatorHeight, (DisplayMetrics)dm);
        this.underlineHeight = (int)TypedValue.applyDimension((int)1, (float)this.underlineHeight, (DisplayMetrics)dm);
        this.dividerWidth = (int)TypedValue.applyDimension((int)1, (float)this.dividerWidth, (DisplayMetrics)dm);
        this.dividerPaddingTopBottom = (int)TypedValue.applyDimension((int)1, (float)this.dividerPaddingTopBottom, (DisplayMetrics)dm);
        this.triangleHeight = (int)TypedValue.applyDimension((int)1, (float)this.triangleHeight, (DisplayMetrics)dm);
        this.tabPaddingLeftRight = (int)TypedValue.applyDimension((int)1, (float)this.tabPaddingLeftRight, (DisplayMetrics)dm);
        this.tabTextSizeNormal = (int)TypedValue.applyDimension((int)2, (float)this.tabTextSizeNormal, (DisplayMetrics)dm);
        this.tabTextSizeSelected = (int)TypedValue.applyDimension((int)2, (float)this.tabTextSizeSelected, (DisplayMetrics)dm);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabTitleIndicator);
        this.indicatorHeight = a.getDimensionPixelSize(R.styleable.TabTitleIndicator_tti_indicatorHeight, this.indicatorHeight);
        this.indicatorColor = a.getColor(R.styleable.TabTitleIndicator_tti_indicatorColor, this.indicatorColor);
        this.underlineHeight = a.getDimensionPixelSize(R.styleable.TabTitleIndicator_tti_underlineHeight, this.underlineHeight);
        this.underlineColor = a.getColor(R.styleable.TabTitleIndicator_tti_underlineColor, this.underlineColor);
        this.dividerWidth = a.getDimensionPixelSize(R.styleable.TabTitleIndicator_tti_dividerWidth, this.dividerWidth);
        this.dividerPaddingTopBottom = a.getDimensionPixelSize(R.styleable.TabTitleIndicator_tti_dividerPaddingTopBottom, this.dividerPaddingTopBottom);
        this.dividerColor = a.getColor(R.styleable.TabTitleIndicator_tti_dividerColor, this.dividerColor);
        this.triangleHeight = a.getDimensionPixelSize(R.styleable.TabTitleIndicator_tti_triangleHeight, this.triangleHeight);
        this.tabTextSizeNormal = a.getDimensionPixelSize(R.styleable.TabTitleIndicator_tti_tabTextSizeNormal, this.tabTextSizeNormal);
        this.tabTextSizeSelected = a.getDimensionPixelSize(R.styleable.TabTitleIndicator_tti_tabTextSizeSelected, this.tabTextSizeSelected);
        this.tabTextColorNormal = a.getColor(R.styleable.TabTitleIndicator_tti_tabTextColorNormal, this.tabTextColorNormal);
        this.tabTextColorSelected = a.getColor(R.styleable.TabTitleIndicator_tti_tabTextColorSelected, this.tabTextColorSelected);
        this.tabPaddingLeftRight = a.getDimensionPixelSize(R.styleable.TabTitleIndicator_tti_tabPaddingLeftRight, this.tabPaddingLeftRight);
        this.tabBackgroundResId = a.getResourceId(R.styleable.TabTitleIndicator_tti_tabBackground, this.tabBackgroundResId);
        this.visibleCount = a.getInteger(R.styleable.TabTitleIndicator_tti_visibleCount, this.visibleCount);
        this.scrollOffset = a.getDimensionPixelSize(R.styleable.TabTitleIndicator_tti_scrollOffset, this.scrollOffset);
        a.recycle();
        this.initPaint();
    }

    private void initPaint() {
        this.rectPaint = new Paint();
        this.rectPaint.setAntiAlias(true);
        this.rectPaint.setStyle(Paint.Style.FILL);
        this.dividerPaint = new Paint();
        this.dividerPaint.setAntiAlias(true);
        this.dividerPaint.setStrokeWidth((float)this.dividerWidth);
        this.trianglePaint = new Paint();
        this.trianglePaint.setAntiAlias(true);
        this.trianglePaint.setStyle(Paint.Style.FILL);
        this.trianglePath = new Path();
    }

    public void setViewPager(ViewPager pager) {
        System.out.println("setViewPager");
        this.mViewPager = pager;
        if (this.mViewPager == null || this.mViewPager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005ViewPager\u6ca1\u6709\u8bbe\u7f6eAdapter\uff01");
        }
        this.mPagerChangeListener = new PageListener();
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.mPagerChangeListener);
        this.tabCount = this.mViewPager.getAdapter().getCount();
        this.currentPosition = this.mViewPager.getCurrentItem();
        this.addTitleItems();
    }

    public void addTitleItems() {
        if (this.mViewPager == null || this.mViewPager.getAdapter() == null) {
            throw new IllegalStateException("\u5fc5\u987b\u8c03\u7528setViewPager()\u65b9\u6cd5!");
        }
        this.tabsContainer.removeAllViews();
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -1);
        for (int i = 0; i < this.tabCount; ++i) {
            final int finalI = i;
            if (this.mViewPager.getAdapter() instanceof IconTabProvider) {
                int resId = ((IconTabProvider)this.mViewPager.getAdapter()).getPageIconResId(i);
                ImageButton tab = new ImageButton(this.getContext());
                tab.setLayoutParams((ViewGroup.LayoutParams)params);
                tab.setFocusable(true);
                tab.setImageResource(resId);
                tab.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (TabTitleIndicator.this.mViewPager != null) {
                            TabTitleIndicator.this.mViewPager.setCurrentItem(finalI);
                        }
                    }
                });
                this.tabsContainer.addView((View)tab);
                continue;
            }
            TextView tab = new TextView(this.getContext());
            tab.setLayoutParams((ViewGroup.LayoutParams)params);
            tab.setText((CharSequence)this.mViewPager.getAdapter().getPageTitle(i).toString());
            tab.setFocusable(true);
            tab.setGravity(17);
            tab.setSingleLine(true);
            tab.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (TabTitleIndicator.this.mViewPager != null) {
                        TabTitleIndicator.this.mViewPager.setCurrentItem(finalI);
                    }
                }
            });
            this.tabsContainer.addView((View)tab);
        }
        this.updateTabStyles();
    }

    private void updateTabStyles() {
        for (int i = 0; i < this.tabCount; ++i) {
            View tab = this.tabsContainer.getChildAt(i);
            tab.setBackgroundResource(this.tabBackgroundResId);
            if (this.visibleCount != 0) {
                tab.setPadding(0, 0, 0, 0);
            } else {
                tab.setPadding(this.tabPaddingLeftRight, 0, this.tabPaddingLeftRight, 0);
            }
            if (!(tab instanceof TextView)) continue;
            TextView textView = (TextView)tab;
            textView.setTextSize(0, i == this.currentPosition ? (float)this.tabTextSizeSelected : (float)this.tabTextSizeNormal);
            textView.setTextColor(i == this.currentPosition ? this.tabTextColorSelected : this.tabTextColorNormal);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        System.out.println("onMeasure " + this.getMeasuredWidth() + "  " + this.getMeasuredHeight() + "  " + this.visibleCount);
        if (this.visibleCount != 0 && this.tabCount != 0) {
            this.visibleCount = Math.min(this.visibleCount, this.tabCount);
            this.scrollOffset = this.tabWidth = (this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()) / this.visibleCount;
            System.out.println("tabWidth " + this.tabWidth);
            if (this.visibleCount == 1) {
                this.scrollOffset = 0;
            }
            for (int i = 0; i < this.tabsContainer.getChildCount(); ++i) {
                View tabItem = this.tabsContainer.getChildAt(i);
                ViewGroup.LayoutParams params = tabItem.getLayoutParams();
                params.width = this.tabWidth;
                tabItem.setLayoutParams(params);
                tabItem.measure(View.MeasureSpec.makeMeasureSpec((int)this.tabWidth, (int)0x40000000), heightMeasureSpec);
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        System.out.println("onLayout " + this.currentPosition + "  " + this.isRestoreInstanceState);
        if (this.isRestoreInstanceState) {
            System.out.println("---onLayout  " + this.currentPosition);
            this.scrollToChild(this.currentPosition, 0);
            this.isRestoreInstanceState = false;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        System.out.println("onAttachedToWindow " + this.isDetached + "  " + (this.mViewPager != null) + "  " + (this.mPagerChangeListener != null));
        if (this.isDetached && this.mViewPager != null && this.mPagerChangeListener != null) {
            this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.mPagerChangeListener);
            this.isDetached = false;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        System.out.println("onDetachedFromWindow");
        if (this.mViewPager != null && this.mPagerChangeListener != null) {
            this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this.mPagerChangeListener);
        }
        this.isDetached = true;
    }

    public Parcelable onSaveInstanceState() {
        System.out.println("onSaveInstanceState " + this.currentPosition);
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putInt("currentPosition", this.currentPosition);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        System.out.println("onRestoreInstanceState " + this.currentPosition);
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            super.onRestoreInstanceState(bundle.getParcelable("superState"));
            this.currentPosition = bundle.getInt("currentPosition");
        } else {
            super.onRestoreInstanceState(state);
        }
        this.isRestoreInstanceState = true;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode() || this.tabCount == 0) {
            return;
        }
        int height = this.getHeight();
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        this.rectPaint.setColor(this.indicatorColor);
        View currentTab = this.tabsContainer.getChildAt(this.currentPosition);
        float lineLeft = currentTab.getLeft() + paddingLeft;
        float lineRight = currentTab.getRight() + paddingLeft;
        if (this.currentPositionOffset > 0.0f && this.currentPosition < this.tabCount - 1) {
            View nextTab = this.tabsContainer.getChildAt(this.currentPosition + 1);
            float nextTabLeft = nextTab.getLeft() + paddingLeft;
            float nextTabRight = nextTab.getRight() + paddingLeft;
            lineLeft = this.currentPositionOffset * nextTabLeft + (1.0f - this.currentPositionOffset) * lineLeft;
            lineRight = this.currentPositionOffset * nextTabRight + (1.0f - this.currentPositionOffset) * lineRight;
        }
        canvas.drawRect(lineLeft, (float)(height - this.indicatorHeight - paddingBottom), lineRight, (float)(height - paddingBottom), this.rectPaint);
        this.trianglePaint.setColor(this.indicatorColor);
        float centerX = (lineLeft + lineRight) / 2.0f;
        this.trianglePath.moveTo(centerX - (float)(this.triangleHeight + this.indicatorHeight), (float)(height - paddingBottom));
        this.trianglePath.lineTo(centerX + (float)(this.triangleHeight + this.indicatorHeight), (float)(height - paddingBottom));
        this.trianglePath.lineTo(centerX, (float)(height - paddingBottom - (this.triangleHeight + this.indicatorHeight)));
        this.trianglePath.close();
        canvas.drawPath(this.trianglePath, this.trianglePaint);
        this.trianglePath.reset();
        this.rectPaint.setColor(this.underlineColor);
        canvas.drawRect((float)(paddingLeft + this.getScrollX()), (float)(height - this.underlineHeight - paddingBottom), (float)(this.getScrollX() + this.getWidth() - paddingRight), (float)(height - paddingBottom), this.rectPaint);
        this.dividerPaint.setColor(this.dividerColor);
        for (int i = 0; i < this.tabCount - 1; ++i) {
            View tab = this.tabsContainer.getChildAt(i);
            canvas.drawLine((float)(tab.getRight() + paddingLeft), (float)(this.dividerPaddingTopBottom + paddingTop), (float)(tab.getRight() + paddingLeft), (float)(height - this.dividerPaddingTopBottom - paddingBottom), this.dividerPaint);
        }
    }

    private void scrollToChild(int position, int offset) {
        if (this.tabCount == 0) {
            return;
        }
        int newScrollX = this.tabsContainer.getChildAt(position).getLeft() + offset;
        if (position > 0 || offset > 0) {
            newScrollX -= this.scrollOffset;
        }
        System.out.println("newScrollX  " + newScrollX);
        this.scrollTo(newScrollX, 0);
    }

    public void setVisibleCount(int visibleCount) {
        this.visibleCount = visibleCount;
    }

    public void setIndicatorColor(int indicatorColor) {
        this.indicatorColor = indicatorColor;
        this.invalidate();
    }

    public void setIndicatorColorResource(int resId) {
        this.indicatorColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public int getIndicatorColor() {
        return this.indicatorColor;
    }

    public void setIndicatorHeight(int indicatorLineHeightPx) {
        this.indicatorHeight = indicatorLineHeightPx;
        this.invalidate();
    }

    public int getIndicatorHeight() {
        return this.indicatorHeight;
    }

    public void setUnderlineColor(int underlineColor) {
        this.underlineColor = underlineColor;
        this.invalidate();
    }

    public void setUnderlineColorResource(int resId) {
        this.underlineColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public int getUnderlineColor() {
        return this.underlineColor;
    }

    public void setDividerColor(int dividerColor) {
        this.dividerColor = dividerColor;
        this.invalidate();
    }

    public void setDividerColorResource(int resId) {
        this.dividerColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public int getDividerColor() {
        return this.dividerColor;
    }

    public void setUnderlineHeight(int underlineHeightPx) {
        this.underlineHeight = underlineHeightPx;
        this.invalidate();
    }

    public int getUnderlineHeight() {
        return this.underlineHeight;
    }

    public void setDividerPaddingTopBottom(int dividerPaddingPx) {
        this.dividerPaddingTopBottom = dividerPaddingPx;
        this.invalidate();
    }

    public int getDividerPaddingTopBottom() {
        return this.dividerPaddingTopBottom;
    }

    public void setScrollOffset(int scrollOffsetPx) {
        this.scrollOffset = scrollOffsetPx;
        this.invalidate();
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public void setTextSize(int textSizePx) {
        this.tabTextSizeNormal = textSizePx;
        this.updateTabStyles();
    }

    public int getTextSize() {
        return this.tabTextSizeNormal;
    }

    public void setTextColor(int textColor) {
        this.tabTextColorNormal = textColor;
        this.updateTabStyles();
    }

    public void setTextColorResource(int resId) {
        this.tabTextColorNormal = this.getResources().getColor(resId);
        this.updateTabStyles();
    }

    public int getTextColor() {
        return this.tabTextColorNormal;
    }

    public void setTabBackground(int resId) {
        this.tabBackgroundResId = resId;
    }

    public int getTabBackground() {
        return this.tabBackgroundResId;
    }

    public void setTabPaddingLeftRight(int paddingPx) {
        this.tabPaddingLeftRight = paddingPx;
        this.updateTabStyles();
    }

    public int getTabPaddingLeftRight() {
        return this.tabPaddingLeftRight;
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public void setCurrentPosition(int currentPosition) {
        this.currentPosition = currentPosition;
        this.mViewPager.setCurrentItem(currentPosition);
    }

    private class PageListener
    implements ViewPager.OnPageChangeListener {
        private PageListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            System.out.println("onPageScrolled " + position + "  " + positionOffset);
            TabTitleIndicator.this.currentPosition = position;
            TabTitleIndicator.this.currentPositionOffset = positionOffset;
            TabTitleIndicator.this.scrollToChild(position, (int)(positionOffset * (float)TabTitleIndicator.this.tabsContainer.getChildAt(position).getWidth()));
            TabTitleIndicator.this.invalidate();
        }

        public void onPageScrollStateChanged(int state) {
            if (state == 0) {
                TabTitleIndicator.this.scrollToChild(TabTitleIndicator.this.mViewPager.getCurrentItem(), 0);
            }
        }

        public void onPageSelected(int position) {
            for (int i = 0; i < TabTitleIndicator.this.tabCount; ++i) {
                View view = TabTitleIndicator.this.tabsContainer.getChildAt(i);
                if (!(view instanceof TextView)) continue;
                TextView textView = (TextView)view;
                textView.setTextSize(0, i == position ? (float)TabTitleIndicator.this.tabTextSizeSelected : (float)TabTitleIndicator.this.tabTextSizeNormal);
                textView.setTextColor(i == position ? TabTitleIndicator.this.tabTextColorSelected : TabTitleIndicator.this.tabTextColorNormal);
            }
        }
    }

    public static interface IconTabProvider {
        public int getPageIconResId(int var1);
    }
}

