/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget.tab;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.lzy.widget.R;

public class CircleIndicator
extends View {
    private float normalRadius = TypedValue.applyDimension((int)1, (float)this.normalRadius, (DisplayMetrics)this.getResources().getDisplayMetrics());
    private float selectedRadius = TypedValue.applyDimension((int)1, (float)this.selectedRadius, (DisplayMetrics)this.getResources().getDisplayMetrics());
    private int normalRadiusColor = -583847117;
    private int selectedRadiusColor = -1426128896;
    private float dotPadding = TypedValue.applyDimension((int)1, (float)this.dotPadding, (DisplayMetrics)this.getResources().getDisplayMetrics());
    private boolean isStroke = true;
    private float normalStrokeWidth = TypedValue.applyDimension((int)1, (float)this.normalStrokeWidth, (DisplayMetrics)this.getResources().getDisplayMetrics());
    private boolean isBlink = false;
    private int dotNum;
    private Paint mNormalPaint;
    private Paint mSelectedPaint;
    private float mCx;
    private float mCy;
    private ViewPager mViewPager;
    private MyOnPageChangeListener mListener;
    private float mTranslationX;
    private boolean isDetached;

    public CircleIndicator(Context context) {
        this(context, null);
    }

    public CircleIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = this.getResources().obtainAttributes(attrs, R.styleable.CircleIndicator);
        this.normalRadius = a.getDimension(R.styleable.CircleIndicator_ci_normalRadius, this.normalRadius);
        this.selectedRadius = a.getDimension(R.styleable.CircleIndicator_ci_selectedRadius, this.selectedRadius);
        this.normalRadiusColor = a.getColor(R.styleable.CircleIndicator_ci_normalRadiusColor, this.normalRadiusColor);
        this.selectedRadiusColor = a.getColor(R.styleable.CircleIndicator_ci_selectedRadiusColor, this.selectedRadiusColor);
        this.dotPadding = a.getDimension(R.styleable.CircleIndicator_ci_dotPadding, this.dotPadding);
        this.isStroke = a.getBoolean(R.styleable.CircleIndicator_ci_isStroke, this.isStroke);
        this.normalStrokeWidth = a.getDimension(R.styleable.CircleIndicator_ci_normalStrokeWidth, this.normalStrokeWidth);
        this.isBlink = a.getBoolean(R.styleable.CircleIndicator_ci_isBlink, this.isBlink);
        a.recycle();
        this.initPaint();
    }

    private void initPaint() {
        this.mNormalPaint = new Paint();
        this.mNormalPaint.setAntiAlias(true);
        this.mNormalPaint.setColor(this.normalRadiusColor);
        this.mNormalPaint.setStrokeWidth(this.normalStrokeWidth);
        if (this.isStroke) {
            this.mNormalPaint.setStyle(Paint.Style.STROKE);
        } else {
            this.mNormalPaint.setStyle(Paint.Style.FILL);
        }
        this.mSelectedPaint = new Paint();
        this.mSelectedPaint.setAntiAlias(true);
        this.mSelectedPaint.setColor(this.selectedRadiusColor);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        float maxRadius = Math.max(this.normalRadius, this.selectedRadius);
        float availableWidth = w - this.getPaddingLeft() - this.getPaddingRight();
        float availableHeight = h - this.getPaddingTop() - this.getPaddingBottom();
        float drawWidth = (float)(this.dotNum - 1) * this.dotPadding + maxRadius * 2.0f;
        if (this.dotNum == 1) {
            drawWidth = maxRadius * 2.0f;
        }
        if (this.dotNum <= 0) {
            drawWidth = 0.0f;
        }
        this.mCx = (availableWidth - drawWidth) / 2.0f + maxRadius + (float)this.getPaddingLeft();
        this.mCy = availableHeight / 2.0f + (float)this.getPaddingTop();
    }

    protected void onDraw(Canvas canvas) {
        if (this.dotNum > 0) {
            for (int i = 0; i < this.dotNum; ++i) {
                canvas.drawCircle(this.mCx + (float)i * this.dotPadding, this.mCy, this.normalRadius, this.mNormalPaint);
            }
            canvas.drawCircle(this.mCx + this.mTranslationX, this.mCy, this.selectedRadius, this.mSelectedPaint);
        }
    }

    public CircleIndicator setViewPager(ViewPager viewPager) {
        this.mViewPager = viewPager;
        if (this.mViewPager == null || this.mViewPager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005ViewPager\u6ca1\u6709\u8bbe\u7f6eAdapter\uff01");
        }
        this.dotNum = this.mViewPager.getAdapter().getCount();
        this.mListener = new MyOnPageChangeListener();
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.mListener);
        return this;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isDetached && this.mViewPager != null && this.mListener != null) {
            this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.mListener);
            this.isDetached = false;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mViewPager != null && this.mListener != null) {
            this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this.mListener);
        }
        this.isDetached = true;
    }

    private class MyOnPageChangeListener
    extends ViewPager.SimpleOnPageChangeListener {
        private MyOnPageChangeListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (CircleIndicator.this.dotNum > 0) {
                if (CircleIndicator.this.isBlink) {
                    if (positionOffset == 0.0f) {
                        CircleIndicator.this.mTranslationX = (float)position * CircleIndicator.this.dotPadding;
                    }
                } else if (position == CircleIndicator.this.dotNum - 1 && positionOffset > 0.0f) {
                    CircleIndicator.this.mTranslationX = (float)(CircleIndicator.this.dotNum - 1) * CircleIndicator.this.dotPadding * (1.0f - positionOffset);
                } else {
                    CircleIndicator.this.mTranslationX = ((float)position + positionOffset) * CircleIndicator.this.dotPadding;
                }
                CircleIndicator.this.invalidate();
            }
        }
    }
}

