/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget.loop;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import com.lzy.widget.R;
import com.lzy.widget.loop.LoopAdapterWrapper;
import java.util.ArrayList;

public class LoopViewPager
extends ViewPager {
    private PagerAdapter mAdapter;
    private LoopAdapterWrapper mLoopAdapter;
    private ViewPager.OnPageChangeListener loopPageChangeListener = new MyOnPageChangeListener();
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private ArrayList<ViewPager.OnPageChangeListener> mOnPageChangeListeners;
    private Handler mHandler;
    private boolean mIsAutoLoop = true;
    private int mDelayTime = 3000;
    private boolean isDetached;
    private int currentPosition;

    public LoopViewPager(Context context) {
        this(context, null);
    }

    public LoopViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        super.addOnPageChangeListener(this.loopPageChangeListener);
        TypedArray a = this.getResources().obtainAttributes(attrs, R.styleable.LoopViewPager);
        this.mIsAutoLoop = a.getBoolean(R.styleable.LoopViewPager_lvp_isAutoLoop, this.mIsAutoLoop);
        this.mDelayTime = a.getInteger(R.styleable.LoopViewPager_lvp_delayTime, this.mDelayTime);
        a.recycle();
        this.setAutoLoop(this.mIsAutoLoop, this.mDelayTime);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isDetached) {
            if (this.loopPageChangeListener != null) {
                super.addOnPageChangeListener(this.loopPageChangeListener);
            }
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
                this.mHandler.sendEmptyMessageDelayed(0, (long)this.mDelayTime);
            }
            this.isDetached = false;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.loopPageChangeListener != null) {
            super.removeOnPageChangeListener(this.loopPageChangeListener);
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.isDetached = true;
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putInt("currentPosition", this.currentPosition);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            super.onRestoreInstanceState(bundle.getParcelable("superState"));
            this.currentPosition = bundle.getInt("currentPosition");
        } else {
            super.onRestoreInstanceState(state);
        }
        this.setCurrentItem(this.currentPosition);
    }

    public void setAdapter(PagerAdapter adapter) {
        this.mAdapter = adapter;
        this.mLoopAdapter = new LoopAdapterWrapper(adapter);
        super.setAdapter((PagerAdapter)this.mLoopAdapter);
        this.setCurrentItem(0, false);
    }

    public PagerAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        int realItem = this.mLoopAdapter == null ? 0 : this.mLoopAdapter.getInnerPosition(item);
        super.setCurrentItem(realItem, smoothScroll);
    }

    public void setCurrentItem(int item) {
        if (this.getCurrentItem() != item) {
            this.setCurrentItem(item, true);
        }
    }

    public int getCurrentItem() {
        return this.mLoopAdapter == null ? 0 : this.mLoopAdapter.toRealPosition(super.getCurrentItem());
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mOnPageChangeListener = listener;
    }

    public void addOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        if (this.mOnPageChangeListeners == null) {
            this.mOnPageChangeListeners = new ArrayList();
        }
        this.mOnPageChangeListeners.add(listener);
    }

    public void removeOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        if (this.mOnPageChangeListeners != null) {
            this.mOnPageChangeListeners.remove(listener);
        }
    }

    public void setAutoLoop(boolean isAutoLoop, int delayTime) {
        this.mIsAutoLoop = isAutoLoop;
        this.mDelayTime = delayTime;
        if (this.mIsAutoLoop) {
            if (this.mHandler == null) {
                this.mHandler = new InnerHandler();
                this.mHandler.sendEmptyMessageDelayed(0, (long)this.mDelayTime);
            } else {
                this.mHandler.removeCallbacksAndMessages(null);
                this.mHandler.sendEmptyMessageDelayed(0, (long)this.mDelayTime);
            }
        } else if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
    }

    private class InnerHandler
    extends Handler {
        private InnerHandler() {
        }

        public void handleMessage(Message msg) {
            LoopViewPager.this.setCurrentItem(LoopViewPager.this.getCurrentItem() + 1);
            this.sendEmptyMessageDelayed(0, LoopViewPager.this.mDelayTime);
        }
    }

    private class MyOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private MyOnPageChangeListener() {
        }

        public void onPageSelected(int position) {
            int realPosition = LoopViewPager.this.mLoopAdapter == null ? 0 : LoopViewPager.this.mLoopAdapter.toRealPosition(position);
            LoopViewPager.this.currentPosition = realPosition;
            if (LoopViewPager.this.mOnPageChangeListener != null) {
                LoopViewPager.this.mOnPageChangeListener.onPageSelected(realPosition);
            }
            if (LoopViewPager.this.mOnPageChangeListeners != null) {
                int z = LoopViewPager.this.mOnPageChangeListeners.size();
                for (int i = 0; i < z; ++i) {
                    ViewPager.OnPageChangeListener listener = (ViewPager.OnPageChangeListener)LoopViewPager.this.mOnPageChangeListeners.get(i);
                    if (listener == null) continue;
                    listener.onPageSelected(realPosition);
                }
            }
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            int realPosition;
            int n = realPosition = LoopViewPager.this.mLoopAdapter == null ? 0 : LoopViewPager.this.mLoopAdapter.toRealPosition(position);
            if (LoopViewPager.this.mOnPageChangeListener != null) {
                LoopViewPager.this.mOnPageChangeListener.onPageScrolled(realPosition, positionOffset, positionOffsetPixels);
            }
            if (LoopViewPager.this.mOnPageChangeListeners != null) {
                int z = LoopViewPager.this.mOnPageChangeListeners.size();
                for (int i = 0; i < z; ++i) {
                    ViewPager.OnPageChangeListener listener = (ViewPager.OnPageChangeListener)LoopViewPager.this.mOnPageChangeListeners.get(i);
                    if (listener == null) continue;
                    listener.onPageScrolled(realPosition, positionOffset, positionOffsetPixels);
                }
            }
        }

        public void onPageScrollStateChanged(int state) {
            int count;
            int position = LoopViewPager.super.getCurrentItem();
            int realPosition = LoopViewPager.this.mLoopAdapter == null ? 0 : LoopViewPager.this.mLoopAdapter.toRealPosition(position);
            int n = count = LoopViewPager.this.mLoopAdapter == null ? 0 : LoopViewPager.this.mLoopAdapter.getCount();
            if (state == 0 && (position == 0 || position == count - 1)) {
                LoopViewPager.this.setCurrentItem(realPosition, false);
            }
            if (LoopViewPager.this.mOnPageChangeListener != null) {
                LoopViewPager.this.mOnPageChangeListener.onPageScrollStateChanged(state);
            }
            if (LoopViewPager.this.mOnPageChangeListeners != null) {
                int z = LoopViewPager.this.mOnPageChangeListeners.size();
                for (int i = 0; i < z; ++i) {
                    ViewPager.OnPageChangeListener listener = (ViewPager.OnPageChangeListener)LoopViewPager.this.mOnPageChangeListeners.get(i);
                    if (listener == null) continue;
                    listener.onPageScrollStateChanged(state);
                }
            }
        }
    }
}

