/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.CornerPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.ScaleAnimation;
import android.widget.ImageView;
import com.lzy.widget.R;
import java.util.ArrayList;
import java.util.List;

public class HexagonView
extends ImageView {
    private static final double RADIAN30 = 0.5235987755982988;
    private static final ImageView.ScaleType SCALE_TYPE = ImageView.ScaleType.CENTER_CROP;
    private static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    private static final int COLOR_DRAWABLE_DIMENSION = 2;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private String text = "";
    private int textSize = 12;
    private int textColor = -1;
    private int borderWidth = 2;
    private int borderColor = -65536;
    private int fillColor = -16776961;
    private int corner = 10;
    private int breakLineCount = 4;
    private int maxLine = 3;
    private int textSpacing = 4;
    private int hexagonOrientation = 1;
    private boolean borderOverlay = false;
    private final Matrix mShaderMatrix = new Matrix();
    private final Paint mBitmapPaint = new Paint();
    private final Paint mTextPaint = new Paint();
    private final Paint mTextBitmapPaint = new Paint();
    private final Paint mBorderPaint = new Paint();
    private final Paint mFillPaint = new Paint();
    private List<String> lineList = new ArrayList<String>();
    private List<Float> textBaseYList = new ArrayList<Float>();
    private BitmapShader mBitmapShader;
    private Bitmap mBitmap;
    private ColorFilter mColorFilter;
    private Path mDrawPath;
    private Path mBorderPath;
    private Path mBitmapPath;
    private List<PointF> mDrawPathPointList;
    private List<PointF> mBitmapPointList;
    private float mHexagonWidth;
    private float mHexagonHeight;
    private float mTranslateX;
    private float mTranslateY;
    private AnimationSet mAnimationSet;
    private OnHexagonViewClickListener mListener;
    private boolean isLasso = false;
    private LassoUtils mLasso;
    private boolean isNeedMore;

    public void setOnHexagonClickListener(OnHexagonViewClickListener listener) {
        this.mListener = listener;
    }

    public HexagonView(Context context) {
        this(context, null);
    }

    public HexagonView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HexagonView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.textSize = (int)TypedValue.applyDimension((int)2, (float)this.textSize, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.borderWidth = (int)TypedValue.applyDimension((int)2, (float)this.borderWidth, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.corner = (int)TypedValue.applyDimension((int)1, (float)this.corner, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.textSpacing = (int)TypedValue.applyDimension((int)1, (float)this.textSpacing, (DisplayMetrics)this.getResources().getDisplayMetrics());
        TypedArray typeA = context.obtainStyledAttributes(attrs, R.styleable.HexagonView);
        this.text = typeA.getString(R.styleable.HexagonView_hexagonText);
        this.textSize = typeA.getDimensionPixelSize(R.styleable.HexagonView_hexagonTextSize, this.textSize);
        this.textColor = typeA.getColor(R.styleable.HexagonView_hexagonTextColor, this.textColor);
        this.borderWidth = typeA.getDimensionPixelSize(R.styleable.HexagonView_hexagonBorderWidth, this.borderWidth);
        this.borderColor = typeA.getColor(R.styleable.HexagonView_hexagonBorderColor, this.borderColor);
        this.fillColor = typeA.getColor(R.styleable.HexagonView_hexagonFillColor, this.fillColor);
        this.corner = typeA.getDimensionPixelSize(R.styleable.HexagonView_hexagonCorner, this.corner);
        this.breakLineCount = typeA.getInt(R.styleable.HexagonView_hexagonBreakLineCount, this.breakLineCount);
        this.maxLine = typeA.getInt(R.styleable.HexagonView_hexagonMaxLine, this.maxLine);
        this.textSpacing = typeA.getDimensionPixelSize(R.styleable.HexagonView_hexagonTextSpacing, this.textSpacing);
        this.borderOverlay = typeA.getBoolean(R.styleable.HexagonView_hexagonBorderOverlay, this.borderOverlay);
        this.hexagonOrientation = typeA.getInt(R.styleable.HexagonView_hexagonOrientation, this.hexagonOrientation);
        typeA.recycle();
        this.setClickable(false);
        this.mLasso = LassoUtils.getInstance();
        this.initAnimation();
    }

    private void initAnimation() {
        float start = 1.0f;
        float end = 0.9f;
        ScaleAnimation startAnimation = new ScaleAnimation(start, end, start, end, 1, 0.5f, 1, 0.5f);
        startAnimation.setDuration(30L);
        ScaleAnimation endAnimation = new ScaleAnimation(end, start, end, start, 1, 0.5f, 1, 0.5f);
        endAnimation.setDuration(30L);
        this.mAnimationSet = new AnimationSet(false);
        this.mAnimationSet.addAnimation((Animation)startAnimation);
        this.mAnimationSet.addAnimation((Animation)endAnimation);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.isLasso = this.mLasso.contains(event.getX(), event.getY());
                break;
            }
            case 2: {
                this.isLasso = this.mLasso.contains(event.getX(), event.getY());
                break;
            }
            case 1: {
                boolean focusTaken = false;
                if (this.isFocusable() && this.isFocusableInTouchMode() && !this.isFocused()) {
                    focusTaken = this.requestFocus();
                }
                if (!focusTaken && this.isLasso && this.mListener != null) {
                    this.mListener.onClick((View)this);
                    this.startAnimation((Animation)this.mAnimationSet);
                }
                this.isLasso = false;
                break;
            }
            default: {
                this.isLasso = false;
            }
        }
        return true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.setup();
    }

    private void setup() {
        if (this.getWidth() == 0 && this.getHeight() == 0) {
            return;
        }
        int drawWidth = Math.max(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight(), 0);
        int drawHeight = Math.max(this.getHeight() - this.getPaddingTop() - this.getPaddingBottom(), 0);
        this.mTranslateX = this.getPaddingLeft();
        this.mTranslateY = this.getPaddingTop();
        if (this.hexagonOrientation == 1) {
            if ((double)((float)drawHeight * 1.0f / (float)drawWidth) > 2.0 / Math.sqrt(3.0)) {
                this.mHexagonWidth = drawWidth;
                this.mHexagonHeight = (float)((double)(2.0f * (float)drawWidth) / Math.sqrt(3.0));
                this.mTranslateY = ((float)drawHeight - this.mHexagonHeight) / 2.0f + (float)this.getPaddingTop();
            } else {
                this.mHexagonWidth = (float)(Math.sqrt(3.0) / 2.0 * (double)drawHeight);
                this.mHexagonHeight = drawHeight;
                this.mTranslateX = ((float)drawWidth - this.mHexagonWidth) / 2.0f + (float)this.getPaddingLeft();
            }
        } else if (this.hexagonOrientation == 0) {
            if ((double)((float)drawWidth * 1.0f / (float)drawHeight) > 2.0 / Math.sqrt(3.0)) {
                this.mHexagonWidth = (float)((double)(2.0f * (float)drawHeight) / Math.sqrt(3.0));
                this.mHexagonHeight = drawHeight;
                this.mTranslateX = ((float)drawWidth - this.mHexagonWidth) / 2.0f + (float)this.getPaddingLeft();
            } else {
                this.mHexagonWidth = drawWidth;
                this.mHexagonHeight = (float)(Math.sqrt(3.0) / 2.0 * (double)drawWidth);
                this.mTranslateY = ((float)drawHeight - this.mHexagonHeight) / 2.0f + (float)this.getPaddingTop();
            }
        }
        CornerPathEffect cornerPathEffect = new CornerPathEffect((float)this.corner);
        this.mBitmapPaint.setAntiAlias(true);
        this.mBitmapPaint.setPathEffect((PathEffect)cornerPathEffect);
        this.mTextBitmapPaint.setAntiAlias(true);
        this.mTextBitmapPaint.setPathEffect((PathEffect)cornerPathEffect);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setColor(this.borderColor);
        this.mBorderPaint.setStrokeWidth((float)this.borderWidth);
        this.mBorderPaint.setPathEffect((PathEffect)cornerPathEffect);
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mFillPaint.setAntiAlias(true);
        this.mFillPaint.setColor(this.fillColor);
        this.mFillPaint.setPathEffect((PathEffect)cornerPathEffect);
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setColor(this.textColor);
        this.mTextPaint.setTextSize((float)this.textSize);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mDrawPath = this.getHexagonDrawPath(this.mHexagonWidth, this.mHexagonHeight);
        this.mBorderPath = this.getBorderPath(this.mDrawPathPointList, this.borderWidth);
        this.mBitmapPath = this.getBitmapPath(this.mDrawPathPointList, this.borderWidth);
        if (TextUtils.isEmpty((CharSequence)this.text)) {
            this.text = "";
        }
        this.lineList.clear();
        this.breakTextLine(this.text, this.breakLineCount, this.maxLine - 1);
        if (this.isNeedMore) {
            this.lineList.add("...");
        }
        this.textBaseYList = this.getBaseLineList(this.lineList.size());
        Bitmap textBitmap = this.getTextBitmap(this.lineList);
        if (textBitmap != null) {
            BitmapShader textBitmapShader = new BitmapShader(textBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mTextBitmapPaint.setShader((Shader)textBitmapShader);
        }
        if (this.mBitmap != null) {
            this.mBitmapShader = new BitmapShader(this.mBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
            if (this.borderOverlay) {
                this.updateShaderMatrix(this.mBitmap, this.mHexagonWidth, this.mHexagonHeight);
            } else {
                if (this.hexagonOrientation == 1) {
                    this.updateShaderMatrix(this.mBitmap, this.mBitmapPointList.get((int)1).x - this.mBitmapPointList.get((int)5).x, this.mBitmapPointList.get((int)3).y - this.mBitmapPointList.get((int)0).y);
                }
                if (this.hexagonOrientation == 0) {
                    this.updateShaderMatrix(this.mBitmap, this.mBitmapPointList.get((int)3).x - this.mBitmapPointList.get((int)0).x, this.mBitmapPointList.get((int)5).y - this.mBitmapPointList.get((int)1).y);
                }
            }
        }
        this.mLasso.setLassoList(this.mDrawPathPointList);
        this.invalidate();
    }

    private Bitmap getTextBitmap(List<String> lineList) {
        if (this.mHexagonWidth <= 0.0f || this.mHexagonHeight <= 0.0f) {
            return null;
        }
        Bitmap target = Bitmap.createBitmap((int)((int)this.mHexagonWidth), (int)((int)this.mHexagonHeight), (Bitmap.Config)BITMAP_CONFIG);
        Canvas canvas = new Canvas(target);
        for (int i = 0; i < lineList.size(); ++i) {
            canvas.drawText(lineList.get(i), this.mHexagonWidth / 2.0f, this.textBaseYList.get(i).floatValue(), this.mTextPaint);
        }
        return target;
    }

    public void breakTextLine(String text, int breakLineCount, int maxLine) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            text = "";
        }
        String line = this.getSubString(text, 0, breakLineCount);
        if (maxLine == 0) {
            this.isNeedMore = false;
            this.lineList.add(line);
            return;
        }
        if (this.lineList.size() < maxLine) {
            if (this.getWordCount(text) > breakLineCount) {
                this.isNeedMore = true;
                this.lineList.add(line);
                String otherString = this.getSubString(text, this.getWordCount(line), this.getWordCount(text));
                this.breakTextLine(otherString, breakLineCount, maxLine);
            } else {
                this.isNeedMore = false;
                this.lineList.add(line);
            }
        }
    }

    private List<Float> getBaseLineList(int lines) {
        Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
        float fontHeight = fontMetrics.bottom - fontMetrics.top;
        float textBaseY = this.mHexagonHeight - (this.mHexagonHeight - fontHeight) / 2.0f - fontMetrics.bottom;
        ArrayList<Float> list = new ArrayList<Float>();
        int offset = -(lines - 1);
        for (int i = 0; i < lines; ++i) {
            if (this.isNeedMore) {
                if (i != lines - 1) {
                    list.add(Float.valueOf(textBaseY + (float)offset * (fontHeight / 2.0f + (float)(this.textSpacing / 2)) + fontHeight / 4.0f));
                    offset += 2;
                    continue;
                }
                list.add(Float.valueOf(textBaseY + (float)offset * (fontHeight / 2.0f + (float)(this.textSpacing / 2)) - fontHeight / 4.0f));
                continue;
            }
            list.add(Float.valueOf(textBaseY + (float)offset * (fontHeight / 2.0f + (float)(this.textSpacing / 2))));
            offset += 2;
        }
        return list;
    }

    private void updateShaderMatrix(Bitmap bitmap, float width, float height) {
        float scale;
        float dx = 0.0f;
        float dy = 0.0f;
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        this.mShaderMatrix.set(null);
        if ((float)bitmapWidth * height > width * (float)bitmapHeight) {
            scale = height / (float)bitmapHeight;
            dx = (width - (float)bitmapWidth * scale) * 0.5f;
        } else {
            scale = width / (float)bitmapWidth;
            dy = (height - (float)bitmapHeight * scale) * 0.5f;
        }
        this.mShaderMatrix.postScale(scale, scale);
        if (!this.borderOverlay) {
            if (this.hexagonOrientation == 0) {
                dx = (float)((double)(dx + 0.5f) + (double)this.borderWidth / Math.cos(0.5235987755982988));
                dy = dy + 0.5f + (float)this.borderWidth;
            }
            if (this.hexagonOrientation == 1) {
                dx = dx + 0.5f + (float)this.borderWidth;
                dy = (float)((double)(dy + 0.5f) + (double)this.borderWidth / Math.cos(0.5235987755982988));
            }
            this.mShaderMatrix.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        } else {
            this.mShaderMatrix.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }
        this.mBitmapShader.setLocalMatrix(this.mShaderMatrix);
    }

    protected void onDraw(Canvas canvas) {
        if (this.hexagonOrientation == 1 && this.mBitmapPointList.get((int)1).x - this.mBitmapPointList.get((int)5).x <= 0.0f) {
            return;
        }
        if (this.hexagonOrientation == 0 && this.mBitmapPointList.get((int)5).y - this.mBitmapPointList.get((int)1).y <= 0.0f) {
            return;
        }
        canvas.translate(this.mTranslateX, this.mTranslateY);
        if (this.mBitmap == null) {
            canvas.drawPath(this.mBitmapPath, this.mFillPaint);
        } else {
            canvas.drawPath(this.mBitmapPath, this.mBitmapPaint);
        }
        canvas.drawPath(this.mBitmapPath, this.mTextBitmapPaint);
        if (this.borderWidth > 0) {
            canvas.drawPath(this.mBorderPath, this.mBorderPaint);
        }
    }

    public Path getHexagonDrawPath(float width, float height) {
        Path path = new Path();
        this.mDrawPathPointList = new ArrayList<PointF>();
        if (this.hexagonOrientation == 1) {
            path.moveTo(width / 2.0f, 0.0f);
            path.lineTo(width, height / 4.0f);
            path.lineTo(width, height * 3.0f / 4.0f);
            path.lineTo(width / 2.0f, height);
            path.lineTo(0.0f, height * 3.0f / 4.0f);
            path.lineTo(0.0f, height / 4.0f);
            path.close();
            this.mDrawPathPointList.add(new PointF(width / 2.0f, 0.0f));
            this.mDrawPathPointList.add(new PointF(width, height / 4.0f));
            this.mDrawPathPointList.add(new PointF(width, height * 3.0f / 4.0f));
            this.mDrawPathPointList.add(new PointF(width / 2.0f, height));
            this.mDrawPathPointList.add(new PointF(0.0f, height * 3.0f / 4.0f));
            this.mDrawPathPointList.add(new PointF(0.0f, height / 4.0f));
        }
        if (this.hexagonOrientation == 0) {
            path.moveTo(0.0f, height / 2.0f);
            path.lineTo(width / 4.0f, 0.0f);
            path.lineTo(width * 3.0f / 4.0f, 0.0f);
            path.lineTo(width, height / 2.0f);
            path.lineTo(width * 3.0f / 4.0f, height);
            path.lineTo(width / 4.0f, height);
            path.close();
            this.mDrawPathPointList.add(new PointF(0.0f, height / 2.0f));
            this.mDrawPathPointList.add(new PointF(width / 4.0f, 0.0f));
            this.mDrawPathPointList.add(new PointF(width * 3.0f / 4.0f, 0.0f));
            this.mDrawPathPointList.add(new PointF(width, height / 2.0f));
            this.mDrawPathPointList.add(new PointF(width * 3.0f / 4.0f, height));
            this.mDrawPathPointList.add(new PointF(width / 4.0f, height));
        }
        return path;
    }

    private Path getBorderPath(List<PointF> pointList, int borderWidth) {
        if (borderWidth <= 0) {
            return this.mDrawPath;
        }
        if (this.hexagonOrientation == 1) {
            return this.makeVerticalHexagonPath(pointList, (float)borderWidth / 2.0f, null);
        }
        if (this.hexagonOrientation == 0) {
            return this.makeHorizontalHexagonPath(pointList, (float)borderWidth / 2.0f, null);
        }
        return null;
    }

    private Path getBitmapPath(List<PointF> pointList, int borderWidth) {
        if (borderWidth <= 0) {
            return this.mDrawPath;
        }
        if (this.borderOverlay) {
            return this.mDrawPath;
        }
        this.mBitmapPointList = new ArrayList<PointF>();
        if (this.hexagonOrientation == 1) {
            return this.makeVerticalHexagonPath(pointList, borderWidth, this.mBitmapPointList);
        }
        if (this.hexagonOrientation == 0) {
            return this.makeHorizontalHexagonPath(pointList, borderWidth, this.mBitmapPointList);
        }
        return null;
    }

    private Path makeVerticalHexagonPath(List<PointF> pointList, float offset, List<PointF> pointFList) {
        Path path = new Path();
        path.moveTo(pointList.get((int)0).x, (float)((double)pointList.get((int)0).y + (double)offset / Math.cos(0.5235987755982988)));
        path.lineTo(pointList.get((int)1).x - offset, (float)((double)pointList.get((int)1).y + (double)offset * Math.tan(0.5235987755982988)));
        path.lineTo(pointList.get((int)2).x - offset, (float)((double)pointList.get((int)2).y - (double)offset * Math.tan(0.5235987755982988)));
        path.lineTo(pointList.get((int)3).x, (float)((double)pointList.get((int)3).y - (double)offset / Math.cos(0.5235987755982988)));
        path.lineTo(pointList.get((int)4).x + offset, (float)((double)pointList.get((int)4).y - (double)offset * Math.tan(0.5235987755982988)));
        path.lineTo(pointList.get((int)5).x + offset, (float)((double)pointList.get((int)5).y + (double)offset * Math.tan(0.5235987755982988)));
        path.close();
        if (pointFList != null) {
            pointFList.add(new PointF(pointList.get((int)0).x, (float)((double)pointList.get((int)0).y + (double)offset / Math.cos(0.5235987755982988))));
            pointFList.add(new PointF(pointList.get((int)1).x - offset, (float)((double)pointList.get((int)1).y + (double)offset * Math.tan(0.5235987755982988))));
            pointFList.add(new PointF(pointList.get((int)2).x - offset, (float)((double)pointList.get((int)2).y - (double)offset * Math.tan(0.5235987755982988))));
            pointFList.add(new PointF(pointList.get((int)3).x, (float)((double)pointList.get((int)3).y - (double)offset / Math.cos(0.5235987755982988))));
            pointFList.add(new PointF(pointList.get((int)4).x + offset, (float)((double)pointList.get((int)4).y - (double)offset * Math.tan(0.5235987755982988))));
            pointFList.add(new PointF(pointList.get((int)5).x + offset, (float)((double)pointList.get((int)5).y + (double)offset * Math.tan(0.5235987755982988))));
        }
        return path;
    }

    private Path makeHorizontalHexagonPath(List<PointF> pointList, float offset, List<PointF> pointFList) {
        Path path = new Path();
        path.moveTo((float)((double)pointList.get((int)0).x + (double)offset / Math.cos(0.5235987755982988)), pointList.get((int)0).y);
        path.lineTo((float)((double)pointList.get((int)1).x + (double)offset * Math.tan(0.5235987755982988)), pointList.get((int)1).y + offset);
        path.lineTo((float)((double)pointList.get((int)2).x - (double)offset * Math.tan(0.5235987755982988)), pointList.get((int)2).y + offset);
        path.lineTo((float)((double)pointList.get((int)3).x - (double)offset / Math.cos(0.5235987755982988)), pointList.get((int)3).y);
        path.lineTo((float)((double)pointList.get((int)4).x - (double)offset * Math.tan(0.5235987755982988)), pointList.get((int)4).y - offset);
        path.lineTo((float)((double)pointList.get((int)5).x + (double)offset * Math.tan(0.5235987755982988)), pointList.get((int)5).y - offset);
        path.close();
        if (pointFList != null) {
            pointFList.add(new PointF((float)((double)pointList.get((int)0).x + (double)offset / Math.cos(0.5235987755982988)), pointList.get((int)0).y));
            pointFList.add(new PointF((float)((double)pointList.get((int)1).x + (double)offset * Math.tan(0.5235987755982988)), pointList.get((int)1).y + offset));
            pointFList.add(new PointF((float)((double)pointList.get((int)2).x - (double)offset * Math.tan(0.5235987755982988)), pointList.get((int)2).y + offset));
            pointFList.add(new PointF((float)((double)pointList.get((int)3).x - (double)offset / Math.cos(0.5235987755982988)), pointList.get((int)3).y));
            pointFList.add(new PointF((float)((double)pointList.get((int)4).x - (double)offset * Math.tan(0.5235987755982988)), pointList.get((int)4).y - offset));
            pointFList.add(new PointF((float)((double)pointList.get((int)5).x + (double)offset * Math.tan(0.5235987755982988)), pointList.get((int)5).y - offset));
        }
        return path;
    }

    private Bitmap getBitmapFromDrawable(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        try {
            Bitmap bitmap = drawable instanceof ColorDrawable ? Bitmap.createBitmap((int)2, (int)2, (Bitmap.Config)BITMAP_CONFIG) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)BITMAP_CONFIG);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getSubString(String str, int length) {
        if (length < 0) {
            return "";
        }
        int count = 0;
        char[] c = str.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            int offset;
            if (c[i] > '\u0100') {
                offset = 2;
                count += 2;
            } else {
                offset = 1;
                ++count;
            }
            if (count == length) {
                return str.substring(0, i + 1);
            }
            if (count != length + 1 || offset != 2) continue;
            return str.substring(0, i);
        }
        return "";
    }

    public String getSubString(String str, int from, int to) {
        if (from < 0) {
            from = 0;
        }
        if (to > this.getWordCount(str)) {
            to = this.getWordCount(str);
        }
        String toString = this.getSubString(str, to);
        String fromString = this.getSubString(str, from);
        return toString.substring(fromString.length());
    }

    public int getWordCount(String s) {
        int length = 0;
        for (int i = 0; i < s.length(); ++i) {
            int ascii = Character.codePointAt(s, i);
            if (ascii >= 0 && ascii <= 255) {
                ++length;
                continue;
            }
            length += 2;
        }
        return length;
    }

    public ImageView.ScaleType getScaleType() {
        return SCALE_TYPE;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType != SCALE_TYPE) {
            throw new IllegalArgumentException(String.format("ScaleType %s not supported.", scaleType));
        }
    }

    public void setAdjustViewBounds(boolean adjustViewBounds) {
        if (adjustViewBounds) {
            throw new IllegalArgumentException("adjustViewBounds not supported.");
        }
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.mBitmap = bm;
        this.setup();
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.mBitmap = this.getBitmapFromDrawable(drawable);
        this.setup();
    }

    public void setImageResource(@DrawableRes int resId) {
        super.setImageResource(resId);
        this.mBitmap = this.getBitmapFromDrawable(this.getDrawable());
        this.setup();
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.mBitmap = uri != null ? this.getBitmapFromDrawable(this.getDrawable()) : null;
        this.setup();
    }

    public void setColorFilter(ColorFilter cf) {
        if (cf == this.mColorFilter) {
            return;
        }
        this.mColorFilter = cf;
        this.mBitmapPaint.setColorFilter(this.mColorFilter);
        this.mFillPaint.setColorFilter(this.mColorFilter);
        this.invalidate();
    }

    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.setup();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.setup();
    }

    public void setTextResource(@StringRes int textRes) {
        this.setText(this.getContext().getResources().getString(textRes));
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = (int)TypedValue.applyDimension((int)2, (float)textSize, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.setup();
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(@ColorInt int textColor) {
        this.textColor = textColor;
        this.mTextPaint.setColor(textColor);
        this.setup();
    }

    public void setTextColorResource(@ColorRes int textColorRes) {
        this.setTextColor(this.getContext().getResources().getColor(textColorRes));
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        this.setup();
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(@ColorInt int borderColor) {
        this.borderColor = borderColor;
        this.mBorderPaint.setColor(borderColor);
        this.invalidate();
    }

    public void setBorderColorResource(@ColorRes int borderColorRes) {
        this.setBorderColor(this.getContext().getResources().getColor(borderColorRes));
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(@ColorInt int fillColor) {
        this.fillColor = fillColor;
        this.mFillPaint.setColor(fillColor);
        this.invalidate();
    }

    public void setFillColorResource(@ColorRes int fillColorRes) {
        this.setFillColor(this.getContext().getResources().getColor(fillColorRes));
    }

    public int getCorner() {
        return this.corner;
    }

    public void setCorner(int corner) {
        this.corner = corner;
        this.setup();
    }

    public int getBreakLineCount() {
        return this.breakLineCount;
    }

    public void setBreakLineCount(int breakLineCount) {
        this.breakLineCount = breakLineCount;
        this.setup();
    }

    public int getMaxLine() {
        return this.maxLine;
    }

    public void setMaxLine(int maxLine) {
        this.maxLine = maxLine;
        this.setup();
    }

    public int getTextSpacing() {
        return this.textSpacing;
    }

    public void setTextSpacing(int textSpacing) {
        this.textSpacing = textSpacing;
        this.setup();
    }

    public int getHexagonOrientation() {
        return this.hexagonOrientation;
    }

    public void setHexagonOrientation(int hexagonOrientation) {
        this.hexagonOrientation = hexagonOrientation;
        this.setup();
    }

    public boolean isBorderOverlay() {
        return this.borderOverlay;
    }

    public void setBorderOverlay(boolean borderOverlay) {
        this.borderOverlay = borderOverlay;
        this.setup();
    }

    public static class LassoUtils {
        private static final LassoUtils instance = new LassoUtils();
        private float[] mPolyX;
        private float[] mPolyY;
        private int mPolySize;

        private LassoUtils() {
        }

        public static LassoUtils getInstance() {
            return instance;
        }

        public void setLassoList(List<PointF> pointFs) {
            this.mPolySize = pointFs.size();
            this.mPolyX = new float[this.mPolySize];
            this.mPolyY = new float[this.mPolySize];
            for (int i = 0; i < this.mPolySize; ++i) {
                this.mPolyX[i] = pointFs.get((int)i).x;
                this.mPolyY[i] = pointFs.get((int)i).y;
            }
        }

        public boolean contains(float x, float y) {
            boolean result = false;
            int i = 0;
            int j = this.mPolySize - 1;
            while (i < this.mPolySize) {
                if ((this.mPolyY[i] < y && this.mPolyY[j] >= y || this.mPolyY[j] < y && this.mPolyY[i] >= y) && this.mPolyX[i] + (y - this.mPolyY[i]) / (this.mPolyY[j] - this.mPolyY[i]) * (this.mPolyX[j] - this.mPolyX[i]) < x) {
                    result = !result;
                }
                j = i++;
            }
            return result;
        }
    }

    public static interface OnHexagonViewClickListener {
        public void onClick(View var1);
    }
}

