/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.Scroller;

public class HeaderViewPager
extends LinearLayout {
    private Scroller mScroller;
    private Scroller mScrollerReset;
    private int mTouchSlop;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int sysVersion;
    private View mHeadView;
    private int mHeadHeight;
    private int maxY = 0;
    private int minY = 0;
    private int mCurY;
    private VelocityTracker mVelocityTracker;
    private DIRECTION mDirection;
    private int mLastScrollerY;
    private boolean mDisallowIntercept;
    private boolean isClickHead;
    private OnScrollListener onScrollListener;
    private float mDownX;
    private float mDownY;
    private float mLastY;
    private boolean verticalScrollFlag = false;
    private boolean isFirstScrollerExecuted = false;
    private ScrollableContainer mCurrentScrollableContainer;

    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.onScrollListener = onScrollListener;
    }

    public HeaderViewPager(Context context) {
        this(context, null);
    }

    public HeaderViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    @TargetApi(value=11)
    public HeaderViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @TargetApi(value=21)
    public HeaderViewPager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    public void init(Context context) {
        this.mScroller = new Scroller(context);
        this.mScrollerReset = new Scroller(context);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.sysVersion = Build.VERSION.SDK_INT;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mHeadView != null && !this.mHeadView.isClickable()) {
            this.mHeadView.setClickable(true);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mHeadView = this.getChildAt(0);
        this.measureChildWithMargins(this.mHeadView, widthMeasureSpec, 0, 0, 0);
        this.maxY = this.mHeadView.getMeasuredHeight();
        this.mHeadHeight = this.mHeadView.getMeasuredHeight();
        super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)heightMeasureSpec) + this.maxY), (int)0x40000000));
    }

    public void requestHeaderViewPagerDisallowInterceptTouchEvent(boolean disallowIntercept) {
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
        this.mDisallowIntercept = disallowIntercept;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        float currentX = ev.getX();
        float currentY = ev.getY();
        float shiftX = Math.abs(currentX - this.mDownX);
        float shiftY = Math.abs(currentY - this.mDownY);
        this.obtainVelocityTracker(ev);
        switch (ev.getAction()) {
            case 0: {
                this.mDisallowIntercept = false;
                this.verticalScrollFlag = false;
                this.mDownX = currentX;
                this.mDownY = currentY;
                this.mLastY = currentY;
                this.checkIsClickHead((int)currentY, this.mHeadHeight, this.getScrollY());
                this.mScroller.abortAnimation();
                break;
            }
            case 2: {
                if (this.mDisallowIntercept) break;
                float deltaY = this.mLastY - currentY;
                this.mLastY = currentY;
                if (shiftX > (float)this.mTouchSlop && shiftX > shiftY) {
                    this.verticalScrollFlag = false;
                } else if (shiftY > (float)this.mTouchSlop && shiftY > shiftX) {
                    this.verticalScrollFlag = true;
                }
                if (!this.verticalScrollFlag || this.isStickied() && !this.isTop() && !this.isClickHead) break;
                this.scrollBy(0, (int)((double)deltaY + 0.5));
                this.invalidate();
                break;
            }
            case 1: {
                if (this.verticalScrollFlag) {
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                    float yVelocity = this.mVelocityTracker.getYVelocity();
                    this.mDirection = yVelocity > 0.0f ? DIRECTION.DOWN : DIRECTION.UP;
                    this.mScroller.fling(0, this.getScrollY(), 0, -((int)yVelocity), 0, 0, -2147483647, Integer.MAX_VALUE);
                    this.mLastScrollerY = this.getScrollY();
                    this.invalidate();
                    if ((shiftX > (float)this.mTouchSlop || shiftY > (float)this.mTouchSlop) && (this.isClickHead || !this.isStickied())) {
                        int action = ev.getAction();
                        ev.setAction(3);
                        boolean dd = super.dispatchTouchEvent(ev);
                        ev.setAction(action);
                        return dd;
                    }
                }
                this.recycleVelocityTracker();
                break;
            }
            case 3: {
                this.recycleVelocityTracker();
                break;
            }
        }
        super.dispatchTouchEvent(ev);
        return true;
    }

    private void checkIsClickHead(int downY, int headHeight, int scrollY) {
        this.isClickHead = downY + scrollY <= headHeight;
    }

    private void obtainVelocityTracker(MotionEvent event) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int currY = this.mScroller.getCurrY();
            if (this.mDirection == DIRECTION.UP) {
                if (this.isStickied()) {
                    int distance = this.mScroller.getFinalY() - currY;
                    int duration = this.calcDuration(this.mScroller.getDuration(), this.mScroller.timePassed());
                    this.smoothScrollBy(this.getScrollerVelocity(distance, duration), distance, duration);
                    this.mScroller.abortAnimation();
                    return;
                }
                this.scrollTo(0, currY);
                this.invalidate();
            } else {
                if (this.isTop() || this.isClickHead) {
                    int deltaY = currY - this.mLastScrollerY;
                    int toY = this.getScrollY() + deltaY;
                    this.scrollTo(0, toY);
                    if (this.mCurY <= this.minY) {
                        this.mScroller.abortAnimation();
                        return;
                    }
                }
                this.invalidate();
            }
            this.mLastScrollerY = currY;
            this.isFirstScrollerExecuted = true;
        }
        if (this.mScroller.isFinished() && this.isFirstScrollerExecuted) {
            if (this.getScrollY() <= this.maxY / 2) {
                this.mScrollerReset.startScroll(0, this.getScrollY(), 0, -this.getScrollY());
            } else {
                this.mScrollerReset.startScroll(0, this.getScrollY(), 0, this.maxY - this.getScrollY());
            }
            this.isFirstScrollerExecuted = false;
        }
        if (this.mScrollerReset.computeScrollOffset()) {
            this.scrollTo(0, this.mScrollerReset.getCurrY());
            this.invalidate();
        }
    }

    @SuppressLint(value={"NewApi"})
    private int getScrollerVelocity(int distance, int duration) {
        if (this.mScroller == null) {
            return 0;
        }
        if (this.sysVersion >= 14) {
            return (int)this.mScroller.getCurrVelocity();
        }
        return distance / duration;
    }

    public void scrollBy(int x, int y) {
        int scrollY = this.getScrollY();
        int toY = scrollY + y;
        if (toY >= this.maxY) {
            toY = this.maxY;
        } else if (toY <= this.minY) {
            toY = this.minY;
        }
        y = toY - scrollY;
        super.scrollBy(x, y);
    }

    public void scrollTo(int x, int y) {
        if (y >= this.maxY) {
            y = this.maxY;
        } else if (y <= this.minY) {
            y = this.minY;
        }
        this.mCurY = y;
        if (this.onScrollListener != null) {
            this.onScrollListener.onScroll(y, this.maxY);
        }
        super.scrollTo(x, y);
    }

    public boolean isStickied() {
        return this.mCurY == this.maxY;
    }

    private int calcDuration(int duration, int timepass) {
        return duration - timepass;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public boolean isHeadTop() {
        return this.mCurY == this.minY;
    }

    public boolean canPtr() {
        return this.verticalScrollFlag && this.mCurY == this.minY && this.isTop();
    }

    public void setCurrentScrollableContainer(ScrollableContainer scrollableContainer) {
        this.mCurrentScrollableContainer = scrollableContainer;
    }

    private View getScrollableView() {
        if (this.mCurrentScrollableContainer == null) {
            return null;
        }
        return this.mCurrentScrollableContainer.getScrollableView();
    }

    private boolean isTop() {
        View scrollableView = this.getScrollableView();
        if (scrollableView == null) {
            throw new NullPointerException("You should call ScrollableHelper.setCurrentScrollableContainer() to set ScrollableContainer.");
        }
        if (scrollableView instanceof AdapterView) {
            return this.isAdapterViewTop((AdapterView)scrollableView);
        }
        if (scrollableView instanceof ScrollView) {
            return this.isScrollViewTop((ScrollView)scrollableView);
        }
        if (scrollableView instanceof RecyclerView) {
            return this.isRecyclerViewTop((RecyclerView)scrollableView);
        }
        if (scrollableView instanceof WebView) {
            return this.isWebViewTop((WebView)scrollableView);
        }
        throw new IllegalStateException("scrollableView must be a instance of AdapterView|ScrollView|RecyclerView");
    }

    private boolean isRecyclerViewTop(RecyclerView recyclerView) {
        RecyclerView.LayoutManager layoutManager;
        if (recyclerView != null && (layoutManager = recyclerView.getLayoutManager()) instanceof LinearLayoutManager) {
            int firstVisibleItemPosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            View childAt = recyclerView.getChildAt(0);
            if (childAt == null || firstVisibleItemPosition == 0 && childAt.getTop() == 0) {
                return true;
            }
        }
        return false;
    }

    private boolean isAdapterViewTop(AdapterView adapterView) {
        if (adapterView != null) {
            int firstVisiblePosition = adapterView.getFirstVisiblePosition();
            View childAt = adapterView.getChildAt(0);
            if (childAt == null || firstVisiblePosition == 0 && childAt.getTop() == 0) {
                return true;
            }
        }
        return false;
    }

    private boolean isScrollViewTop(ScrollView scrollView) {
        if (scrollView != null) {
            int scrollViewY = scrollView.getScrollY();
            return scrollViewY <= 0;
        }
        return false;
    }

    private boolean isWebViewTop(WebView scrollView) {
        if (scrollView != null) {
            int scrollViewY = scrollView.getScrollY();
            return scrollViewY <= 0;
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    private void smoothScrollBy(int velocityY, int distance, int duration) {
        View scrollableView = this.getScrollableView();
        if (scrollableView instanceof AbsListView) {
            AbsListView absListView = (AbsListView)scrollableView;
            if (this.sysVersion >= 21) {
                absListView.fling(velocityY);
            } else {
                absListView.smoothScrollBy(distance, duration);
            }
        } else if (scrollableView instanceof ScrollView) {
            ((ScrollView)scrollableView).fling(velocityY);
        } else if (scrollableView instanceof RecyclerView) {
            ((RecyclerView)scrollableView).fling(0, velocityY);
        } else if (scrollableView instanceof WebView) {
            ((WebView)scrollableView).flingScroll(0, velocityY);
        }
    }

    public static interface ScrollableContainer {
        public View getScrollableView();
    }

    public static interface OnScrollListener {
        public void onScroll(int var1, int var2);
    }

    private static enum DIRECTION {
        UP,
        DOWN;

    }
}

