/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.lzy.widget.AlphaView;
import java.util.ArrayList;
import java.util.List;

public class AlphaIndicator
extends LinearLayout {
    private ViewPager viewPager;
    private List<AlphaView> alphaViews = new ArrayList<AlphaView>();
    private int childCount;
    private int currentItem = 0;
    private static final String STATE_INSTANCE = "instance_state";
    private static final String STATE_ITEM = "state_item";

    public AlphaIndicator(Context context) {
        this(context, null);
    }

    public AlphaIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AlphaIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setViewPager(ViewPager viewPager) {
        this.viewPager = viewPager;
        this.init();
    }

    private void init() {
        if (this.viewPager == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.childCount = this.getChildCount();
        if (this.viewPager.getAdapter().getCount() != this.childCount) {
            throw new IllegalArgumentException("LinearLayout\u7684\u5b50View\u6570\u91cf\u5fc5\u987b\u548cViewPager\u6761\u76ee\u6570\u91cf\u4e00\u81f4");
        }
        for (int i = 0; i < this.childCount; ++i) {
            if (!(this.getChildAt(i) instanceof AlphaView)) {
                throw new IllegalArgumentException("AlphaIndicator\u7684\u5b50View\u5fc5\u987b\u662fAlphaView");
            }
            AlphaView alphaView = (AlphaView)this.getChildAt(i);
            this.alphaViews.add(alphaView);
            alphaView.setOnClickListener(new MyOnClickListener(i));
        }
        this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new MyOnPageChangeListener());
        this.alphaViews.get(this.currentItem).setIconAlpha(1.0f);
    }

    private void resetState() {
        for (int i = 0; i < this.childCount; ++i) {
            this.alphaViews.get(i).setIconAlpha(0.0f);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(STATE_INSTANCE, super.onSaveInstanceState());
        bundle.putInt(STATE_ITEM, this.currentItem);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.currentItem = bundle.getInt(STATE_ITEM);
            this.resetState();
            this.alphaViews.get(this.currentItem).setIconAlpha(1.0f);
            super.onRestoreInstanceState(bundle.getParcelable(STATE_INSTANCE));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    private class MyOnClickListener
    implements View.OnClickListener {
        private int currentIndex;

        public MyOnClickListener(int i) {
            this.currentIndex = i;
        }

        public void onClick(View v) {
            AlphaIndicator.this.resetState();
            ((AlphaView)((Object)AlphaIndicator.this.alphaViews.get(this.currentIndex))).setIconAlpha(1.0f);
            AlphaIndicator.this.viewPager.setCurrentItem(this.currentIndex, false);
            AlphaIndicator.this.currentItem = this.currentIndex;
        }
    }

    private class MyOnPageChangeListener
    extends ViewPager.SimpleOnPageChangeListener {
        private MyOnPageChangeListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (positionOffset > 0.0f) {
                ((AlphaView)((Object)AlphaIndicator.this.alphaViews.get(position))).setIconAlpha(1.0f - positionOffset);
                ((AlphaView)((Object)AlphaIndicator.this.alphaViews.get(position + 1))).setIconAlpha(positionOffset);
            }
            AlphaIndicator.this.currentItem = position;
        }
    }
}

