/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget.loop;

import android.os.Parcelable;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;

public class LoopAdapterWrapper
extends PagerAdapter {
    private PagerAdapter mAdapter;
    private int realFirst;
    private int realLast;

    public LoopAdapterWrapper(PagerAdapter adapter) {
        this.mAdapter = adapter;
        this.realFirst = 1;
        this.realLast = this.realFirst + this.getRealCount() - 1;
    }

    public int getCount() {
        return this.mAdapter.getCount() + 2;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        int realPosition = this.toRealPosition(position);
        return this.mAdapter.instantiateItem(container, realPosition);
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        boolean flag = this.mAdapter instanceof FragmentPagerAdapter || this.mAdapter instanceof FragmentStatePagerAdapter;
        int realPosition = this.toRealPosition(position);
        if (flag && (position <= this.realFirst || position >= this.realLast)) {
            return;
        }
        this.mAdapter.destroyItem(container, realPosition, object);
    }

    protected int toRealPosition(int position) {
        int realCount = this.getRealCount();
        if (realCount == 0) {
            return 0;
        }
        int realPosition = (position - 1) % realCount;
        if (realPosition < 0) {
            realPosition += realCount;
        }
        return realPosition;
    }

    public int getInnerPosition(int realPosition) {
        return realPosition + 1;
    }

    public int getRealCount() {
        return this.mAdapter.getCount();
    }

    public void finishUpdate(ViewGroup container) {
        this.mAdapter.finishUpdate(container);
    }

    public boolean isViewFromObject(View view, Object object) {
        return this.mAdapter.isViewFromObject(view, object);
    }

    public void restoreState(Parcelable bundle, ClassLoader classLoader) {
        this.mAdapter.restoreState(bundle, classLoader);
    }

    public Parcelable saveState() {
        return this.mAdapter.saveState();
    }

    public void startUpdate(ViewGroup container) {
        this.mAdapter.startUpdate(container);
    }

    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        this.mAdapter.setPrimaryItem(container, position, object);
    }
}

