/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget.manager;

import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.view.ViewGroup;

public class ExpandStaggeredGridLayoutManager
extends StaggeredGridLayoutManager {
    private int[] measuredDimension = new int[2];
    private int[] dimension;

    public ExpandStaggeredGridLayoutManager(int spanCount, int orientation) {
        super(spanCount, orientation);
    }

    public void onMeasure(RecyclerView.Recycler recycler, RecyclerView.State state, int widthSpec, int heightSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightSpec);
        int width = 0;
        int height = 0;
        int count = this.getItemCount();
        int span = this.getSpanCount();
        this.dimension = new int[span];
        for (int i = 0; i < count; ++i) {
            this.measureScrapChild(recycler, i, View.MeasureSpec.makeMeasureSpec((int)i, (int)0), View.MeasureSpec.makeMeasureSpec((int)i, (int)0), this.measuredDimension);
            if (this.getOrientation() == 1) {
                int n = this.findMinIndex(this.dimension);
                this.dimension[n] = this.dimension[n] + this.measuredDimension[1];
                continue;
            }
            int n = this.findMinIndex(this.dimension);
            this.dimension[n] = this.dimension[n] + this.measuredDimension[0];
        }
        if (this.getOrientation() == 1) {
            height = this.findMax(this.dimension);
        } else {
            width = this.findMax(this.dimension);
        }
        switch (widthMode) {
            case 0x40000000: {
                width = widthSize;
                break;
            }
            case -2147483648: {
                break;
            }
        }
        switch (heightMode) {
            case 0x40000000: {
                height = heightSize;
                break;
            }
            case -2147483648: {
                break;
            }
        }
        this.setMeasuredDimension(width, height);
    }

    private void measureScrapChild(RecyclerView.Recycler recycler, int position, int widthSpec, int heightSpec, int[] measuredDimension) {
        if (position < this.getItemCount()) {
            try {
                View view = recycler.getViewForPosition(position);
                if (view != null) {
                    RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)view.getLayoutParams();
                    int childWidthSpec = ViewGroup.getChildMeasureSpec((int)widthSpec, (int)(this.getPaddingLeft() + this.getPaddingRight()), (int)lp.width);
                    int childHeightSpec = ViewGroup.getChildMeasureSpec((int)heightSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)lp.height);
                    view.measure(childWidthSpec, childHeightSpec);
                    measuredDimension[0] = view.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
                    measuredDimension[1] = view.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
                    recycler.recycleView(view);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private int findMax(int[] array) {
        int max = array[0];
        for (int value : array) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    private int findMinIndex(int[] array) {
        int index = 0;
        int min = array[0];
        for (int i = 0; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
            index = i;
        }
        return index;
    }
}

