/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget;

import android.content.Context;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;

public class VerticalSlide
extends ViewGroup {
    private static final int VEL_THRESHOLD = 6000;
    private int DISTANCE_THRESHOLD = (int)TypedValue.applyDimension((int)1, (float)this.DISTANCE_THRESHOLD, (DisplayMetrics)this.getResources().getDisplayMetrics());
    private ViewDragHelper mDragHelper = ViewDragHelper.create((ViewGroup)this, (float)10.0f, (ViewDragHelper.Callback)new DragCallBack());
    private GestureDetectorCompat mGestureDetector;
    private View view1;
    private View view2;
    private int viewHeight;
    private OnShowNextPageListener nextPageListener;

    public void setOnShowNextPageListener(OnShowNextPageListener nextPageListener) {
        this.nextPageListener = nextPageListener;
    }

    public VerticalSlide(Context context) {
        this(context, null);
    }

    public VerticalSlide(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VerticalSlide(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mDragHelper.setEdgeTrackingEnabled(8);
        this.mGestureDetector = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)new YScrollDetector());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.view1 == null) {
            this.view1 = this.getChildAt(0);
        }
        if (this.view2 == null) {
            this.view2 = this.getChildAt(1);
        }
        this.view1.layout(l, t, r, b);
        this.view2.layout(l, t, r, b);
        this.viewHeight = this.view1.getMeasuredHeight();
        this.view2.offsetTopAndBottom(this.viewHeight);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean shouldIntercept = false;
        boolean yScroll = this.mGestureDetector.onTouchEvent(ev);
        try {
            shouldIntercept = this.mDragHelper.shouldInterceptTouchEvent(ev);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return shouldIntercept && yScroll;
    }

    public boolean onTouchEvent(MotionEvent event) {
        try {
            this.mDragHelper.processTouchEvent(event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void computeScroll() {
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private class YScrollDetector
    extends GestureDetector.SimpleOnGestureListener {
        private YScrollDetector() {
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float dx, float dy) {
            return Math.abs(dy) > Math.abs(dx);
        }
    }

    private class DragCallBack
    extends ViewDragHelper.Callback {
        private DragCallBack() {
        }

        public boolean tryCaptureView(View child, int pointerId) {
            return true;
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            if (changedView == VerticalSlide.this.view1) {
                VerticalSlide.this.view2.offsetTopAndBottom(dy);
            }
            if (changedView == VerticalSlide.this.view2) {
                VerticalSlide.this.view1.offsetTopAndBottom(dy);
            }
            ViewCompat.postInvalidateOnAnimation((View)VerticalSlide.this);
        }

        public int getViewVerticalDragRange(View child) {
            return child.getHeight();
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            int finalTop = 0;
            if (releasedChild == VerticalSlide.this.view1) {
                if (yvel < -6000.0f || releasedChild.getTop() < -VerticalSlide.this.DISTANCE_THRESHOLD) {
                    finalTop = -VerticalSlide.this.viewHeight;
                    if (null != VerticalSlide.this.nextPageListener) {
                        VerticalSlide.this.nextPageListener.onShowNextPage();
                    }
                }
            } else if (yvel > 6000.0f || releasedChild.getTop() > VerticalSlide.this.DISTANCE_THRESHOLD) {
                finalTop = VerticalSlide.this.viewHeight;
            }
            if (VerticalSlide.this.mDragHelper.smoothSlideViewTo(releasedChild, 0, finalTop)) {
                ViewCompat.postInvalidateOnAnimation((View)VerticalSlide.this);
            }
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            return child.getTop() + dy / 3;
        }
    }

    public static interface OnShowNextPageListener {
        public void onShowNextPage();
    }
}

