/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ImageView;
import com.lzy.widget.R;

public class CircleImageView
extends ImageView {
    private static final ImageView.ScaleType SCALE_TYPE = ImageView.ScaleType.CENTER_CROP;
    private static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    private static final int COLORDRAWABLE_DIMENSION = 2;
    private int mBorderWidth = 3;
    private int mBorderColor = -65536;
    private int mFillColor = 0;
    private boolean mBorderOverlay = false;
    private final Matrix mShaderMatrix = new Matrix();
    private final Paint mBitmapPaint = new Paint();
    private final Paint mBorderPaint = new Paint();
    private final Paint mFillPaint = new Paint();
    private Bitmap mBitmap;
    private float mBorderRadius;
    private float mDrawableRadius;
    private ColorFilter mColorFilter;
    private boolean mSetupPending;

    public CircleImageView(Context context) {
        this(context, null);
    }

    public CircleImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mBorderWidth = (int)TypedValue.applyDimension((int)2, (float)this.mBorderWidth, (DisplayMetrics)this.getResources().getDisplayMetrics());
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircleImageView, defStyle, 0);
        this.mBorderWidth = a.getDimensionPixelSize(R.styleable.CircleImageView_civ_BorderWidth, this.mBorderWidth);
        this.mBorderColor = a.getColor(R.styleable.CircleImageView_civ_BorderColor, this.mBorderColor);
        this.mBorderOverlay = a.getBoolean(R.styleable.CircleImageView_civ_BorderOverlay, this.mBorderOverlay);
        this.mFillColor = a.getColor(R.styleable.CircleImageView_civ_FillColor, this.mFillColor);
        a.recycle();
        super.setScaleType(SCALE_TYPE);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mSetupPending = true;
        this.setup();
    }

    private void setup() {
        float scale;
        if (!this.mSetupPending || this.getWidth() == 0 && this.getHeight() == 0) {
            return;
        }
        if (this.mBitmap == null) {
            this.invalidate();
            return;
        }
        BitmapShader bitmapShader = new BitmapShader(this.mBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mBitmapPaint.setAntiAlias(true);
        this.mBitmapPaint.setShader((Shader)bitmapShader);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setColor(this.mBorderColor);
        this.mBorderPaint.setStrokeWidth((float)this.mBorderWidth);
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mFillPaint.setAntiAlias(true);
        this.mFillPaint.setColor(this.mFillColor);
        int drawableWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int drawableHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        this.mDrawableRadius = Math.min(drawableWidth, drawableHeight) / 2;
        this.mBorderRadius = this.mDrawableRadius - (float)(this.mBorderWidth / 2);
        if (!this.mBorderOverlay) {
            this.mDrawableRadius -= (float)this.mBorderWidth;
        }
        int bitmapHeight = this.mBitmap.getHeight();
        int bitmapWidth = this.mBitmap.getWidth();
        float dx = ((float)drawableWidth - this.mDrawableRadius * 2.0f) / 2.0f + (float)this.getPaddingLeft();
        float dy = ((float)drawableHeight - this.mDrawableRadius * 2.0f) / 2.0f + (float)this.getPaddingTop();
        this.mShaderMatrix.set(null);
        if (bitmapWidth > bitmapHeight) {
            scale = this.mDrawableRadius * 2.0f / (float)bitmapHeight;
            dx += (this.mDrawableRadius * 2.0f - (float)bitmapWidth * scale) / 2.0f;
        } else {
            scale = this.mDrawableRadius * 2.0f / (float)bitmapWidth;
            dy += (this.mDrawableRadius * 2.0f - (float)bitmapHeight * scale) / 2.0f;
        }
        this.mShaderMatrix.postScale(scale, scale);
        this.mShaderMatrix.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        bitmapShader.setLocalMatrix(this.mShaderMatrix);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        if (this.mBitmap != null) {
            canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, this.mDrawableRadius, this.mBitmapPaint);
        } else if (this.mFillColor != 0) {
            canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, this.mDrawableRadius, this.mFillPaint);
        }
        if (this.mBorderWidth != 0) {
            canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, this.mBorderRadius, this.mBorderPaint);
        }
    }

    private Bitmap getBitmapFromDrawable(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        try {
            Bitmap bitmap = drawable instanceof ColorDrawable ? Bitmap.createBitmap((int)2, (int)2, (Bitmap.Config)BITMAP_CONFIG) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)BITMAP_CONFIG);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ImageView.ScaleType getScaleType() {
        return SCALE_TYPE;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType != SCALE_TYPE) {
            throw new IllegalArgumentException(String.format("ScaleType %s not supported.", scaleType));
        }
    }

    public void setAdjustViewBounds(boolean adjustViewBounds) {
        if (adjustViewBounds) {
            throw new IllegalArgumentException("adjustViewBounds not supported.");
        }
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.mBitmap = bm;
        this.setup();
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.mBitmap = this.getBitmapFromDrawable(drawable);
        this.setup();
    }

    public void setImageResource(@DrawableRes int resId) {
        super.setImageResource(resId);
        this.mBitmap = this.getBitmapFromDrawable(this.getDrawable());
        this.setup();
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.mBitmap = uri != null ? this.getBitmapFromDrawable(this.getDrawable()) : null;
        this.setup();
    }

    public void setColorFilter(ColorFilter cf) {
        if (cf == this.mColorFilter) {
            return;
        }
        this.mColorFilter = cf;
        this.mBitmapPaint.setColorFilter(this.mColorFilter);
        this.invalidate();
    }

    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.setup();
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public void setBorderColor(@ColorInt int borderColor) {
        if (borderColor == this.mBorderColor) {
            return;
        }
        this.mBorderColor = borderColor;
        this.mBorderPaint.setColor(this.mBorderColor);
        this.invalidate();
    }

    public void setBorderColorResource(@ColorRes int borderColorRes) {
        this.setBorderColor(this.getContext().getResources().getColor(borderColorRes));
    }

    public int getFillColor() {
        return this.mFillColor;
    }

    public void setFillColor(@ColorInt int fillColor) {
        if (fillColor == this.mFillColor) {
            return;
        }
        this.mFillColor = fillColor;
        this.mFillPaint.setColor(fillColor);
        this.invalidate();
    }

    public void setFillColorResource(@ColorRes int fillColorRes) {
        this.setFillColor(this.getContext().getResources().getColor(fillColorRes));
    }

    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        if (borderWidth == this.mBorderWidth) {
            return;
        }
        this.mBorderWidth = borderWidth;
        this.setup();
    }

    public boolean isBorderOverlay() {
        return this.mBorderOverlay;
    }

    public void setBorderOverlay(boolean borderOverlay) {
        if (borderOverlay == this.mBorderOverlay) {
            return;
        }
        this.mBorderOverlay = borderOverlay;
        this.setup();
    }
}

