/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget.vertical;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.webkit.WebView;
import com.lzy.widget.vertical.ObservableView;

public class VerticalWebView
extends WebView
implements ObservableView {
    private float downY;

    public VerticalWebView(Context context) {
        this(context, null);
    }

    public VerticalWebView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842885);
    }

    public VerticalWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.downY = ev.getY();
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                float dy = ev.getY() - this.downY;
                boolean allowParentTouchEvent = dy > 0.0f ? this.isTop() : this.isBottom();
                this.getParent().requestDisallowInterceptTouchEvent(!allowParentTouchEvent);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    @Override
    public boolean isTop() {
        return this.getScrollY() <= 0;
    }

    @Override
    public boolean isBottom() {
        return (float)(this.getHeight() + this.getScrollY()) >= (float)this.getContentHeight() * this.getScale();
    }
}

