/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget;

import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class OverScrollDecor
extends FrameLayout {
    private ViewDragHelper mDragHelper = ViewDragHelper.create((ViewGroup)this, (float)1.0f, (ViewDragHelper.Callback)new OverScrollCallBack());

    public OverScrollDecor(Context context) {
        this(context, null);
    }

    public OverScrollDecor(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public OverScrollDecor(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean shouldIntercept = false;
        try {
            shouldIntercept = this.mDragHelper.shouldInterceptTouchEvent(ev);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return shouldIntercept;
    }

    public boolean onTouchEvent(MotionEvent event) {
        try {
            this.mDragHelper.processTouchEvent(event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void computeScroll() {
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private class OverScrollCallBack
    extends ViewDragHelper.Callback {
        private OverScrollCallBack() {
        }

        public boolean tryCaptureView(View child, int pointerId) {
            return true;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)releasedChild.getLayoutParams();
            OverScrollDecor.this.mDragHelper.smoothSlideViewTo(releasedChild, params.leftMargin, params.topMargin);
            ViewCompat.postInvalidateOnAnimation((View)OverScrollDecor.this);
        }

        public int getViewVerticalDragRange(View child) {
            return Math.abs(child.getHeight());
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            return child.getLeft();
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            return child.getTop() + dy / 2;
        }
    }
}

