/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget;

import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.lzy.widget.ObservableView;

public class VerticalRecyclerView
extends RecyclerView
implements ObservableView {
    private float downY;
    private int firstVisibleItemPosition;
    private int[] firstPositions;
    private int lastVisibleItemPosition;
    private int[] lastPositions;
    private boolean isTop;
    private boolean isBottom;

    public VerticalRecyclerView(Context context) {
        this(context, null);
    }

    public VerticalRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VerticalRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager != null) {
            if (layoutManager instanceof GridLayoutManager) {
                this.lastVisibleItemPosition = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
                this.firstVisibleItemPosition = ((GridLayoutManager)layoutManager).findFirstVisibleItemPosition();
            } else if (layoutManager instanceof LinearLayoutManager) {
                this.lastVisibleItemPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                this.firstVisibleItemPosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                if (this.lastPositions == null) {
                    this.lastPositions = new int[staggeredGridLayoutManager.getSpanCount()];
                    this.firstPositions = new int[staggeredGridLayoutManager.getSpanCount()];
                }
                staggeredGridLayoutManager.findLastVisibleItemPositions(this.lastPositions);
                staggeredGridLayoutManager.findFirstVisibleItemPositions(this.firstPositions);
                this.lastVisibleItemPosition = this.findMax(this.lastPositions);
                this.firstVisibleItemPosition = this.findMin(this.firstPositions);
            }
        } else {
            throw new RuntimeException("Unsupported LayoutManager used. Valid ones are LinearLayoutManager, GridLayoutManager and StaggeredGridLayoutManager");
        }
        switch (ev.getAction()) {
            case 0: {
                this.downY = ev.getY();
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                boolean allowParentTouchEvent;
                float dy = ev.getY() - this.downY;
                if (dy > 0.0f) {
                    this.isTop = this.firstVisibleItemPosition == 0 && this.getChildAt(0).getTop() >= 0;
                    allowParentTouchEvent = this.isTop;
                } else {
                    int visibleItemCount = layoutManager.getChildCount();
                    int totalItemCount = layoutManager.getItemCount();
                    this.isBottom = visibleItemCount > 0 && this.lastVisibleItemPosition >= totalItemCount - 1 && this.getChildAt(this.getChildCount() - 1).getBottom() <= this.getHeight();
                    allowParentTouchEvent = this.isBottom;
                }
                this.getParent().requestDisallowInterceptTouchEvent(!allowParentTouchEvent);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private int findMax(int[] lastPositions) {
        int max = lastPositions[0];
        for (int value : lastPositions) {
            if (value < max) continue;
            max = value;
        }
        return max;
    }

    private int findMin(int[] firstPositions) {
        int min = firstPositions[0];
        for (int value : firstPositions) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    @Override
    public boolean isTop() {
        return this.isTop;
    }

    @Override
    public boolean isBottom() {
        return this.isBottom;
    }
}

