/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.GridView;
import com.lzy.widget.ObservableView;

public class VerticalGridView
extends GridView
implements ObservableView {
    private float downY;

    public VerticalGridView(Context context) {
        this(context, null);
    }

    public VerticalGridView(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010071);
    }

    public VerticalGridView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.downY = ev.getY();
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                float dy = ev.getY() - this.downY;
                boolean allowParentTouchEvent = dy > 0.0f ? this.isTop() : this.isBottom();
                this.getParent().requestDisallowInterceptTouchEvent(!allowParentTouchEvent);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    @Override
    public boolean isTop() {
        if (this.getChildCount() <= 0) {
            return false;
        }
        int firstTop = this.getChildAt(0).getTop();
        return this.getFirstVisiblePosition() == 0 && firstTop >= this.getListPaddingTop();
    }

    @Override
    public boolean isBottom() {
        int childCount = this.getChildCount();
        if (childCount <= 0) {
            return false;
        }
        int itemsCount = this.getCount();
        int firstPosition = this.getFirstVisiblePosition();
        int lastPosition = firstPosition + childCount;
        int lastBottom = this.getChildAt(childCount - 1).getBottom();
        return lastPosition >= itemsCount && lastBottom <= this.getHeight() - this.getListPaddingBottom();
    }
}

