/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okserver.upload;

import android.content.ContentValues;
import com.lzy.okgo.db.UploadManager;
import com.lzy.okgo.model.Progress;
import com.lzy.okgo.model.Response;
import com.lzy.okgo.request.base.ProgressRequestBody;
import com.lzy.okgo.request.base.Request;
import com.lzy.okgo.utils.HttpUtils;
import com.lzy.okgo.utils.OkLogger;
import com.lzy.okserver.OkUpload;
import com.lzy.okserver.task.PriorityRunnable;
import com.lzy.okserver.upload.UploadListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import okhttp3.Call;

public class UploadTask<T>
implements Runnable {
    public Progress progress;
    public Map<Object, UploadListener<T>> listeners;
    private ThreadPoolExecutor executor;
    private PriorityRunnable priorityRunnable;

    public UploadTask(String tag, Request<T, ? extends Request> request) {
        HttpUtils.checkNotNull((Object)tag, (String)"tag == null");
        this.progress = new Progress();
        this.progress.tag = tag;
        this.progress.url = request.getBaseUrl();
        this.progress.status = 0;
        this.progress.totalSize = -1L;
        this.progress.request = request;
        this.executor = OkUpload.getInstance().getThreadPool().getExecutor();
        this.listeners = new HashMap<Object, UploadListener<T>>();
    }

    public UploadTask(Progress progress) {
        HttpUtils.checkNotNull((Object)progress, (String)"progress == null");
        this.progress = progress;
        this.executor = OkUpload.getInstance().getThreadPool().getExecutor();
        this.listeners = new HashMap<Object, UploadListener<T>>();
    }

    public UploadTask<T> priority(int priority) {
        this.progress.priority = priority;
        return this;
    }

    public UploadTask<T> extra1(Serializable extra1) {
        this.progress.extra1 = extra1;
        return this;
    }

    public UploadTask<T> extra2(Serializable extra2) {
        this.progress.extra2 = extra2;
        return this;
    }

    public UploadTask<T> extra3(Serializable extra3) {
        this.progress.extra3 = extra3;
        return this;
    }

    public UploadTask<T> save() {
        UploadManager.getInstance().replace((Object)this.progress);
        return this;
    }

    public UploadTask<T> register(UploadListener<T> listener) {
        if (listener != null) {
            this.listeners.put(listener.tag, listener);
        }
        return this;
    }

    public void unRegister(UploadListener<T> listener) {
        HttpUtils.checkNotNull(listener, (String)"listener == null");
        this.listeners.remove(listener.tag);
    }

    public void unRegister(String tag) {
        HttpUtils.checkNotNull((Object)tag, (String)"tag == null");
        this.listeners.remove(tag);
    }

    public UploadTask<T> start() {
        if (OkUpload.getInstance().getTask(this.progress.tag) == null || UploadManager.getInstance().get(this.progress.tag) == null) {
            throw new IllegalStateException("you must call UploadTask#save() before UploadTask#start()\uff01");
        }
        if (this.progress.status != 1 && this.progress.status != 2) {
            this.postOnStart(this.progress);
            this.postWaiting(this.progress);
            this.priorityRunnable = new PriorityRunnable(this.progress.priority, this);
            this.executor.execute(this.priorityRunnable);
        } else {
            OkLogger.w((String)("the task with tag " + this.progress.tag + " is already in the upload queue, current task status is " + this.progress.status));
        }
        return this;
    }

    public void restart() {
        this.pause();
        this.progress.status = 0;
        this.progress.currentSize = 0L;
        this.progress.fraction = 0.0f;
        this.progress.speed = 0L;
        UploadManager.getInstance().replace((Object)this.progress);
        this.start();
    }

    public void pause() {
        this.executor.remove(this.priorityRunnable);
        if (this.progress.status == 1) {
            this.postPause(this.progress);
        } else if (this.progress.status == 2) {
            this.progress.speed = 0L;
            this.progress.status = 3;
        } else {
            OkLogger.w((String)("only the task with status WAITING(1) or LOADING(2) can pause, current status is " + this.progress.status));
        }
    }

    public UploadTask<T> remove() {
        this.pause();
        UploadManager.getInstance().delete(this.progress.tag);
        UploadTask<?> task = OkUpload.getInstance().removeTask(this.progress.tag);
        this.postOnRemove(this.progress);
        return task;
    }

    @Override
    public void run() {
        Response response;
        this.progress.status = 2;
        this.postLoading(this.progress);
        try {
            Request request = this.progress.request;
            final Call rawCall = request.getRawCall();
            request.uploadInterceptor(new ProgressRequestBody.UploadInterceptor(){

                public void uploadProgress(Progress innerProgress) {
                    if (rawCall.isCanceled()) {
                        return;
                    }
                    if (UploadTask.this.progress.status != 2) {
                        rawCall.cancel();
                        return;
                    }
                    UploadTask.this.progress.from(innerProgress);
                    UploadTask.this.postLoading(UploadTask.this.progress);
                }
            });
            response = request.adapt().execute();
        }
        catch (Exception e) {
            this.postOnError(this.progress, e);
            return;
        }
        if (response.isSuccessful()) {
            this.postOnFinish(this.progress, response.body());
        } else {
            this.postOnError(this.progress, response.getException());
        }
    }

    private void postOnStart(final Progress progress) {
        progress.speed = 0L;
        progress.status = 0;
        this.updateDatabase(progress);
        HttpUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (UploadListener listener : UploadTask.this.listeners.values()) {
                    listener.onStart(progress);
                }
            }
        });
    }

    private void postWaiting(final Progress progress) {
        progress.speed = 0L;
        progress.status = 1;
        this.updateDatabase(progress);
        HttpUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (UploadListener listener : UploadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                }
            }
        });
    }

    private void postPause(final Progress progress) {
        progress.speed = 0L;
        progress.status = 3;
        this.updateDatabase(progress);
        HttpUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (UploadListener listener : UploadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                }
            }
        });
    }

    private void postLoading(final Progress progress) {
        this.updateDatabase(progress);
        HttpUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (UploadListener listener : UploadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                }
            }
        });
    }

    private void postOnError(final Progress progress, Throwable throwable) {
        progress.speed = 0L;
        progress.status = 4;
        progress.exception = throwable;
        this.updateDatabase(progress);
        HttpUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (UploadListener listener : UploadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                    listener.onError(progress);
                }
            }
        });
    }

    private void postOnFinish(final Progress progress, final T t) {
        progress.speed = 0L;
        progress.fraction = 1.0f;
        progress.status = 5;
        this.updateDatabase(progress);
        HttpUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (UploadListener<Object> uploadListener : UploadTask.this.listeners.values()) {
                    uploadListener.onProgress(progress);
                    uploadListener.onFinish(t, progress);
                }
            }
        });
    }

    private void postOnRemove(final Progress progress) {
        this.updateDatabase(progress);
        HttpUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (UploadListener listener : UploadTask.this.listeners.values()) {
                    listener.onRemove(progress);
                }
                UploadTask.this.listeners.clear();
            }
        });
    }

    private void updateDatabase(Progress progress) {
        ContentValues contentValues = Progress.buildUpdateContentValues((Progress)progress);
        UploadManager.getInstance().update(contentValues, progress.tag);
    }
}

