/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okserver.task;

import android.os.Handler;
import android.os.Looper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class XExecutor
extends ThreadPoolExecutor {
    private Handler innerHandler = new Handler(Looper.getMainLooper());
    private List<OnTaskEndListener> taskEndListenerList;
    private List<OnAllTaskEndListener> allTaskEndListenerList;

    public XExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public XExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public XExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public XExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    @Override
    protected void afterExecute(final Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (this.taskEndListenerList != null && this.taskEndListenerList.size() > 0) {
            for (final OnTaskEndListener onTaskEndListener : this.taskEndListenerList) {
                this.innerHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        onTaskEndListener.onTaskEnd(r);
                    }
                });
            }
        }
        if (this.getActiveCount() == 1 && this.getQueue().size() == 0 && this.allTaskEndListenerList != null && this.allTaskEndListenerList.size() > 0) {
            for (final OnAllTaskEndListener onAllTaskEndListener : this.allTaskEndListenerList) {
                this.innerHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        onAllTaskEndListener.onAllTaskEnd();
                    }
                });
            }
        }
    }

    public void addOnTaskEndListener(OnTaskEndListener taskEndListener) {
        if (this.taskEndListenerList == null) {
            this.taskEndListenerList = new ArrayList<OnTaskEndListener>();
        }
        this.taskEndListenerList.add(taskEndListener);
    }

    public void removeOnTaskEndListener(OnTaskEndListener taskEndListener) {
        this.taskEndListenerList.remove(taskEndListener);
    }

    public void addOnAllTaskEndListener(OnAllTaskEndListener allTaskEndListener) {
        if (this.allTaskEndListenerList == null) {
            this.allTaskEndListenerList = new ArrayList<OnAllTaskEndListener>();
        }
        this.allTaskEndListenerList.add(allTaskEndListener);
    }

    public void removeOnAllTaskEndListener(OnAllTaskEndListener allTaskEndListener) {
        this.allTaskEndListenerList.remove(allTaskEndListener);
    }

    public static interface OnAllTaskEndListener {
        public void onAllTaskEnd();
    }

    public static interface OnTaskEndListener {
        public void onTaskEnd(Runnable var1);
    }
}

