/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okserver.download;

import android.content.ContentValues;
import android.text.TextUtils;
import com.lzy.okgo.db.DownloadManager;
import com.lzy.okgo.exception.HttpException;
import com.lzy.okgo.exception.OkGoException;
import com.lzy.okgo.exception.StorageException;
import com.lzy.okgo.model.Progress;
import com.lzy.okgo.request.base.Request;
import com.lzy.okgo.utils.HttpUtils;
import com.lzy.okgo.utils.IOUtils;
import com.lzy.okgo.utils.OkLogger;
import com.lzy.okserver.OkDownload;
import com.lzy.okserver.download.DownloadListener;
import com.lzy.okserver.task.PriorityRunnable;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DownloadTask
implements Runnable {
    private static final int BUFFER_SIZE = 8192;
    public Progress progress;
    public Map<Object, DownloadListener> listeners;
    private ThreadPoolExecutor executor;
    private PriorityRunnable priorityRunnable;

    public DownloadTask(String tag, Request<File, ? extends Request> request) {
        HttpUtils.checkNotNull((Object)tag, (String)"tag == null");
        this.progress = new Progress();
        this.progress.tag = tag;
        this.progress.folder = OkDownload.getInstance().getFolder();
        this.progress.url = request.getBaseUrl();
        this.progress.status = 0;
        this.progress.totalSize = -1L;
        this.progress.request = request;
        this.executor = OkDownload.getInstance().getThreadPool().getExecutor();
        this.listeners = new HashMap<Object, DownloadListener>();
    }

    public DownloadTask(Progress progress) {
        HttpUtils.checkNotNull((Object)progress, (String)"progress == null");
        this.progress = progress;
        this.executor = OkDownload.getInstance().getThreadPool().getExecutor();
        this.listeners = new HashMap<Object, DownloadListener>();
    }

    public DownloadTask folder(String folder) {
        if (folder != null && !TextUtils.isEmpty((CharSequence)folder.trim())) {
            this.progress.folder = folder;
        } else {
            OkLogger.w((String)"folder is null, ignored!");
        }
        return this;
    }

    public DownloadTask fileName(String fileName) {
        if (fileName != null && !TextUtils.isEmpty((CharSequence)fileName.trim())) {
            this.progress.fileName = fileName;
        } else {
            OkLogger.w((String)"fileName is null, ignored!");
        }
        return this;
    }

    public DownloadTask priority(int priority) {
        this.progress.priority = priority;
        return this;
    }

    public DownloadTask extra1(Serializable extra1) {
        this.progress.extra1 = extra1;
        return this;
    }

    public DownloadTask extra2(Serializable extra2) {
        this.progress.extra2 = extra2;
        return this;
    }

    public DownloadTask extra3(Serializable extra3) {
        this.progress.extra3 = extra3;
        return this;
    }

    public DownloadTask save() {
        if (!TextUtils.isEmpty((CharSequence)this.progress.folder) && !TextUtils.isEmpty((CharSequence)this.progress.fileName)) {
            this.progress.filePath = new File(this.progress.folder, this.progress.fileName).getAbsolutePath();
        }
        DownloadManager.getInstance().replace((Object)this.progress);
        return this;
    }

    public DownloadTask register(DownloadListener listener) {
        if (listener != null) {
            this.listeners.put(listener.tag, listener);
        }
        return this;
    }

    public void unRegister(DownloadListener listener) {
        HttpUtils.checkNotNull((Object)listener, (String)"listener == null");
        this.listeners.remove(listener.tag);
    }

    public void unRegister(String tag) {
        HttpUtils.checkNotNull((Object)tag, (String)"tag == null");
        this.listeners.remove(tag);
    }

    public void start() {
        if (OkDownload.getInstance().getTask(this.progress.tag) == null || DownloadManager.getInstance().get(this.progress.tag) == null) {
            throw new IllegalStateException("you must call DownloadTask#save() before DownloadTask#start()\uff01");
        }
        if (this.progress.status == 0 || this.progress.status == 3 || this.progress.status == 4) {
            this.postOnStart(this.progress);
            this.postWaiting(this.progress);
            this.priorityRunnable = new PriorityRunnable(this.progress.priority, this);
            this.executor.execute(this.priorityRunnable);
        } else if (this.progress.status == 5) {
            if (this.progress.filePath == null) {
                this.postOnError(this.progress, (Throwable)new StorageException("the file of the task with tag:" + this.progress.tag + " may be invalid or damaged, please call the method restart() to download again\uff01"));
            } else {
                File file = new File(this.progress.filePath);
                if (file.exists() && file.length() == this.progress.totalSize) {
                    this.postOnFinish(this.progress, new File(this.progress.filePath));
                } else {
                    this.postOnError(this.progress, (Throwable)new StorageException("the file " + this.progress.filePath + " may be invalid or damaged, please call the method restart() to download again\uff01"));
                }
            }
        } else {
            OkLogger.w((String)("the task with tag " + this.progress.tag + " is already in the download queue, current task status is " + this.progress.status));
        }
    }

    public void restart() {
        this.pause();
        IOUtils.delFileOrFolder((String)this.progress.filePath);
        this.progress.status = 0;
        this.progress.currentSize = 0L;
        this.progress.fraction = 0.0f;
        this.progress.speed = 0L;
        DownloadManager.getInstance().replace((Object)this.progress);
        this.start();
    }

    public void pause() {
        this.executor.remove(this.priorityRunnable);
        if (this.progress.status == 1) {
            this.postPause(this.progress);
        } else if (this.progress.status == 2) {
            this.progress.speed = 0L;
            this.progress.status = 3;
        } else {
            OkLogger.w((String)("only the task with status WAITING(1) or LOADING(2) can pause, current status is " + this.progress.status));
        }
    }

    public void remove() {
        this.remove(false);
    }

    public DownloadTask remove(boolean isDeleteFile) {
        this.pause();
        if (isDeleteFile) {
            IOUtils.delFileOrFolder((String)this.progress.filePath);
        }
        DownloadManager.getInstance().delete(this.progress.tag);
        DownloadTask task = OkDownload.getInstance().removeTask(this.progress.tag);
        this.postOnRemove(this.progress);
        return task;
    }

    @Override
    public void run() {
        RandomAccessFile randomAccessFile;
        File file;
        String fileName;
        Response response;
        File file2;
        long startPosition = this.progress.currentSize;
        if (startPosition < 0L) {
            this.postOnError(this.progress, (Throwable)OkGoException.BREAKPOINT_EXPIRED());
            return;
        }
        if (startPosition > 0L && !TextUtils.isEmpty((CharSequence)this.progress.filePath) && !(file2 = new File(this.progress.filePath)).exists()) {
            this.postOnError(this.progress, (Throwable)OkGoException.BREAKPOINT_NOT_EXIST());
            return;
        }
        try {
            Request request = this.progress.request;
            request.headers("Range", "bytes=" + startPosition + "-");
            response = request.execute();
        }
        catch (IOException e) {
            this.postOnError(this.progress, e);
            return;
        }
        int code = response.code();
        if (code == 404 || code >= 500) {
            this.postOnError(this.progress, (Throwable)HttpException.NET_ERROR());
            return;
        }
        ResponseBody body = response.body();
        if (body == null) {
            this.postOnError(this.progress, (Throwable)new HttpException("response body is null"));
            return;
        }
        if (this.progress.totalSize == -1L) {
            this.progress.totalSize = body.contentLength();
        }
        if (TextUtils.isEmpty((CharSequence)(fileName = this.progress.fileName))) {
            this.progress.fileName = fileName = HttpUtils.getNetFileName((Response)response, (String)this.progress.url);
        }
        if (!IOUtils.createFolder((String)this.progress.folder)) {
            this.postOnError(this.progress, (Throwable)StorageException.NOT_AVAILABLE());
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.progress.filePath)) {
            file = new File(this.progress.folder, fileName);
            this.progress.filePath = file.getAbsolutePath();
        } else {
            file = new File(this.progress.filePath);
        }
        if (startPosition > 0L && !file.exists()) {
            this.postOnError(this.progress, (Throwable)OkGoException.BREAKPOINT_EXPIRED());
            return;
        }
        if (startPosition > this.progress.totalSize) {
            this.postOnError(this.progress, (Throwable)OkGoException.BREAKPOINT_EXPIRED());
            return;
        }
        if (startPosition == 0L && file.exists()) {
            IOUtils.delFileOrFolder((File)file);
        }
        if (startPosition == this.progress.totalSize && startPosition > 0L) {
            if (file.exists() && startPosition == file.length()) {
                this.postOnFinish(this.progress, file);
                return;
            }
            this.postOnError(this.progress, (Throwable)OkGoException.BREAKPOINT_EXPIRED());
            return;
        }
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(startPosition);
            this.progress.currentSize = startPosition;
        }
        catch (Exception e) {
            this.postOnError(this.progress, e);
            return;
        }
        try {
            DownloadManager.getInstance().replace((Object)this.progress);
            this.download(body.byteStream(), randomAccessFile, this.progress);
        }
        catch (IOException e) {
            this.postOnError(this.progress, e);
            return;
        }
        if (this.progress.status == 3) {
            this.postPause(this.progress);
        } else if (this.progress.status == 2) {
            if (file.length() == this.progress.totalSize) {
                this.postOnFinish(this.progress, file);
            } else {
                this.postOnError(this.progress, (Throwable)OkGoException.BREAKPOINT_EXPIRED());
            }
        } else {
            this.postOnError(this.progress, (Throwable)OkGoException.UNKNOWN());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(InputStream input, RandomAccessFile out, Progress progress) throws IOException {
        if (input == null || out == null) {
            return;
        }
        progress.status = 2;
        byte[] buffer = new byte[8192];
        BufferedInputStream in = new BufferedInputStream(input, 8192);
        try {
            int len;
            while ((len = in.read(buffer, 0, 8192)) != -1 && progress.status == 2) {
                out.write(buffer, 0, len);
                Progress.changeProgress((Progress)progress, (long)len, (long)progress.totalSize, (Progress.Action)new Progress.Action(){

                    public void call(Progress progress) {
                        DownloadTask.this.postLoading(progress);
                    }
                });
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)out);
            IOUtils.closeQuietly((Closeable)in);
            IOUtils.closeQuietly((Closeable)input);
        }
    }

    private void postOnStart(final Progress progress) {
        progress.speed = 0L;
        progress.status = 0;
        this.updateDatabase(progress);
        HttpUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (DownloadListener listener : DownloadTask.this.listeners.values()) {
                    listener.onStart(progress);
                }
            }
        });
    }

    private void postWaiting(final Progress progress) {
        progress.speed = 0L;
        progress.status = 1;
        this.updateDatabase(progress);
        HttpUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (DownloadListener listener : DownloadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                }
            }
        });
    }

    private void postPause(final Progress progress) {
        progress.speed = 0L;
        progress.status = 3;
        this.updateDatabase(progress);
        HttpUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (DownloadListener listener : DownloadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                }
            }
        });
    }

    private void postLoading(final Progress progress) {
        this.updateDatabase(progress);
        HttpUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (DownloadListener listener : DownloadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                }
            }
        });
    }

    private void postOnError(final Progress progress, Throwable throwable) {
        progress.speed = 0L;
        progress.status = 4;
        progress.exception = throwable;
        this.updateDatabase(progress);
        HttpUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (DownloadListener listener : DownloadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                    listener.onError(progress);
                }
            }
        });
    }

    private void postOnFinish(final Progress progress, final File file) {
        progress.speed = 0L;
        progress.fraction = 1.0f;
        progress.status = 5;
        this.updateDatabase(progress);
        HttpUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (DownloadListener listener : DownloadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                    listener.onFinish(file, progress);
                }
            }
        });
    }

    private void postOnRemove(final Progress progress) {
        this.updateDatabase(progress);
        HttpUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (DownloadListener listener : DownloadTask.this.listeners.values()) {
                    listener.onRemove(progress);
                }
                DownloadTask.this.listeners.clear();
            }
        });
    }

    private void updateDatabase(Progress progress) {
        ContentValues contentValues = Progress.buildUpdateContentValues((Progress)progress);
        DownloadManager.getInstance().update(contentValues, progress.tag);
    }
}

