/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okserver;

import com.lzy.okgo.db.UploadManager;
import com.lzy.okgo.model.Progress;
import com.lzy.okgo.request.base.Request;
import com.lzy.okgo.utils.OkLogger;
import com.lzy.okserver.task.XExecutor;
import com.lzy.okserver.upload.UploadTask;
import com.lzy.okserver.upload.UploadThreadPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OkUpload {
    private Map<String, UploadTask<?>> taskMap;
    private UploadThreadPool threadPool = new UploadThreadPool();

    public static OkUpload getInstance() {
        return OkUploadHolder.instance;
    }

    private OkUpload() {
        this.taskMap = new LinkedHashMap();
        List taskList = UploadManager.getInstance().getUploading();
        for (Progress info : taskList) {
            if (info.status != 1 && info.status != 2 && info.status != 3) continue;
            info.status = 0;
        }
        UploadManager.getInstance().replace(taskList);
    }

    public static <T> UploadTask<T> request(String tag, Request<T, ? extends Request> request) {
        Map<String, UploadTask<?>> taskMap = OkUpload.getInstance().getTaskMap();
        UploadTask<Object> task = taskMap.get(tag);
        if (task == null) {
            task = new UploadTask<T>(tag, request);
            taskMap.put(tag, task);
        }
        return task;
    }

    public static <T> UploadTask<T> restore(Progress progress) {
        Map<String, UploadTask<?>> taskMap = OkUpload.getInstance().getTaskMap();
        UploadTask<Object> task = taskMap.get(progress.tag);
        if (task == null) {
            task = new UploadTask(progress);
            taskMap.put(progress.tag, task);
        }
        return task;
    }

    public static List<UploadTask<?>> restore(List<Progress> progressList) {
        Map<String, UploadTask<?>> taskMap = OkUpload.getInstance().getTaskMap();
        ArrayList tasks = new ArrayList();
        for (Progress progress : progressList) {
            UploadTask<Object> task = taskMap.get(progress.tag);
            if (task == null) {
                task = new UploadTask(progress);
                taskMap.put(progress.tag, task);
            }
            tasks.add(task);
        }
        return tasks;
    }

    public void startAll() {
        for (Map.Entry<String, UploadTask<?>> entry : this.taskMap.entrySet()) {
            UploadTask<?> task = entry.getValue();
            if (task == null) {
                OkLogger.w((String)("can't find task with tag = " + entry.getKey()));
                continue;
            }
            task.start();
        }
    }

    public void pauseAll() {
        UploadTask<?> task;
        for (Map.Entry<String, UploadTask<?>> entry : this.taskMap.entrySet()) {
            task = entry.getValue();
            if (task == null) {
                OkLogger.w((String)("can't find task with tag = " + entry.getKey()));
                continue;
            }
            if (task.progress.status == 2) continue;
            task.pause();
        }
        for (Map.Entry<String, UploadTask<?>> entry : this.taskMap.entrySet()) {
            task = entry.getValue();
            if (task == null) {
                OkLogger.w((String)("can't find task with tag = " + entry.getKey()));
                continue;
            }
            if (task.progress.status != 2) continue;
            task.pause();
        }
    }

    public void removeAll() {
        UploadTask task;
        HashMap map = new HashMap(this.taskMap);
        for (Map.Entry entry : map.entrySet()) {
            task = (UploadTask)entry.getValue();
            if (task == null) {
                OkLogger.w((String)("can't find task with tag = " + (String)entry.getKey()));
                continue;
            }
            if (task.progress.status == 2) continue;
            task.remove();
        }
        for (Map.Entry entry : map.entrySet()) {
            task = (UploadTask)entry.getValue();
            if (task == null) {
                OkLogger.w((String)("can't find task with tag = " + (String)entry.getKey()));
                continue;
            }
            if (task.progress.status != 2) continue;
            task.remove();
        }
    }

    public UploadThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Map<String, UploadTask<?>> getTaskMap() {
        return this.taskMap;
    }

    public UploadTask<?> getTask(String tag) {
        return this.taskMap.get(tag);
    }

    public boolean hasTask(String tag) {
        return this.taskMap.containsKey(tag);
    }

    public UploadTask<?> removeTask(String tag) {
        return this.taskMap.remove(tag);
    }

    public void addOnAllTaskEndListener(XExecutor.OnAllTaskEndListener listener) {
        this.threadPool.getExecutor().addOnAllTaskEndListener(listener);
    }

    public void removeOnAllTaskEndListener(XExecutor.OnAllTaskEndListener listener) {
        this.threadPool.getExecutor().removeOnAllTaskEndListener(listener);
    }

    private static class OkUploadHolder {
        private static final OkUpload instance = new OkUpload();

        private OkUploadHolder() {
        }
    }
}

