/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okserver;

import android.os.Environment;
import com.lzy.okgo.db.DownloadManager;
import com.lzy.okgo.model.Progress;
import com.lzy.okgo.request.base.Request;
import com.lzy.okgo.utils.IOUtils;
import com.lzy.okgo.utils.OkLogger;
import com.lzy.okserver.download.DownloadTask;
import com.lzy.okserver.download.DownloadThreadPool;
import com.lzy.okserver.task.XExecutor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OkDownload {
    private String folder = Environment.getExternalStorageDirectory() + File.separator + "download" + File.separator;
    private DownloadThreadPool threadPool;
    private ConcurrentHashMap<String, DownloadTask> taskMap;

    public static OkDownload getInstance() {
        return OkDownloadHolder.instance;
    }

    private OkDownload() {
        IOUtils.createFolder((String)this.folder);
        this.threadPool = new DownloadThreadPool();
        this.taskMap = new ConcurrentHashMap();
        List taskList = DownloadManager.getInstance().getDownloading();
        for (Progress info : taskList) {
            if (info.status != 1 && info.status != 2 && info.status != 3) continue;
            info.status = 0;
        }
        DownloadManager.getInstance().replace(taskList);
    }

    public static DownloadTask request(String tag, Request<File, ? extends Request> request) {
        Map<String, DownloadTask> taskMap = OkDownload.getInstance().getTaskMap();
        DownloadTask task = taskMap.get(tag);
        if (task == null) {
            task = new DownloadTask(tag, request);
            taskMap.put(tag, task);
        }
        return task;
    }

    public static DownloadTask restore(Progress progress) {
        Map<String, DownloadTask> taskMap = OkDownload.getInstance().getTaskMap();
        DownloadTask task = taskMap.get(progress.tag);
        if (task == null) {
            task = new DownloadTask(progress);
            taskMap.put(progress.tag, task);
        }
        return task;
    }

    public static List<DownloadTask> restore(List<Progress> progressList) {
        Map<String, DownloadTask> taskMap = OkDownload.getInstance().getTaskMap();
        ArrayList<DownloadTask> tasks = new ArrayList<DownloadTask>();
        for (Progress progress : progressList) {
            DownloadTask task = taskMap.get(progress.tag);
            if (task == null) {
                task = new DownloadTask(progress);
                taskMap.put(progress.tag, task);
            }
            tasks.add(task);
        }
        return tasks;
    }

    public void startAll() {
        for (Map.Entry<String, DownloadTask> entry : this.taskMap.entrySet()) {
            DownloadTask task = entry.getValue();
            if (task == null) {
                OkLogger.w((String)("can't find task with tag = " + entry.getKey()));
                continue;
            }
            task.start();
        }
    }

    public void pauseAll() {
        DownloadTask task;
        for (Map.Entry<String, DownloadTask> entry : this.taskMap.entrySet()) {
            task = entry.getValue();
            if (task == null) {
                OkLogger.w((String)("can't find task with tag = " + entry.getKey()));
                continue;
            }
            if (task.progress.status == 2) continue;
            task.pause();
        }
        for (Map.Entry<String, DownloadTask> entry : this.taskMap.entrySet()) {
            task = entry.getValue();
            if (task == null) {
                OkLogger.w((String)("can't find task with tag = " + entry.getKey()));
                continue;
            }
            if (task.progress.status != 2) continue;
            task.pause();
        }
    }

    public void removeAll() {
        this.removeAll(false);
    }

    public void removeAll(boolean isDeleteFile) {
        DownloadTask task;
        HashMap<String, DownloadTask> map = new HashMap<String, DownloadTask>(this.taskMap);
        for (Map.Entry entry : map.entrySet()) {
            task = (DownloadTask)entry.getValue();
            if (task == null) {
                OkLogger.w((String)("can't find task with tag = " + (String)entry.getKey()));
                continue;
            }
            if (task.progress.status == 2) continue;
            task.remove(isDeleteFile);
        }
        for (Map.Entry entry : map.entrySet()) {
            task = (DownloadTask)entry.getValue();
            if (task == null) {
                OkLogger.w((String)("can't find task with tag = " + (String)entry.getKey()));
                continue;
            }
            if (task.progress.status != 2) continue;
            task.remove(isDeleteFile);
        }
    }

    public String getFolder() {
        return this.folder;
    }

    public OkDownload setFolder(String folder) {
        this.folder = folder;
        return this;
    }

    public DownloadThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Map<String, DownloadTask> getTaskMap() {
        return this.taskMap;
    }

    public DownloadTask getTask(String tag) {
        return this.taskMap.get(tag);
    }

    public boolean hasTask(String tag) {
        return this.taskMap.containsKey(tag);
    }

    public DownloadTask removeTask(String tag) {
        return this.taskMap.remove(tag);
    }

    public void addOnAllTaskEndListener(XExecutor.OnAllTaskEndListener listener) {
        this.threadPool.getExecutor().addOnAllTaskEndListener(listener);
    }

    public void removeOnAllTaskEndListener(XExecutor.OnAllTaskEndListener listener) {
        this.threadPool.getExecutor().removeOnAllTaskEndListener(listener);
    }

    private static class OkDownloadHolder {
        private static final OkDownload instance = new OkDownload();

        private OkDownloadHolder() {
        }
    }
}

