/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okrx2.observable;

import com.lzy.okgo.adapter.Call;
import com.lzy.okgo.model.Response;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.plugins.RxJavaPlugins;

public class CallExecuteObservable<T>
extends Observable<Response<T>> {
    private final Call<T> originalCall;

    public CallExecuteObservable(Call<T> originalCall) {
        this.originalCall = originalCall;
    }

    protected void subscribeActual(Observer<? super Response<T>> observer) {
        block7: {
            Call call = this.originalCall.clone();
            observer.onSubscribe((Disposable)new CallDisposable(call));
            boolean terminated = false;
            try {
                Response response = call.execute();
                if (!call.isCanceled()) {
                    observer.onNext((Object)response);
                }
                if (!call.isCanceled()) {
                    terminated = true;
                    observer.onComplete();
                }
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal((Throwable)t);
                if (terminated) {
                    RxJavaPlugins.onError((Throwable)t);
                }
                if (call.isCanceled()) break block7;
                try {
                    observer.onError(t);
                }
                catch (Throwable inner) {
                    Exceptions.throwIfFatal((Throwable)inner);
                    RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, inner}));
                }
            }
        }
    }

    private static final class CallDisposable
    implements Disposable {
        private final Call<?> call;

        CallDisposable(Call<?> call) {
            this.call = call;
        }

        public void dispose() {
            this.call.cancel();
        }

        public boolean isDisposed() {
            return this.call.isCanceled();
        }
    }
}

