/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okrx2.observable;

import com.lzy.okgo.adapter.Call;
import com.lzy.okgo.callback.Callback;
import com.lzy.okgo.model.Progress;
import com.lzy.okgo.request.base.Request;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.plugins.RxJavaPlugins;
import okhttp3.Response;

public class CallEnqueueObservable<T>
extends Observable<com.lzy.okgo.model.Response<T>> {
    private final Call<T> originalCall;

    public CallEnqueueObservable(Call<T> originalCall) {
        this.originalCall = originalCall;
    }

    protected void subscribeActual(Observer<? super com.lzy.okgo.model.Response<T>> observer) {
        Call call = this.originalCall.clone();
        CallCallback callback = new CallCallback(call, observer);
        observer.onSubscribe(callback);
        call.execute(callback);
    }

    private static final class CallCallback<T>
    implements Disposable,
    Callback<T> {
        private final Call<T> call;
        private final Observer<? super com.lzy.okgo.model.Response<T>> observer;
        boolean terminated = false;

        CallCallback(Call<T> call, Observer<? super com.lzy.okgo.model.Response<T>> observer) {
            this.call = call;
            this.observer = observer;
        }

        public void dispose() {
            this.call.cancel();
        }

        public boolean isDisposed() {
            return this.call.isCanceled();
        }

        public T convertResponse(Response response) throws Throwable {
            return null;
        }

        public void onStart(Request<T, ? extends Request> request) {
        }

        public void onSuccess(com.lzy.okgo.model.Response<T> response) {
            if (this.call.isCanceled()) {
                return;
            }
            try {
                this.observer.onNext(response);
            }
            catch (Exception e) {
                if (this.terminated) {
                    RxJavaPlugins.onError((Throwable)e);
                }
                this.onError(response);
            }
        }

        public void onCacheSuccess(com.lzy.okgo.model.Response<T> response) {
            this.onSuccess(response);
        }

        public void onError(com.lzy.okgo.model.Response<T> response) {
            if (this.call.isCanceled()) {
                return;
            }
            Throwable throwable = response.getException();
            try {
                this.terminated = true;
                this.observer.onError(throwable);
            }
            catch (Throwable inner) {
                Exceptions.throwIfFatal((Throwable)inner);
                RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{throwable, inner}));
            }
        }

        public void onFinish() {
            if (this.call.isCanceled()) {
                return;
            }
            try {
                this.terminated = true;
                this.observer.onComplete();
            }
            catch (Throwable inner) {
                Exceptions.throwIfFatal((Throwable)inner);
                RxJavaPlugins.onError((Throwable)inner);
            }
        }

        public void uploadProgress(Progress progress) {
        }

        public void downloadProgress(Progress progress) {
        }
    }
}

