/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okrx2.observable;

import com.lzy.okgo.exception.HttpException;
import com.lzy.okgo.model.Response;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.plugins.RxJavaPlugins;

public final class BodyObservable<T>
extends Observable<T> {
    private final Observable<Response<T>> upstream;

    public BodyObservable(Observable<Response<T>> upstream) {
        this.upstream = upstream;
    }

    protected void subscribeActual(Observer<? super T> observer) {
        this.upstream.subscribe(new BodyObserver<T>(observer));
    }

    private static class BodyObserver<R>
    implements Observer<Response<R>> {
        private final Observer<? super R> observer;
        private boolean terminated;

        BodyObserver(Observer<? super R> observer) {
            this.observer = observer;
        }

        public void onSubscribe(Disposable disposable) {
            this.observer.onSubscribe(disposable);
        }

        public void onNext(Response<R> response) {
            if (response.isSuccessful()) {
                this.observer.onNext(response.body());
            } else {
                this.terminated = true;
                HttpException t = new HttpException(response);
                try {
                    this.observer.onError((Throwable)t);
                }
                catch (Throwable inner) {
                    Exceptions.throwIfFatal((Throwable)inner);
                    RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, inner}));
                }
            }
        }

        public void onComplete() {
            if (!this.terminated) {
                this.observer.onComplete();
            } else {
                AssertionError broken = new AssertionError((Object)"This should never happen! Report as a bug with the full stacktrace.");
                RxJavaPlugins.onError((Throwable)((Object)broken));
            }
        }

        public void onError(Throwable throwable) {
            if (!this.terminated) {
                this.observer.onError(throwable);
            } else {
                AssertionError broken = new AssertionError((Object)"This should never happen! Report as a bug with the full stacktrace.");
                ((Throwable)((Object)broken)).initCause(throwable);
                RxJavaPlugins.onError((Throwable)((Object)broken));
            }
        }
    }
}

