/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.utils;

import android.os.Build;
import android.os.StatFs;
import android.text.TextUtils;
import com.lzy.okgo.utils.OkLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class IOUtils {
    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            OkLogger.printStackTrace(e);
        }
    }

    public static void flushQuietly(Flushable flushable) {
        if (flushable == null) {
            return;
        }
        try {
            flushable.flush();
        }
        catch (Exception e) {
            OkLogger.printStackTrace(e);
        }
    }

    public static InputStream toInputStream(CharSequence input) {
        return new ByteArrayInputStream(input.toString().getBytes());
    }

    public static InputStream toInputStream(CharSequence input, String encoding) throws UnsupportedEncodingException {
        byte[] bytes = input.toString().getBytes(encoding);
        return new ByteArrayInputStream(bytes);
    }

    public static BufferedInputStream toBufferedInputStream(InputStream inputStream) {
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    public static BufferedOutputStream toBufferedOutputStream(OutputStream outputStream) {
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream);
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static BufferedWriter toBufferedWriter(Writer writer) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public static String toString(InputStream input) throws IOException {
        return new String(IOUtils.toByteArray(input));
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        return new String(IOUtils.toByteArray(input), encoding);
    }

    public static String toString(Reader input) throws IOException {
        return new String(IOUtils.toByteArray(input));
    }

    public static String toString(Reader input, String encoding) throws IOException {
        return new String(IOUtils.toByteArray(input), encoding);
    }

    public static String toString(byte[] byteArray) {
        return new String(byteArray);
    }

    public static String toString(byte[] byteArray, String encoding) {
        try {
            return new String(byteArray, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(byteArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(Object input) {
        block5: {
            byte[] byArray;
            ByteArrayOutputStream baos = null;
            ObjectOutputStream oos = null;
            try {
                baos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(baos);
                oos.writeObject(input);
                oos.flush();
                byArray = baos.toByteArray();
                IOUtils.closeQuietly(oos);
            }
            catch (IOException e) {
                OkLogger.printStackTrace(e);
                break block5;
            }
            finally {
                IOUtils.closeQuietly(oos);
                IOUtils.closeQuietly(baos);
            }
            IOUtils.closeQuietly(baos);
            return byArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toObject(byte[] input) {
        block6: {
            Object object;
            if (input == null) {
                return null;
            }
            ByteArrayInputStream bais = null;
            ObjectInputStream ois = null;
            try {
                bais = new ByteArrayInputStream(input);
                ois = new ObjectInputStream(bais);
                object = ois.readObject();
                IOUtils.closeQuietly(ois);
            }
            catch (Exception e) {
                OkLogger.printStackTrace(e);
                break block6;
            }
            finally {
                IOUtils.closeQuietly(ois);
                IOUtils.closeQuietly(bais);
            }
            IOUtils.closeQuietly(bais);
            return object;
        }
        return null;
    }

    public static byte[] toByteArray(CharSequence input) {
        if (input == null) {
            return new byte[0];
        }
        return input.toString().getBytes();
    }

    public static byte[] toByteArray(CharSequence input, String encoding) throws UnsupportedEncodingException {
        if (input == null) {
            return new byte[0];
        }
        return input.toString().getBytes(encoding);
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.write(input, (OutputStream)output);
        output.close();
        return output.toByteArray();
    }

    public static byte[] toByteArray(Reader input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.write(input, (OutputStream)output);
        output.close();
        return output.toByteArray();
    }

    public static byte[] toByteArray(Reader input, String encoding) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.write(input, (OutputStream)output, encoding);
        output.close();
        return output.toByteArray();
    }

    public static char[] toCharArray(CharSequence input) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        IOUtils.write(input, (Writer)output);
        return output.toCharArray();
    }

    public static char[] toCharArray(InputStream input) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        IOUtils.write(input, (Writer)output);
        return output.toCharArray();
    }

    public static char[] toCharArray(InputStream input, String encoding) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        IOUtils.write(input, (Writer)output, encoding);
        return output.toCharArray();
    }

    public static char[] toCharArray(Reader input) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        IOUtils.write(input, (Writer)output);
        return output.toCharArray();
    }

    public static List<String> readLines(InputStream input, String encoding) throws IOException {
        InputStreamReader reader = new InputStreamReader(input, encoding);
        return IOUtils.readLines(reader);
    }

    public static List<String> readLines(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input);
        return IOUtils.readLines(reader);
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = IOUtils.toBufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    public static void write(byte[] data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(data);
        }
    }

    public static void write(byte[] data, Writer output) throws IOException {
        if (data != null) {
            output.write(new String(data));
        }
    }

    public static void write(byte[] data, Writer output, String encoding) throws IOException {
        if (data != null) {
            output.write(new String(data, encoding));
        }
    }

    public static void write(char[] data, Writer output) throws IOException {
        if (data != null) {
            output.write(data);
        }
    }

    public static void write(char[] data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(new String(data).getBytes());
        }
    }

    public static void write(char[] data, OutputStream output, String encoding) throws IOException {
        if (data != null) {
            output.write(new String(data).getBytes(encoding));
        }
    }

    public static void write(CharSequence data, Writer output) throws IOException {
        if (data != null) {
            output.write(data.toString());
        }
    }

    public static void write(CharSequence data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(data.toString().getBytes());
        }
    }

    public static void write(CharSequence data, OutputStream output, String encoding) throws IOException {
        if (data != null) {
            output.write(data.toString().getBytes(encoding));
        }
    }

    public static void write(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
    }

    public static void write(Reader input, OutputStream output) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output);
        IOUtils.write(input, (Writer)out);
        ((Writer)out).flush();
    }

    public static void write(InputStream input, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        IOUtils.write((Reader)in, output);
    }

    public static void write(Reader input, OutputStream output, String encoding) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output, encoding);
        IOUtils.write(input, (Writer)out);
        ((Writer)out).flush();
    }

    public static void write(InputStream input, OutputStream output, String encoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input, encoding);
        IOUtils.write((Reader)in, output);
    }

    public static void write(InputStream input, Writer output, String encoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input, encoding);
        IOUtils.write((Reader)in, output);
    }

    public static void write(Reader input, Writer output) throws IOException {
        int len;
        char[] buffer = new char[4096];
        while (-1 != (len = input.read(buffer))) {
            output.write(buffer, 0, len);
        }
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        input1 = IOUtils.toBufferedInputStream(input1);
        input2 = IOUtils.toBufferedInputStream(input2);
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean contentEquals(Reader input1, Reader input2) throws IOException {
        int ch2;
        input1 = IOUtils.toBufferedReader(input1);
        input2 = IOUtils.toBufferedReader(input2);
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean contentEqualsIgnoreEOL(Reader input1, Reader input2) throws IOException {
        BufferedReader br1 = IOUtils.toBufferedReader(input1);
        BufferedReader br2 = IOUtils.toBufferedReader(input2);
        String line1 = br1.readLine();
        String line2 = br2.readLine();
        while (line1 != null && line2 != null && line1.equals(line2)) {
            line1 = br1.readLine();
            line2 = br2.readLine();
        }
        return line1 != null && (line2 == null || line1.equals(line2));
    }

    public static long getDirSize(String path) {
        StatFs stat;
        try {
            stat = new StatFs(path);
        }
        catch (Exception e) {
            OkLogger.printStackTrace(e);
            return 0L;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            return IOUtils.getStatFsSize(stat, "getBlockSizeLong", "getAvailableBlocksLong");
        }
        return IOUtils.getStatFsSize(stat, "getBlockSize", "getAvailableBlocks");
    }

    private static long getStatFsSize(StatFs statFs, String blockSizeMethod, String availableBlocksMethod) {
        try {
            Method getBlockSizeMethod = statFs.getClass().getMethod(blockSizeMethod, new Class[0]);
            getBlockSizeMethod.setAccessible(true);
            Method getAvailableBlocksMethod = statFs.getClass().getMethod(availableBlocksMethod, new Class[0]);
            getAvailableBlocksMethod.setAccessible(true);
            long blockSize = (Long)getBlockSizeMethod.invoke((Object)statFs, new Object[0]);
            long availableBlocks = (Long)getAvailableBlocksMethod.invoke((Object)statFs, new Object[0]);
            return blockSize * availableBlocks;
        }
        catch (Throwable e) {
            OkLogger.printStackTrace(e);
            return 0L;
        }
    }

    public static boolean canWrite(String path) {
        return new File(path).canWrite();
    }

    public static boolean canRead(String path) {
        return new File(path).canRead();
    }

    public static boolean createFolder(String folderPath) {
        if (!TextUtils.isEmpty((CharSequence)folderPath)) {
            File folder = new File(folderPath);
            return IOUtils.createFolder(folder);
        }
        return false;
    }

    public static boolean createFolder(File targetFolder) {
        if (targetFolder.exists()) {
            if (targetFolder.isDirectory()) {
                return true;
            }
            targetFolder.delete();
        }
        return targetFolder.mkdirs();
    }

    public static boolean createNewFolder(String folderPath) {
        return IOUtils.delFileOrFolder(folderPath) && IOUtils.createFolder(folderPath);
    }

    public static boolean createNewFolder(File targetFolder) {
        return IOUtils.delFileOrFolder(targetFolder) && IOUtils.createFolder(targetFolder);
    }

    public static boolean createFile(String filePath) {
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            File file = new File(filePath);
            return IOUtils.createFile(file);
        }
        return false;
    }

    public static boolean createFile(File targetFile) {
        if (targetFile.exists()) {
            if (targetFile.isFile()) {
                return true;
            }
            IOUtils.delFileOrFolder(targetFile);
        }
        try {
            return targetFile.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean createNewFile(String filePath) {
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            File file = new File(filePath);
            return IOUtils.createNewFile(file);
        }
        return false;
    }

    public static boolean createNewFile(File targetFile) {
        if (targetFile.exists()) {
            IOUtils.delFileOrFolder(targetFile);
        }
        try {
            return targetFile.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean delFileOrFolder(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return IOUtils.delFileOrFolder(new File(path));
    }

    public static boolean delFileOrFolder(File file) {
        if (file != null && file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File sonFile : files) {
                        IOUtils.delFileOrFolder(sonFile);
                    }
                }
                file.delete();
            }
        }
        return true;
    }
}

