/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.utils;

import android.text.TextUtils;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.model.HttpHeaders;
import com.lzy.okgo.model.HttpParams;
import com.lzy.okgo.utils.OkLogger;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpUtils {
    public static String createUrlFromParams(String url, Map<String, List<String>> params) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(url);
            if (url.indexOf(38) > 0 || url.indexOf(63) > 0) {
                sb.append("&");
            } else {
                sb.append("?");
            }
            for (Map.Entry<String, List<String>> urlParams : params.entrySet()) {
                List<String> urlValues = urlParams.getValue();
                for (String value : urlValues) {
                    String urlValue = URLEncoder.encode(value, "UTF-8");
                    sb.append(urlParams.getKey()).append("=").append(urlValue).append("&");
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            OkLogger.printStackTrace(e);
            return url;
        }
    }

    public static Request.Builder appendHeaders(Request.Builder builder, HttpHeaders headers) {
        if (headers.headersMap.isEmpty()) {
            return builder;
        }
        Headers.Builder headerBuilder = new Headers.Builder();
        try {
            for (Map.Entry<String, String> entry : headers.headersMap.entrySet()) {
                headerBuilder.add(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            OkLogger.printStackTrace(e);
        }
        builder.headers(headerBuilder.build());
        return builder;
    }

    public static RequestBody generateMultipartRequestBody(HttpParams params, boolean isMultipart) {
        if (params.fileParamsMap.isEmpty() && !isMultipart) {
            FormBody.Builder bodyBuilder = new FormBody.Builder();
            for (String string : params.urlParamsMap.keySet()) {
                List<String> urlValues = params.urlParamsMap.get(string);
                for (String string2 : urlValues) {
                    bodyBuilder.add(string, string2);
                }
            }
            return bodyBuilder.build();
        }
        MultipartBody.Builder multipartBodybuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (!params.urlParamsMap.isEmpty()) {
            for (Map.Entry<String, List<Object>> entry : params.urlParamsMap.entrySet()) {
                List<Object> urlValues = entry.getValue();
                for (String string : urlValues) {
                    multipartBodybuilder.addFormDataPart(entry.getKey(), string);
                }
            }
        }
        for (Map.Entry<String, List<Object>> entry : params.fileParamsMap.entrySet()) {
            List<Object> fileValues = entry.getValue();
            for (HttpParams.FileWrapper fileWrapper : fileValues) {
                RequestBody fileBody = RequestBody.create((MediaType)fileWrapper.contentType, (File)fileWrapper.file);
                multipartBodybuilder.addFormDataPart(entry.getKey(), fileWrapper.fileName, fileBody);
            }
        }
        return multipartBodybuilder.build();
    }

    public static String getNetFileName(Response response, String url) {
        String fileName = HttpUtils.getHeaderFileName(response);
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            fileName = HttpUtils.getUrlFileName(url);
        }
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            fileName = "unknownfile_" + System.currentTimeMillis();
        }
        try {
            fileName = URLDecoder.decode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            OkLogger.printStackTrace(e);
        }
        return fileName;
    }

    private static String getHeaderFileName(Response response) {
        String dispositionHeader = response.header("Content-Disposition");
        if (dispositionHeader != null) {
            String split;
            int indexOf = (dispositionHeader = dispositionHeader.replaceAll("\"", "")).indexOf(split = "filename=");
            if (indexOf != -1) {
                return dispositionHeader.substring(indexOf + split.length(), dispositionHeader.length());
            }
            split = "filename*=";
            indexOf = dispositionHeader.indexOf(split);
            if (indexOf != -1) {
                String encode;
                String fileName = dispositionHeader.substring(indexOf + split.length(), dispositionHeader.length());
                if (fileName.startsWith(encode = "UTF-8''")) {
                    fileName = fileName.substring(encode.length(), fileName.length());
                }
                return fileName;
            }
        }
        return null;
    }

    private static String getUrlFileName(String url) {
        String[] strings;
        String filename = null;
        for (String string : strings = url.split("/")) {
            int endIndex;
            if (!string.contains("?") || (endIndex = string.indexOf("?")) == -1) continue;
            filename = string.substring(0, endIndex);
            return filename;
        }
        if (strings.length > 0) {
            filename = strings[strings.length - 1];
        }
        return filename;
    }

    public static boolean deleteFile(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return true;
        }
        File file = new File(path);
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            boolean delete = file.delete();
            OkLogger.e("deleteFile:" + delete + " path:" + path);
            return delete;
        }
        return false;
    }

    public static MediaType guessMimeType(String fileName) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentType = fileNameMap.getContentTypeFor(fileName = fileName.replace("#", ""));
        if (contentType == null) {
            return HttpParams.MEDIA_TYPE_STREAM;
        }
        return MediaType.parse((String)contentType);
    }

    public static <T> T checkNotNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    public static void runOnUiThread(Runnable runnable) {
        OkGo.getInstance().getDelivery().post(runnable);
    }
}

