/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.utils;

import android.text.TextUtils;
import com.lzy.okgo.cache.CacheEntity;
import com.lzy.okgo.cache.CacheMode;
import com.lzy.okgo.model.HttpHeaders;
import com.lzy.okgo.request.base.Request;
import com.lzy.okgo.utils.OkLogger;
import java.util.Locale;
import java.util.StringTokenizer;
import okhttp3.Headers;

public class HeaderParser {
    public static <T> CacheEntity<T> createCacheEntity(Headers responseHeaders, T data, CacheMode cacheMode, String cacheKey) {
        long localExpire = 0L;
        if (cacheMode == CacheMode.DEFAULT) {
            long date = HttpHeaders.getDate(responseHeaders.get("Date"));
            long expires = HttpHeaders.getExpiration(responseHeaders.get("Expires"));
            String cacheControl = HttpHeaders.getCacheControl(responseHeaders.get("Cache-Control"), responseHeaders.get("Pragma"));
            if (TextUtils.isEmpty((CharSequence)cacheControl) && expires <= 0L) {
                return null;
            }
            long maxAge = 0L;
            if (!TextUtils.isEmpty((CharSequence)cacheControl)) {
                StringTokenizer tokens = new StringTokenizer(cacheControl, ",");
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken().trim().toLowerCase(Locale.getDefault());
                    if (token.equals("no-cache") || token.equals("no-store")) {
                        return null;
                    }
                    if (!token.startsWith("max-age=")) continue;
                    try {
                        maxAge = Long.parseLong(token.substring(8));
                        if (maxAge > 0L) continue;
                        return null;
                    }
                    catch (Exception e) {
                        OkLogger.printStackTrace(e);
                    }
                }
            }
            long now = System.currentTimeMillis();
            if (date > 0L) {
                now = date;
            }
            if (maxAge > 0L) {
                localExpire = now + maxAge * 1000L;
            } else if (expires >= 0L) {
                localExpire = expires;
            }
        } else {
            localExpire = System.currentTimeMillis();
        }
        HttpHeaders headers = new HttpHeaders();
        for (String headerName : responseHeaders.names()) {
            headers.put(headerName, responseHeaders.get(headerName));
        }
        CacheEntity<T> cacheEntity = new CacheEntity<T>();
        cacheEntity.setKey(cacheKey);
        cacheEntity.setData(data);
        cacheEntity.setLocalExpire(localExpire);
        cacheEntity.setResponseHeaders(headers);
        return cacheEntity;
    }

    public static <T> void addCacheHeaders(Request request, CacheEntity<T> cacheEntity, CacheMode cacheMode) {
        HttpHeaders responseHeaders;
        if (cacheEntity != null && cacheMode == CacheMode.DEFAULT && (responseHeaders = cacheEntity.getResponseHeaders()) != null) {
            long lastModified;
            String eTag = responseHeaders.get("ETag");
            if (eTag != null) {
                request.headers("If-None-Match", eTag);
            }
            if ((lastModified = HttpHeaders.getLastModified(responseHeaders.get("Last-Modified"))) > 0L) {
                request.headers("If-Modified-Since", HttpHeaders.formatMillisToGMT(lastModified));
            }
        }
    }
}

