/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.request.base;

import android.text.TextUtils;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.adapter.AdapterParam;
import com.lzy.okgo.adapter.CacheCall;
import com.lzy.okgo.adapter.Call;
import com.lzy.okgo.adapter.CallAdapter;
import com.lzy.okgo.cache.CacheMode;
import com.lzy.okgo.cache.policy.CachePolicy;
import com.lzy.okgo.callback.Callback;
import com.lzy.okgo.convert.Converter;
import com.lzy.okgo.model.HttpHeaders;
import com.lzy.okgo.model.HttpMethod;
import com.lzy.okgo.model.HttpParams;
import com.lzy.okgo.request.base.ProgressRequestBody;
import com.lzy.okgo.utils.HttpUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class Request<T, R extends Request>
implements Serializable {
    private static final long serialVersionUID = -7174118653689916252L;
    protected String url;
    protected String baseUrl;
    protected transient OkHttpClient client;
    protected transient Object tag;
    protected int retryCount;
    protected CacheMode cacheMode;
    protected String cacheKey;
    protected long cacheTime;
    protected HttpParams params = new HttpParams();
    protected HttpHeaders headers = new HttpHeaders();
    protected transient okhttp3.Request mRequest;
    protected transient Call<T> call;
    protected transient Callback<T> callback;
    protected transient Converter<T> converter;
    protected transient CachePolicy<T> cachePolicy;
    protected transient ProgressRequestBody.UploadInterceptor uploadInterceptor;

    public Request(String url) {
        String userAgent;
        this.url = url;
        this.baseUrl = url;
        OkGo go = OkGo.getInstance();
        String acceptLanguage = HttpHeaders.getAcceptLanguage();
        if (!TextUtils.isEmpty((CharSequence)acceptLanguage)) {
            this.headers("Accept-Language", acceptLanguage);
        }
        if (!TextUtils.isEmpty((CharSequence)(userAgent = HttpHeaders.getUserAgent()))) {
            this.headers("User-Agent", userAgent);
        }
        if (go.getCommonParams() != null) {
            this.params(go.getCommonParams());
        }
        if (go.getCommonHeaders() != null) {
            this.headers(go.getCommonHeaders());
        }
        this.retryCount = go.getRetryCount();
        this.cacheMode = go.getCacheMode();
        this.cacheTime = go.getCacheTime();
    }

    public R tag(Object tag) {
        this.tag = tag;
        return (R)this;
    }

    public R retryCount(int retryCount) {
        if (retryCount < 0) {
            throw new IllegalArgumentException("retryCount must > 0");
        }
        this.retryCount = retryCount;
        return (R)this;
    }

    public R client(OkHttpClient client) {
        HttpUtils.checkNotNull(client, "OkHttpClient == null");
        this.client = client;
        return (R)this;
    }

    public R call(Call<T> call) {
        HttpUtils.checkNotNull(call, "call == null");
        this.call = call;
        return (R)this;
    }

    public R converter(Converter<T> converter) {
        HttpUtils.checkNotNull(converter, "converter == null");
        this.converter = converter;
        return (R)this;
    }

    public R cacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return (R)this;
    }

    public R cachePolicy(CachePolicy<T> cachePolicy) {
        HttpUtils.checkNotNull(cachePolicy, "cachePolicy == null");
        this.cachePolicy = cachePolicy;
        return (R)this;
    }

    public R cacheKey(String cacheKey) {
        HttpUtils.checkNotNull(cacheKey, "cacheKey == null");
        this.cacheKey = cacheKey;
        return (R)this;
    }

    public R cacheTime(long cacheTime) {
        if (cacheTime <= -1L) {
            cacheTime = -1L;
        }
        this.cacheTime = cacheTime;
        return (R)this;
    }

    public R headers(HttpHeaders headers) {
        this.headers.put(headers);
        return (R)this;
    }

    public R headers(String key, String value) {
        this.headers.put(key, value);
        return (R)this;
    }

    public R removeHeader(String key) {
        this.headers.remove(key);
        return (R)this;
    }

    public R removeAllHeaders() {
        this.headers.clear();
        return (R)this;
    }

    public R params(HttpParams params) {
        this.params.put(params);
        return (R)this;
    }

    public R params(Map<String, String> params, boolean ... isReplace) {
        this.params.put(params, isReplace);
        return (R)this;
    }

    public R params(String key, String value, boolean ... isReplace) {
        this.params.put(key, value, isReplace);
        return (R)this;
    }

    public R params(String key, int value, boolean ... isReplace) {
        this.params.put(key, value, isReplace);
        return (R)this;
    }

    public R params(String key, float value, boolean ... isReplace) {
        this.params.put(key, value, isReplace);
        return (R)this;
    }

    public R params(String key, double value, boolean ... isReplace) {
        this.params.put(key, value, isReplace);
        return (R)this;
    }

    public R params(String key, long value, boolean ... isReplace) {
        this.params.put(key, value, isReplace);
        return (R)this;
    }

    public R params(String key, char value, boolean ... isReplace) {
        this.params.put(key, value, isReplace);
        return (R)this;
    }

    public R params(String key, boolean value, boolean ... isReplace) {
        this.params.put(key, value, isReplace);
        return (R)this;
    }

    public R addUrlParams(String key, List<String> values) {
        this.params.putUrlParams(key, values);
        return (R)this;
    }

    public R removeParam(String key) {
        this.params.remove(key);
        return (R)this;
    }

    public R removeAllParams() {
        this.params.clear();
        return (R)this;
    }

    public R uploadInterceptor(ProgressRequestBody.UploadInterceptor uploadInterceptor) {
        this.uploadInterceptor = uploadInterceptor;
        return (R)this;
    }

    public String getUrlParam(String key) {
        List<String> values = this.params.urlParamsMap.get(key);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public HttpParams.FileWrapper getFileParam(String key) {
        List<HttpParams.FileWrapper> values = this.params.fileParamsMap.get(key);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public HttpParams getParams() {
        return this.params;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Object getTag() {
        return this.tag;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public CachePolicy<T> getCachePolicy() {
        return this.cachePolicy;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public long getCacheTime() {
        return this.cacheTime;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public okhttp3.Request getRequest() {
        return this.mRequest;
    }

    public void setCallback(Callback<T> callback) {
        this.callback = callback;
    }

    public Converter<T> getConverter() {
        if (this.converter == null) {
            this.converter = this.callback;
        }
        HttpUtils.checkNotNull(this.converter, "converter == null, do you forget to call Request#converter(Converter<T>) ?");
        return this.converter;
    }

    public abstract HttpMethod getMethod();

    protected abstract RequestBody generateRequestBody();

    public abstract okhttp3.Request generateRequest(RequestBody var1);

    public okhttp3.Call getRawCall() {
        RequestBody requestBody = this.generateRequestBody();
        if (requestBody != null) {
            ProgressRequestBody<T> progressRequestBody = new ProgressRequestBody<T>(requestBody, this.callback);
            progressRequestBody.setInterceptor(this.uploadInterceptor);
            this.mRequest = this.generateRequest(progressRequestBody);
        } else {
            this.mRequest = this.generateRequest(null);
        }
        if (this.client == null) {
            this.client = OkGo.getInstance().getOkHttpClient();
        }
        return this.client.newCall(this.mRequest);
    }

    public Call<T> adapt() {
        if (this.call == null) {
            return new CacheCall(this);
        }
        return this.call;
    }

    public <E> E adapt(CallAdapter<T, E> adapter) {
        Call<T> innerCall = this.call;
        if (innerCall == null) {
            innerCall = new CacheCall(this);
        }
        return adapter.adapt(innerCall, null);
    }

    public <E> E adapt(AdapterParam param, CallAdapter<T, E> adapter) {
        Call<T> innerCall = this.call;
        if (innerCall == null) {
            innerCall = new CacheCall(this);
        }
        return adapter.adapt(innerCall, param);
    }

    public Response execute() throws IOException {
        return this.getRawCall().execute();
    }

    public void execute(Callback<T> callback) {
        HttpUtils.checkNotNull(callback, "callback == null");
        this.callback = callback;
        Call<T> call = this.adapt();
        call.execute(callback);
    }
}

