/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.request.base;

import com.lzy.okgo.callback.Callback;
import com.lzy.okgo.model.Progress;
import com.lzy.okgo.utils.HttpUtils;
import com.lzy.okgo.utils.OkLogger;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class ProgressRequestBody<T>
extends RequestBody {
    private RequestBody requestBody;
    private Callback<T> callback;
    private UploadInterceptor interceptor;

    ProgressRequestBody(RequestBody requestBody, Callback<T> callback) {
        this.requestBody = requestBody;
        this.callback = callback;
    }

    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    public long contentLength() {
        try {
            return this.requestBody.contentLength();
        }
        catch (IOException e) {
            OkLogger.printStackTrace(e);
            return -1L;
        }
    }

    public void writeTo(BufferedSink sink) throws IOException {
        CountingSink countingSink = new CountingSink((Sink)sink);
        BufferedSink bufferedSink = Okio.buffer((Sink)countingSink);
        this.requestBody.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    private void onProgress(final Progress progress) {
        HttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (ProgressRequestBody.this.callback != null) {
                    ProgressRequestBody.this.callback.uploadProgress(progress);
                }
            }
        });
    }

    public void setInterceptor(UploadInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public static interface UploadInterceptor {
        public void uploadProgress(Progress var1);
    }

    private final class CountingSink
    extends ForwardingSink {
        private Progress progress;

        CountingSink(Sink delegate) {
            super(delegate);
            this.progress = new Progress();
            this.progress.totalSize = ProgressRequestBody.this.contentLength();
        }

        public void write(Buffer source, long byteCount) throws IOException {
            super.write(source, byteCount);
            Progress.changeProgress(this.progress, byteCount, new Progress.Action(){

                @Override
                public void call(Progress progress) {
                    if (ProgressRequestBody.this.interceptor != null) {
                        ProgressRequestBody.this.interceptor.uploadProgress(progress);
                    } else {
                        ProgressRequestBody.this.onProgress(progress);
                    }
                }
            });
        }
    }
}

