/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.request.base;

import android.text.TextUtils;
import com.lzy.okgo.model.HttpParams;
import com.lzy.okgo.request.base.HasBody;
import com.lzy.okgo.request.base.Request;
import com.lzy.okgo.utils.HttpUtils;
import com.lzy.okgo.utils.OkLogger;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BodyRequest<T, R extends BodyRequest>
extends Request<T, R>
implements HasBody<R> {
    private static final long serialVersionUID = -6459175248476927501L;
    protected transient MediaType mediaType;
    protected String content;
    protected byte[] bs;
    protected transient File file;
    protected boolean isMultipart = false;
    protected boolean isSpliceUrl = false;
    protected RequestBody requestBody;

    public BodyRequest(String url) {
        super(url);
    }

    @Override
    public R isMultipart(boolean isMultipart) {
        this.isMultipart = isMultipart;
        return (R)this;
    }

    @Override
    public R isSpliceUrl(boolean isSpliceUrl) {
        this.isSpliceUrl = isSpliceUrl;
        return (R)this;
    }

    @Override
    public R params(String key, File file) {
        this.params.put(key, file);
        return (R)this;
    }

    @Override
    public R addFileParams(String key, List<File> files) {
        this.params.putFileParams(key, files);
        return (R)this;
    }

    @Override
    public R addFileWrapperParams(String key, List<HttpParams.FileWrapper> fileWrappers) {
        this.params.putFileWrapperParams(key, fileWrappers);
        return (R)this;
    }

    @Override
    public R params(String key, File file, String fileName) {
        this.params.put(key, file, fileName);
        return (R)this;
    }

    @Override
    public R params(String key, File file, String fileName, MediaType contentType) {
        this.params.put(key, file, fileName, contentType);
        return (R)this;
    }

    @Override
    public R upRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
        return (R)this;
    }

    @Override
    public R upString(String string) {
        this.content = string;
        this.mediaType = HttpParams.MEDIA_TYPE_PLAIN;
        return (R)this;
    }

    @Override
    public R upString(String string, MediaType mediaType) {
        this.content = string;
        this.mediaType = mediaType;
        return (R)this;
    }

    @Override
    public R upJson(String json) {
        this.content = json;
        this.mediaType = HttpParams.MEDIA_TYPE_JSON;
        return (R)this;
    }

    @Override
    public R upJson(JSONObject jsonObject) {
        this.content = jsonObject.toString();
        this.mediaType = HttpParams.MEDIA_TYPE_JSON;
        return (R)this;
    }

    @Override
    public R upJson(JSONArray jsonArray) {
        this.content = jsonArray.toString();
        this.mediaType = HttpParams.MEDIA_TYPE_JSON;
        return (R)this;
    }

    @Override
    public R upBytes(byte[] bs) {
        this.bs = bs;
        this.mediaType = HttpParams.MEDIA_TYPE_STREAM;
        return (R)this;
    }

    @Override
    public R upBytes(byte[] bs, MediaType mediaType) {
        this.bs = bs;
        this.mediaType = mediaType;
        return (R)this;
    }

    @Override
    public R upFile(File file) {
        this.file = file;
        this.mediaType = HttpUtils.guessMimeType(file.getName());
        return (R)this;
    }

    @Override
    public R upFile(File file, MediaType mediaType) {
        this.file = file;
        this.mediaType = mediaType;
        return (R)this;
    }

    @Override
    public RequestBody generateRequestBody() {
        if (this.isSpliceUrl) {
            this.url = HttpUtils.createUrlFromParams(this.baseUrl, this.params.urlParamsMap);
        }
        if (this.requestBody != null) {
            return this.requestBody;
        }
        if (this.content != null && this.mediaType != null) {
            return RequestBody.create((MediaType)this.mediaType, (String)this.content);
        }
        if (this.bs != null && this.mediaType != null) {
            return RequestBody.create((MediaType)this.mediaType, (byte[])this.bs);
        }
        if (this.file != null && this.mediaType != null) {
            return RequestBody.create((MediaType)this.mediaType, (File)this.file);
        }
        return HttpUtils.generateMultipartRequestBody(this.params, this.isMultipart);
    }

    protected Request.Builder generateRequestBuilder(RequestBody requestBody) {
        try {
            this.headers("Content-Length", String.valueOf(requestBody.contentLength()));
        }
        catch (IOException e) {
            OkLogger.printStackTrace(e);
        }
        Request.Builder requestBuilder = new Request.Builder();
        return HttpUtils.appendHeaders(requestBuilder, this.headers);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.mediaType == null ? "" : this.mediaType.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String mediaTypeString = (String)in.readObject();
        if (!TextUtils.isEmpty((CharSequence)mediaTypeString)) {
            this.mediaType = MediaType.parse((String)mediaTypeString);
        }
    }
}

