/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.model;

import android.content.ContentValues;
import android.database.Cursor;
import android.os.SystemClock;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.request.base.Request;
import com.lzy.okgo.utils.IOUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Progress
implements Serializable {
    private static final long serialVersionUID = 6353658567594109891L;
    public static final int NONE = 0;
    public static final int WAITING = 1;
    public static final int LOADING = 2;
    public static final int PAUSE = 3;
    public static final int ERROR = 4;
    public static final int FINISH = 5;
    public static final String TAG = "tag";
    public static final String URL = "url";
    public static final String FOLDER = "folder";
    public static final String FILE_PATH = "filePath";
    public static final String FILE_NAME = "fileName";
    public static final String FRACTION = "fraction";
    public static final String TOTAL_SIZE = "totalSize";
    public static final String CURRENT_SIZE = "currentSize";
    public static final String STATUS = "status";
    public static final String PRIORITY = "priority";
    public static final String DATE = "date";
    public static final String REQUEST = "request";
    public static final String EXTRA1 = "extra1";
    public static final String EXTRA2 = "extra2";
    public static final String EXTRA3 = "extra3";
    public String tag;
    public String url;
    public String folder;
    public String filePath;
    public String fileName;
    public float fraction;
    public long totalSize = -1L;
    public long currentSize;
    public transient long speed;
    public int status;
    public int priority = 0;
    public long date;
    public Request<?, ? extends Request> request;
    public Serializable extra1;
    public Serializable extra2;
    public Serializable extra3;
    public Throwable exception;
    private transient long tempSize;
    private transient long lastRefreshTime = SystemClock.elapsedRealtime();
    private transient List<Long> speedBuffer;

    public Progress() {
        this.date = System.currentTimeMillis();
        this.speedBuffer = new ArrayList<Long>();
    }

    public static Progress changeProgress(Progress progress, long writeSize, Action action) {
        return Progress.changeProgress(progress, writeSize, progress.totalSize, action);
    }

    public static Progress changeProgress(Progress progress, long writeSize, long totalSize, Action action) {
        boolean isNotify;
        progress.totalSize = totalSize;
        progress.currentSize += writeSize;
        progress.tempSize += writeSize;
        long currentTime = SystemClock.elapsedRealtime();
        boolean bl = isNotify = currentTime - progress.lastRefreshTime >= OkGo.REFRESH_TIME;
        if (isNotify || progress.currentSize == totalSize) {
            long diffTime = currentTime - progress.lastRefreshTime;
            if (diffTime == 0L) {
                diffTime = 1L;
            }
            progress.fraction = (float)progress.currentSize * 1.0f / (float)totalSize;
            progress.speed = progress.bufferSpeed(progress.tempSize * 1000L / diffTime);
            progress.lastRefreshTime = currentTime;
            progress.tempSize = 0L;
            if (action != null) {
                action.call(progress);
            }
        }
        return progress;
    }

    private long bufferSpeed(long speed) {
        this.speedBuffer.add(speed);
        if (this.speedBuffer.size() > 10) {
            this.speedBuffer.remove(0);
        }
        long sum = 0L;
        Iterator<Long> iterator = this.speedBuffer.iterator();
        while (iterator.hasNext()) {
            float speedTemp = iterator.next().longValue();
            sum = (long)((float)sum + speedTemp);
        }
        return sum / (long)this.speedBuffer.size();
    }

    public void from(Progress progress) {
        this.totalSize = progress.totalSize;
        this.currentSize = progress.currentSize;
        this.fraction = progress.fraction;
        this.speed = progress.speed;
        this.lastRefreshTime = progress.lastRefreshTime;
        this.tempSize = progress.tempSize;
    }

    public static ContentValues buildContentValues(Progress progress) {
        ContentValues values = new ContentValues();
        values.put(TAG, progress.tag);
        values.put(URL, progress.url);
        values.put(FOLDER, progress.folder);
        values.put(FILE_PATH, progress.filePath);
        values.put(FILE_NAME, progress.fileName);
        values.put(FRACTION, Float.valueOf(progress.fraction));
        values.put(TOTAL_SIZE, Long.valueOf(progress.totalSize));
        values.put(CURRENT_SIZE, Long.valueOf(progress.currentSize));
        values.put(STATUS, Integer.valueOf(progress.status));
        values.put(PRIORITY, Integer.valueOf(progress.priority));
        values.put(DATE, Long.valueOf(progress.date));
        values.put(REQUEST, IOUtils.toByteArray(progress.request));
        values.put(EXTRA1, IOUtils.toByteArray(progress.extra1));
        values.put(EXTRA2, IOUtils.toByteArray(progress.extra2));
        values.put(EXTRA3, IOUtils.toByteArray(progress.extra3));
        return values;
    }

    public static ContentValues buildUpdateContentValues(Progress progress) {
        ContentValues values = new ContentValues();
        values.put(FRACTION, Float.valueOf(progress.fraction));
        values.put(TOTAL_SIZE, Long.valueOf(progress.totalSize));
        values.put(CURRENT_SIZE, Long.valueOf(progress.currentSize));
        values.put(STATUS, Integer.valueOf(progress.status));
        values.put(PRIORITY, Integer.valueOf(progress.priority));
        values.put(DATE, Long.valueOf(progress.date));
        return values;
    }

    public static Progress parseCursorToBean(Cursor cursor) {
        Progress progress = new Progress();
        progress.tag = cursor.getString(cursor.getColumnIndex(TAG));
        progress.url = cursor.getString(cursor.getColumnIndex(URL));
        progress.folder = cursor.getString(cursor.getColumnIndex(FOLDER));
        progress.filePath = cursor.getString(cursor.getColumnIndex(FILE_PATH));
        progress.fileName = cursor.getString(cursor.getColumnIndex(FILE_NAME));
        progress.fraction = cursor.getFloat(cursor.getColumnIndex(FRACTION));
        progress.totalSize = cursor.getLong(cursor.getColumnIndex(TOTAL_SIZE));
        progress.currentSize = cursor.getLong(cursor.getColumnIndex(CURRENT_SIZE));
        progress.status = cursor.getInt(cursor.getColumnIndex(STATUS));
        progress.priority = cursor.getInt(cursor.getColumnIndex(PRIORITY));
        progress.date = cursor.getLong(cursor.getColumnIndex(DATE));
        progress.request = (Request)IOUtils.toObject(cursor.getBlob(cursor.getColumnIndex(REQUEST)));
        progress.extra1 = (Serializable)IOUtils.toObject(cursor.getBlob(cursor.getColumnIndex(EXTRA1)));
        progress.extra2 = (Serializable)IOUtils.toObject(cursor.getBlob(cursor.getColumnIndex(EXTRA2)));
        progress.extra3 = (Serializable)IOUtils.toObject(cursor.getBlob(cursor.getColumnIndex(EXTRA3)));
        return progress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Progress progress = (Progress)o;
        return this.tag != null ? this.tag.equals(progress.tag) : progress.tag == null;
    }

    public int hashCode() {
        return this.tag != null ? this.tag.hashCode() : 0;
    }

    public String toString() {
        return "Progress{fraction=" + this.fraction + ", totalSize=" + this.totalSize + ", currentSize=" + this.currentSize + ", speed=" + this.speed + ", status=" + this.status + ", priority=" + this.priority + ", folder=" + this.folder + ", filePath=" + this.filePath + ", fileName=" + this.fileName + ", tag=" + this.tag + ", url=" + this.url + '}';
    }

    public static interface Action {
        public void call(Progress var1);
    }
}

