/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.model;

import com.lzy.okgo.utils.HttpUtils;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;

public class HttpParams
implements Serializable {
    private static final long serialVersionUID = 7369819159227055048L;
    public static final MediaType MEDIA_TYPE_PLAIN = MediaType.parse((String)"text/plain;charset=utf-8");
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json;charset=utf-8");
    public static final MediaType MEDIA_TYPE_STREAM = MediaType.parse((String)"application/octet-stream");
    public static final boolean IS_REPLACE = true;
    public LinkedHashMap<String, List<String>> urlParamsMap;
    public LinkedHashMap<String, List<FileWrapper>> fileParamsMap;

    public HttpParams() {
        this.init();
    }

    public HttpParams(String key, String value) {
        this.init();
        this.put(key, value, true);
    }

    public HttpParams(String key, File file) {
        this.init();
        this.put(key, file);
    }

    private void init() {
        this.urlParamsMap = new LinkedHashMap();
        this.fileParamsMap = new LinkedHashMap();
    }

    public void put(HttpParams params) {
        if (params != null) {
            if (params.urlParamsMap != null && !params.urlParamsMap.isEmpty()) {
                this.urlParamsMap.putAll(params.urlParamsMap);
            }
            if (params.fileParamsMap != null && !params.fileParamsMap.isEmpty()) {
                this.fileParamsMap.putAll(params.fileParamsMap);
            }
        }
    }

    public void put(Map<String, String> params, boolean ... isReplace) {
        if (params == null || params.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            this.put(entry.getKey(), entry.getValue(), isReplace);
        }
    }

    public void put(String key, String value, boolean ... isReplace) {
        if (isReplace != null && isReplace.length > 0) {
            this.put(key, value, isReplace[0]);
        } else {
            this.put(key, value, true);
        }
    }

    public void put(String key, int value, boolean ... isReplace) {
        if (isReplace != null && isReplace.length > 0) {
            this.put(key, String.valueOf(value), isReplace[0]);
        } else {
            this.put(key, String.valueOf(value), true);
        }
    }

    public void put(String key, long value, boolean ... isReplace) {
        if (isReplace != null && isReplace.length > 0) {
            this.put(key, String.valueOf(value), isReplace[0]);
        } else {
            this.put(key, String.valueOf(value), true);
        }
    }

    public void put(String key, float value, boolean ... isReplace) {
        if (isReplace != null && isReplace.length > 0) {
            this.put(key, String.valueOf(value), isReplace[0]);
        } else {
            this.put(key, String.valueOf(value), true);
        }
    }

    public void put(String key, double value, boolean ... isReplace) {
        if (isReplace != null && isReplace.length > 0) {
            this.put(key, String.valueOf(value), isReplace[0]);
        } else {
            this.put(key, String.valueOf(value), true);
        }
    }

    public void put(String key, char value, boolean ... isReplace) {
        if (isReplace != null && isReplace.length > 0) {
            this.put(key, String.valueOf(value), isReplace[0]);
        } else {
            this.put(key, String.valueOf(value), true);
        }
    }

    public void put(String key, boolean value, boolean ... isReplace) {
        if (isReplace != null && isReplace.length > 0) {
            this.put(key, String.valueOf(value), isReplace[0]);
        } else {
            this.put(key, String.valueOf(value), true);
        }
    }

    private void put(String key, String value, boolean isReplace) {
        if (key != null && value != null) {
            List<String> urlValues = this.urlParamsMap.get(key);
            if (urlValues == null) {
                urlValues = new ArrayList<String>();
                this.urlParamsMap.put(key, urlValues);
            }
            if (isReplace) {
                urlValues.clear();
            }
            urlValues.add(value);
        }
    }

    public void putUrlParams(String key, List<String> values) {
        if (key != null && values != null && !values.isEmpty()) {
            for (String value : values) {
                this.put(key, value, false);
            }
        }
    }

    public void put(String key, File file) {
        this.put(key, file, file.getName());
    }

    public void put(String key, File file, String fileName) {
        this.put(key, file, fileName, HttpUtils.guessMimeType(fileName));
    }

    public void put(String key, FileWrapper fileWrapper) {
        if (key != null && fileWrapper != null) {
            this.put(key, fileWrapper.file, fileWrapper.fileName, fileWrapper.contentType);
        }
    }

    public void put(String key, File file, String fileName, MediaType contentType) {
        if (key != null) {
            List<FileWrapper> fileWrappers = this.fileParamsMap.get(key);
            if (fileWrappers == null) {
                fileWrappers = new ArrayList<FileWrapper>();
                this.fileParamsMap.put(key, fileWrappers);
            }
            fileWrappers.add(new FileWrapper(file, fileName, contentType));
        }
    }

    public void putFileParams(String key, List<File> files) {
        if (key != null && files != null && !files.isEmpty()) {
            for (File file : files) {
                this.put(key, file);
            }
        }
    }

    public void putFileWrapperParams(String key, List<FileWrapper> fileWrappers) {
        if (key != null && fileWrappers != null && !fileWrappers.isEmpty()) {
            for (FileWrapper fileWrapper : fileWrappers) {
                this.put(key, fileWrapper);
            }
        }
    }

    public void removeUrl(String key) {
        this.urlParamsMap.remove(key);
    }

    public void removeFile(String key) {
        this.fileParamsMap.remove(key);
    }

    public void remove(String key) {
        this.removeUrl(key);
        this.removeFile(key);
    }

    public void clear() {
        this.urlParamsMap.clear();
        this.fileParamsMap.clear();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.urlParamsMap.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(entry.getKey()).append("=").append(entry.getValue());
        }
        for (Map.Entry<String, List<Object>> entry : this.fileParamsMap.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return result.toString();
    }

    public static class FileWrapper
    implements Serializable {
        private static final long serialVersionUID = -2356139899636767776L;
        public File file;
        public String fileName;
        public transient MediaType contentType;
        public long fileSize;

        public FileWrapper(File file, String fileName, MediaType contentType) {
            this.file = file;
            this.fileName = fileName;
            this.contentType = contentType;
            this.fileSize = file.length();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(this.contentType.toString());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.contentType = MediaType.parse((String)((String)in.readObject()));
        }

        public String toString() {
            return "FileWrapper{file=" + this.file + ", fileName=" + this.fileName + ", contentType=" + this.contentType + ", fileSize=" + this.fileSize + "}";
        }
    }
}

