/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.db;

import com.lzy.okgo.db.ColumnEntity;
import java.util.ArrayList;
import java.util.List;

public class TableEntity {
    public String tableName;
    private List<ColumnEntity> list;

    public TableEntity(String tableName) {
        this.tableName = tableName;
        this.list = new ArrayList<ColumnEntity>();
    }

    public TableEntity addColumn(ColumnEntity columnEntity) {
        this.list.add(columnEntity);
        return this;
    }

    public String buildTableString() {
        StringBuilder sb = new StringBuilder("CREATE TABLE IF NOT EXISTS ");
        sb.append(this.tableName).append('(');
        for (ColumnEntity entity : this.list) {
            if (entity.compositePrimaryKey != null) {
                sb.append("PRIMARY KEY (");
                for (String primaryKey : entity.compositePrimaryKey) {
                    sb.append(primaryKey).append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append(")");
                continue;
            }
            sb.append(entity.columnName).append(" ").append(entity.columnType);
            if (entity.isNotNull) {
                sb.append(" NOT NULL");
            }
            if (entity.isPrimary) {
                sb.append(" PRIMARY KEY");
            }
            if (entity.isAutoincrement) {
                sb.append(" AUTOINCREMENT");
            }
            sb.append(",");
        }
        if (sb.toString().endsWith(",")) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(')');
        return sb.toString();
    }

    public String getColumnName(int columnIndex) {
        return this.list.get((int)columnIndex).columnName;
    }

    public int getColumnCount() {
        return this.list.size();
    }

    public int getColumnIndex(String columnName) {
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            if (!this.list.get((int)i).columnName.equals(columnName)) continue;
            return i;
        }
        return -1;
    }
}

