/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.cookie.store;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.lzy.okgo.cookie.SerializableCookie;
import com.lzy.okgo.cookie.store.CookieStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Cookie;
import okhttp3.HttpUrl;

public class SPCookieStore
implements CookieStore {
    private static final String COOKIE_PREFS = "okgo_cookie";
    private static final String COOKIE_NAME_PREFIX = "cookie_";
    private final Map<String, ConcurrentHashMap<String, Cookie>> cookies;
    private final SharedPreferences cookiePrefs;

    public SPCookieStore(Context context) {
        this.cookiePrefs = context.getSharedPreferences(COOKIE_PREFS, 0);
        this.cookies = new HashMap<String, ConcurrentHashMap<String, Cookie>>();
        Map prefsMap = this.cookiePrefs.getAll();
        for (Map.Entry entry : prefsMap.entrySet()) {
            String[] cookieNames;
            if (entry.getValue() == null || ((String)entry.getKey()).startsWith(COOKIE_NAME_PREFIX)) continue;
            for (String name : cookieNames = TextUtils.split((String)((String)entry.getValue()), (String)",")) {
                Cookie decodedCookie;
                String encodedCookie = this.cookiePrefs.getString(COOKIE_NAME_PREFIX + name, null);
                if (encodedCookie == null || (decodedCookie = SerializableCookie.decodeCookie(encodedCookie)) == null) continue;
                if (!this.cookies.containsKey(entry.getKey())) {
                    this.cookies.put((String)entry.getKey(), new ConcurrentHashMap());
                }
                this.cookies.get(entry.getKey()).put(name, decodedCookie);
            }
        }
    }

    private String getCookieToken(Cookie cookie) {
        return cookie.name() + "@" + cookie.domain();
    }

    private static boolean isCookieExpired(Cookie cookie) {
        return cookie.expiresAt() < System.currentTimeMillis();
    }

    @Override
    public synchronized void saveCookie(HttpUrl url, List<Cookie> urlCookies) {
        for (Cookie cookie : urlCookies) {
            this.saveCookie(url, cookie);
        }
    }

    @Override
    public synchronized void saveCookie(HttpUrl url, Cookie cookie) {
        if (!this.cookies.containsKey(url.host())) {
            this.cookies.put(url.host(), new ConcurrentHashMap());
        }
        if (SPCookieStore.isCookieExpired(cookie)) {
            this.removeCookie(url, cookie);
        } else {
            this.saveCookie(url, cookie, this.getCookieToken(cookie));
        }
    }

    private void saveCookie(HttpUrl url, Cookie cookie, String cookieToken) {
        this.cookies.get(url.host()).put(cookieToken, cookie);
        SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
        prefsWriter.putString(url.host(), TextUtils.join((CharSequence)",", (Iterable)this.cookies.get(url.host()).keySet()));
        prefsWriter.putString(COOKIE_NAME_PREFIX + cookieToken, SerializableCookie.encodeCookie(url.host(), cookie));
        prefsWriter.apply();
    }

    @Override
    public synchronized List<Cookie> loadCookie(HttpUrl url) {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        if (!this.cookies.containsKey(url.host())) {
            return ret;
        }
        Collection<Cookie> urlCookies = this.cookies.get(url.host()).values();
        for (Cookie cookie : urlCookies) {
            if (SPCookieStore.isCookieExpired(cookie)) {
                this.removeCookie(url, cookie);
                continue;
            }
            ret.add(cookie);
        }
        return ret;
    }

    @Override
    public synchronized boolean removeCookie(HttpUrl url, Cookie cookie) {
        if (!this.cookies.containsKey(url.host())) {
            return false;
        }
        String cookieToken = this.getCookieToken(cookie);
        if (!this.cookies.get(url.host()).containsKey(cookieToken)) {
            return false;
        }
        this.cookies.get(url.host()).remove(cookieToken);
        SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
        if (this.cookiePrefs.contains(COOKIE_NAME_PREFIX + cookieToken)) {
            prefsWriter.remove(COOKIE_NAME_PREFIX + cookieToken);
        }
        prefsWriter.putString(url.host(), TextUtils.join((CharSequence)",", (Iterable)this.cookies.get(url.host()).keySet()));
        prefsWriter.apply();
        return true;
    }

    @Override
    public synchronized boolean removeCookie(HttpUrl url) {
        if (!this.cookies.containsKey(url.host())) {
            return false;
        }
        ConcurrentHashMap<String, Cookie> urlCookie = this.cookies.remove(url.host());
        Set cookieTokens = urlCookie.keySet();
        SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
        for (String cookieToken : cookieTokens) {
            if (!this.cookiePrefs.contains(COOKIE_NAME_PREFIX + cookieToken)) continue;
            prefsWriter.remove(COOKIE_NAME_PREFIX + cookieToken);
        }
        prefsWriter.remove(url.host());
        prefsWriter.apply();
        return true;
    }

    @Override
    public synchronized boolean removeAllCookie() {
        this.cookies.clear();
        SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
        prefsWriter.clear();
        prefsWriter.apply();
        return true;
    }

    @Override
    public synchronized List<Cookie> getAllCookie() {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        for (String key : this.cookies.keySet()) {
            ret.addAll(this.cookies.get(key).values());
        }
        return ret;
    }

    @Override
    public synchronized List<Cookie> getCookie(HttpUrl url) {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        Map mapCookie = this.cookies.get(url.host());
        if (mapCookie != null) {
            ret.addAll(mapCookie.values());
        }
        return ret;
    }
}

