/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.cookie.store;

import com.lzy.okgo.cookie.store.CookieStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.Cookie;
import okhttp3.HttpUrl;

public class MemoryCookieStore
implements CookieStore {
    private final Map<String, List<Cookie>> memoryCookies = new HashMap<String, List<Cookie>>();

    @Override
    public synchronized void saveCookie(HttpUrl url, List<Cookie> cookies) {
        List<Cookie> oldCookies = this.memoryCookies.get(url.host());
        ArrayList<Cookie> needRemove = new ArrayList<Cookie>();
        for (Cookie newCookie : cookies) {
            for (Cookie oldCookie : oldCookies) {
                if (!newCookie.name().equals(oldCookie.name())) continue;
                needRemove.add(oldCookie);
            }
        }
        oldCookies.removeAll(needRemove);
        oldCookies.addAll(cookies);
    }

    @Override
    public synchronized void saveCookie(HttpUrl url, Cookie cookie) {
        List<Cookie> cookies = this.memoryCookies.get(url.host());
        ArrayList<Cookie> needRemove = new ArrayList<Cookie>();
        for (Cookie item : cookies) {
            if (!cookie.name().equals(item.name())) continue;
            needRemove.add(item);
        }
        cookies.removeAll(needRemove);
        cookies.add(cookie);
    }

    @Override
    public synchronized List<Cookie> loadCookie(HttpUrl url) {
        List<Cookie> cookies = this.memoryCookies.get(url.host());
        if (cookies == null) {
            cookies = new ArrayList<Cookie>();
            this.memoryCookies.put(url.host(), cookies);
        }
        return cookies;
    }

    @Override
    public synchronized List<Cookie> getAllCookie() {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        Set<String> httpUrls = this.memoryCookies.keySet();
        for (String url : httpUrls) {
            cookies.addAll((Collection<Cookie>)this.memoryCookies.get(url));
        }
        return cookies;
    }

    @Override
    public List<Cookie> getCookie(HttpUrl url) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        List<Cookie> urlCookies = this.memoryCookies.get(url.host());
        if (urlCookies != null) {
            cookies.addAll(urlCookies);
        }
        return cookies;
    }

    @Override
    public synchronized boolean removeCookie(HttpUrl url, Cookie cookie) {
        List<Cookie> cookies = this.memoryCookies.get(url.host());
        return cookie != null && cookies.remove(cookie);
    }

    @Override
    public synchronized boolean removeCookie(HttpUrl url) {
        return this.memoryCookies.remove(url.host()) != null;
    }

    @Override
    public synchronized boolean removeAllCookie() {
        this.memoryCookies.clear();
        return true;
    }
}

