/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.cookie.store;

import android.content.Context;
import com.lzy.okgo.cookie.SerializableCookie;
import com.lzy.okgo.cookie.store.CookieStore;
import com.lzy.okgo.db.CookieManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Cookie;
import okhttp3.HttpUrl;

public class DBCookieStore
implements CookieStore {
    private final Map<String, ConcurrentHashMap<String, Cookie>> cookies;

    public DBCookieStore(Context context) {
        CookieManager.init(context);
        this.cookies = new HashMap<String, ConcurrentHashMap<String, Cookie>>();
        List cookieList = CookieManager.getInstance().queryAll();
        for (SerializableCookie serializableCookie : cookieList) {
            if (!this.cookies.containsKey(serializableCookie.host)) {
                this.cookies.put(serializableCookie.host, new ConcurrentHashMap());
            }
            Cookie cookie = serializableCookie.getCookie();
            this.cookies.get(serializableCookie.host).put(this.getCookieToken(cookie), cookie);
        }
    }

    private String getCookieToken(Cookie cookie) {
        return cookie.name() + "@" + cookie.domain();
    }

    private static boolean isCookieExpired(Cookie cookie) {
        return cookie.expiresAt() < System.currentTimeMillis();
    }

    @Override
    public synchronized void saveCookie(HttpUrl url, List<Cookie> urlCookies) {
        for (Cookie cookie : urlCookies) {
            this.saveCookie(url, cookie);
        }
    }

    @Override
    public synchronized void saveCookie(HttpUrl url, Cookie cookie) {
        if (!this.cookies.containsKey(url.host())) {
            this.cookies.put(url.host(), new ConcurrentHashMap());
        }
        if (DBCookieStore.isCookieExpired(cookie)) {
            this.removeCookie(url, cookie);
        } else {
            this.cookies.get(url.host()).put(this.getCookieToken(cookie), cookie);
            SerializableCookie serializableCookie = new SerializableCookie(url.host(), cookie);
            CookieManager.getInstance().replace(serializableCookie);
        }
    }

    @Override
    public synchronized List<Cookie> loadCookie(HttpUrl url) {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        if (!this.cookies.containsKey(url.host())) {
            return ret;
        }
        List query = CookieManager.getInstance().query("host=?", new String[]{url.host()});
        for (SerializableCookie serializableCookie : query) {
            Cookie cookie = serializableCookie.getCookie();
            if (DBCookieStore.isCookieExpired(cookie)) {
                this.removeCookie(url, cookie);
                continue;
            }
            ret.add(cookie);
        }
        return ret;
    }

    @Override
    public synchronized boolean removeCookie(HttpUrl url, Cookie cookie) {
        if (!this.cookies.containsKey(url.host())) {
            return false;
        }
        String cookieToken = this.getCookieToken(cookie);
        if (!this.cookies.get(url.host()).containsKey(cookieToken)) {
            return false;
        }
        this.cookies.get(url.host()).remove(cookieToken);
        String whereClause = "host=? and name=? and domain=?";
        String[] whereArgs = new String[]{url.host(), cookie.name(), cookie.domain()};
        CookieManager.getInstance().delete(whereClause, whereArgs);
        return true;
    }

    @Override
    public synchronized boolean removeCookie(HttpUrl url) {
        if (!this.cookies.containsKey(url.host())) {
            return false;
        }
        this.cookies.remove(url.host());
        String whereClause = "host=?";
        String[] whereArgs = new String[]{url.host()};
        CookieManager.getInstance().delete(whereClause, whereArgs);
        return true;
    }

    @Override
    public synchronized boolean removeAllCookie() {
        this.cookies.clear();
        CookieManager.getInstance().deleteAll();
        return true;
    }

    @Override
    public synchronized List<Cookie> getAllCookie() {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        for (String key : this.cookies.keySet()) {
            ret.addAll(this.cookies.get(key).values());
        }
        return ret;
    }

    @Override
    public synchronized List<Cookie> getCookie(HttpUrl url) {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        Map mapCookie = this.cookies.get(url.host());
        if (mapCookie != null) {
            ret.addAll(mapCookie.values());
        }
        return ret;
    }
}

