/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.convert;

import android.os.Environment;
import android.text.TextUtils;
import com.lzy.okgo.callback.Callback;
import com.lzy.okgo.convert.Converter;
import com.lzy.okgo.model.Progress;
import com.lzy.okgo.utils.HttpUtils;
import com.lzy.okgo.utils.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class FileConvert
implements Converter<File> {
    public static final String DM_TARGET_FOLDER = File.separator + "download" + File.separator;
    private String folder;
    private String fileName;
    private Callback<File> callback;

    public FileConvert() {
        this(null);
    }

    public FileConvert(String fileName) {
        this(Environment.getExternalStorageDirectory() + DM_TARGET_FOLDER, fileName);
    }

    public FileConvert(String folder, String fileName) {
        this.folder = folder;
        this.fileName = fileName;
    }

    public void setCallback(Callback<File> callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File convertResponse(Response response) throws Throwable {
        File file;
        ResponseBody body;
        FileOutputStream fileOutputStream;
        byte[] buffer;
        InputStream bodyStream;
        File file2;
        String url;
        block6: {
            url = response.request().url().toString();
            if (TextUtils.isEmpty((CharSequence)this.folder)) {
                this.folder = Environment.getExternalStorageDirectory() + DM_TARGET_FOLDER;
            }
            if (TextUtils.isEmpty((CharSequence)this.fileName)) {
                this.fileName = HttpUtils.getNetFileName(response, url);
            }
            File dir = new File(this.folder);
            IOUtils.createFolder(dir);
            file2 = new File(dir, this.fileName);
            IOUtils.delFileOrFolder(file2);
            bodyStream = null;
            buffer = new byte[8192];
            fileOutputStream = null;
            body = response.body();
            if (body != null) break block6;
            File file3 = null;
            IOUtils.closeQuietly(bodyStream);
            IOUtils.closeQuietly(fileOutputStream);
            return file3;
        }
        try {
            int len;
            bodyStream = body.byteStream();
            Progress progress = new Progress();
            progress.totalSize = body.contentLength();
            progress.fileName = this.fileName;
            progress.filePath = file2.getAbsolutePath();
            progress.status = 2;
            progress.url = url;
            progress.tag = url;
            fileOutputStream = new FileOutputStream(file2);
            while ((len = bodyStream.read(buffer)) != -1) {
                fileOutputStream.write(buffer, 0, len);
                if (this.callback == null) continue;
                Progress.changeProgress(progress, len, new Progress.Action(){

                    @Override
                    public void call(Progress progress) {
                        FileConvert.this.onProgress(progress);
                    }
                });
            }
            fileOutputStream.flush();
            file = file2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bodyStream);
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(bodyStream);
        IOUtils.closeQuietly(fileOutputStream);
        return file;
    }

    private void onProgress(final Progress progress) {
        HttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                FileConvert.this.callback.downloadProgress(progress);
            }
        });
    }
}

