/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.convert;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.widget.ImageView;
import com.lzy.okgo.convert.Converter;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class BitmapConvert
implements Converter<Bitmap> {
    private int maxWidth;
    private int maxHeight;
    private Bitmap.Config decodeConfig;
    private ImageView.ScaleType scaleType;

    public BitmapConvert() {
        this(1000, 1000, Bitmap.Config.ARGB_8888, ImageView.ScaleType.CENTER_INSIDE);
    }

    public BitmapConvert(int maxWidth, int maxHeight) {
        this(maxWidth, maxHeight, Bitmap.Config.ARGB_8888, ImageView.ScaleType.CENTER_INSIDE);
    }

    public BitmapConvert(int maxWidth, int maxHeight, Bitmap.Config decodeConfig, ImageView.ScaleType scaleType) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.decodeConfig = decodeConfig;
        this.scaleType = scaleType;
    }

    @Override
    public Bitmap convertResponse(Response response) throws Throwable {
        ResponseBody body = response.body();
        if (body == null) {
            return null;
        }
        return this.parse(body.bytes());
    }

    private Bitmap parse(byte[] byteArray) throws OutOfMemoryError {
        Bitmap bitmap;
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        if (this.maxWidth == 0 && this.maxHeight == 0) {
            decodeOptions.inPreferredConfig = this.decodeConfig;
            bitmap = BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)decodeOptions);
        } else {
            decodeOptions.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)decodeOptions);
            int actualWidth = decodeOptions.outWidth;
            int actualHeight = decodeOptions.outHeight;
            int desiredWidth = BitmapConvert.getResizedDimension(this.maxWidth, this.maxHeight, actualWidth, actualHeight, this.scaleType);
            int desiredHeight = BitmapConvert.getResizedDimension(this.maxHeight, this.maxWidth, actualHeight, actualWidth, this.scaleType);
            decodeOptions.inJustDecodeBounds = false;
            decodeOptions.inSampleSize = BitmapConvert.findBestSampleSize(actualWidth, actualHeight, desiredWidth, desiredHeight);
            Bitmap tempBitmap = BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)decodeOptions);
            if (tempBitmap != null && (tempBitmap.getWidth() > desiredWidth || tempBitmap.getHeight() > desiredHeight)) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)tempBitmap, (int)desiredWidth, (int)desiredHeight, (boolean)true);
                tempBitmap.recycle();
            } else {
                bitmap = tempBitmap;
            }
        }
        return bitmap;
    }

    private static int getResizedDimension(int maxPrimary, int maxSecondary, int actualPrimary, int actualSecondary, ImageView.ScaleType scaleType) {
        if (maxPrimary == 0 && maxSecondary == 0) {
            return actualPrimary;
        }
        if (scaleType == ImageView.ScaleType.FIT_XY) {
            if (maxPrimary == 0) {
                return actualPrimary;
            }
            return maxPrimary;
        }
        if (maxPrimary == 0) {
            double ratio = (double)maxSecondary / (double)actualSecondary;
            return (int)((double)actualPrimary * ratio);
        }
        if (maxSecondary == 0) {
            return maxPrimary;
        }
        double ratio = (double)actualSecondary / (double)actualPrimary;
        int resized = maxPrimary;
        if (scaleType == ImageView.ScaleType.CENTER_CROP) {
            if ((double)resized * ratio < (double)maxSecondary) {
                resized = (int)((double)maxSecondary / ratio);
            }
            return resized;
        }
        if ((double)resized * ratio > (double)maxSecondary) {
            resized = (int)((double)maxSecondary / ratio);
        }
        return resized;
    }

    private static int findBestSampleSize(int actualWidth, int actualHeight, int desiredWidth, int desiredHeight) {
        double wr = (double)actualWidth / (double)desiredWidth;
        double hr = (double)actualHeight / (double)desiredHeight;
        double ratio = Math.min(wr, hr);
        float n = 1.0f;
        while ((double)(n * 2.0f) <= ratio) {
            n *= 2.0f;
        }
        return (int)n;
    }
}

