/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.cache.policy;

import com.lzy.okgo.cache.CacheEntity;
import com.lzy.okgo.cache.policy.BaseCachePolicy;
import com.lzy.okgo.callback.Callback;
import com.lzy.okgo.model.Response;
import com.lzy.okgo.request.base.Request;

public class RequestFailedCachePolicy<T>
extends BaseCachePolicy<T> {
    public RequestFailedCachePolicy(Request<T, ? extends Request> request) {
        super(request);
    }

    @Override
    public void onSuccess(final Response<T> success) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RequestFailedCachePolicy.this.mCallback.onSuccess(success);
                RequestFailedCachePolicy.this.mCallback.onFinish();
            }
        });
    }

    @Override
    public void onError(final Response<T> error) {
        if (this.cacheEntity != null) {
            final Response cacheSuccess = Response.success(true, this.cacheEntity.getData(), error.getRawCall(), error.getRawResponse());
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    RequestFailedCachePolicy.this.mCallback.onCacheSuccess(cacheSuccess);
                    RequestFailedCachePolicy.this.mCallback.onFinish();
                }
            });
        } else {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    RequestFailedCachePolicy.this.mCallback.onError(error);
                    RequestFailedCachePolicy.this.mCallback.onFinish();
                }
            });
        }
    }

    @Override
    public Response<T> requestSync(CacheEntity<T> cacheEntity) {
        try {
            this.prepareRawCall();
        }
        catch (Throwable throwable) {
            return Response.error(false, this.rawCall, null, throwable);
        }
        Response response = this.requestNetworkSync();
        if (!response.isSuccessful() && cacheEntity != null) {
            response = Response.success(true, cacheEntity.getData(), this.rawCall, response.getRawResponse());
        }
        return response;
    }

    @Override
    public void requestAsync(CacheEntity<T> cacheEntity, Callback<T> callback) {
        this.mCallback = callback;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RequestFailedCachePolicy.this.mCallback.onStart(RequestFailedCachePolicy.this.request);
                try {
                    RequestFailedCachePolicy.this.prepareRawCall();
                }
                catch (Throwable throwable) {
                    Response error = Response.error(false, RequestFailedCachePolicy.this.rawCall, null, throwable);
                    RequestFailedCachePolicy.this.mCallback.onError(error);
                    return;
                }
                RequestFailedCachePolicy.this.requestNetworkAsync();
            }
        });
    }
}

