/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.cache.policy;

import com.lzy.okgo.cache.CacheEntity;
import com.lzy.okgo.cache.policy.BaseCachePolicy;
import com.lzy.okgo.callback.Callback;
import com.lzy.okgo.model.Response;
import com.lzy.okgo.request.base.Request;

public class NoneCacheRequestPolicy<T>
extends BaseCachePolicy<T> {
    public NoneCacheRequestPolicy(Request<T, ? extends Request> request) {
        super(request);
    }

    @Override
    public void onSuccess(final Response<T> success) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                NoneCacheRequestPolicy.this.mCallback.onSuccess(success);
                NoneCacheRequestPolicy.this.mCallback.onFinish();
            }
        });
    }

    @Override
    public void onError(final Response<T> error) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                NoneCacheRequestPolicy.this.mCallback.onError(error);
                NoneCacheRequestPolicy.this.mCallback.onFinish();
            }
        });
    }

    @Override
    public Response<T> requestSync(CacheEntity<T> cacheEntity) {
        try {
            this.prepareRawCall();
        }
        catch (Throwable throwable) {
            return Response.error(false, this.rawCall, null, throwable);
        }
        Response response = null;
        if (cacheEntity != null) {
            response = Response.success(true, cacheEntity.getData(), this.rawCall, null);
        }
        if (response == null) {
            response = this.requestNetworkSync();
        }
        return response;
    }

    @Override
    public void requestAsync(final CacheEntity<T> cacheEntity, Callback<T> callback) {
        this.mCallback = callback;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                NoneCacheRequestPolicy.this.mCallback.onStart(NoneCacheRequestPolicy.this.request);
                try {
                    NoneCacheRequestPolicy.this.prepareRawCall();
                }
                catch (Throwable throwable) {
                    Response error = Response.error(false, NoneCacheRequestPolicy.this.rawCall, null, throwable);
                    NoneCacheRequestPolicy.this.mCallback.onError(error);
                    return;
                }
                if (cacheEntity != null) {
                    Response success = Response.success(true, cacheEntity.getData(), NoneCacheRequestPolicy.this.rawCall, null);
                    NoneCacheRequestPolicy.this.mCallback.onCacheSuccess(success);
                    NoneCacheRequestPolicy.this.mCallback.onFinish();
                    return;
                }
                NoneCacheRequestPolicy.this.requestNetworkAsync();
            }
        });
    }
}

