/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.cache.policy;

import com.lzy.okgo.cache.CacheEntity;
import com.lzy.okgo.cache.policy.BaseCachePolicy;
import com.lzy.okgo.callback.Callback;
import com.lzy.okgo.exception.CacheException;
import com.lzy.okgo.request.base.Request;
import okhttp3.Call;
import okhttp3.Response;

public class DefaultCachePolicy<T>
extends BaseCachePolicy<T> {
    public DefaultCachePolicy(Request<T, ? extends Request> request) {
        super(request);
    }

    @Override
    public void onSuccess(final com.lzy.okgo.model.Response<T> success) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DefaultCachePolicy.this.mCallback.onSuccess(success);
                DefaultCachePolicy.this.mCallback.onFinish();
            }
        });
    }

    @Override
    public void onError(final com.lzy.okgo.model.Response<T> error) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DefaultCachePolicy.this.mCallback.onError(error);
                DefaultCachePolicy.this.mCallback.onFinish();
            }
        });
    }

    @Override
    public boolean onAnalysisResponse(Call call, Response response) {
        if (response.code() != 304) {
            return false;
        }
        if (this.cacheEntity == null) {
            final com.lzy.okgo.model.Response error = com.lzy.okgo.model.Response.error(true, call, response, CacheException.NON_AND_304(this.request.getCacheKey()));
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    DefaultCachePolicy.this.mCallback.onError(error);
                    DefaultCachePolicy.this.mCallback.onFinish();
                }
            });
        } else {
            final com.lzy.okgo.model.Response success = com.lzy.okgo.model.Response.success(true, this.cacheEntity.getData(), call, response);
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    DefaultCachePolicy.this.mCallback.onCacheSuccess(success);
                    DefaultCachePolicy.this.mCallback.onFinish();
                }
            });
        }
        return true;
    }

    @Override
    public com.lzy.okgo.model.Response<T> requestSync(CacheEntity<T> cacheEntity) {
        try {
            this.prepareRawCall();
        }
        catch (Throwable throwable) {
            return com.lzy.okgo.model.Response.error(false, this.rawCall, null, throwable);
        }
        com.lzy.okgo.model.Response response = this.requestNetworkSync();
        if (response.isSuccessful() && response.code() == 304) {
            response = cacheEntity == null ? com.lzy.okgo.model.Response.error(true, this.rawCall, response.getRawResponse(), CacheException.NON_AND_304(this.request.getCacheKey())) : com.lzy.okgo.model.Response.success(true, cacheEntity.getData(), this.rawCall, response.getRawResponse());
        }
        return response;
    }

    @Override
    public void requestAsync(CacheEntity<T> cacheEntity, Callback<T> callback) {
        this.mCallback = callback;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DefaultCachePolicy.this.mCallback.onStart(DefaultCachePolicy.this.request);
                try {
                    DefaultCachePolicy.this.prepareRawCall();
                }
                catch (Throwable throwable) {
                    com.lzy.okgo.model.Response error = com.lzy.okgo.model.Response.error(false, DefaultCachePolicy.this.rawCall, null, throwable);
                    DefaultCachePolicy.this.mCallback.onError(error);
                    return;
                }
                DefaultCachePolicy.this.requestNetworkAsync();
            }
        });
    }
}

