/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.cache.policy;

import android.graphics.Bitmap;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.cache.CacheEntity;
import com.lzy.okgo.cache.CacheMode;
import com.lzy.okgo.cache.policy.CachePolicy;
import com.lzy.okgo.callback.Callback;
import com.lzy.okgo.db.CacheManager;
import com.lzy.okgo.exception.HttpException;
import com.lzy.okgo.request.base.Request;
import com.lzy.okgo.utils.HeaderParser;
import com.lzy.okgo.utils.HttpUtils;
import java.io.IOException;
import java.net.SocketTimeoutException;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.Response;

public abstract class BaseCachePolicy<T>
implements CachePolicy<T> {
    protected Request<T, ? extends Request> request;
    protected volatile boolean canceled;
    protected volatile int currentRetryCount = 0;
    protected boolean executed;
    protected Call rawCall;
    protected Callback<T> mCallback;
    protected CacheEntity<T> cacheEntity;

    public BaseCachePolicy(Request<T, ? extends Request> request) {
        this.request = request;
    }

    @Override
    public boolean onAnalysisResponse(Call call, Response response) {
        return false;
    }

    @Override
    public CacheEntity<T> prepareCache() {
        CacheMode cacheMode;
        if (this.request.getCacheKey() == null) {
            this.request.cacheKey(HttpUtils.createUrlFromParams(this.request.getBaseUrl(), this.request.getParams().urlParamsMap));
        }
        if (this.request.getCacheMode() == null) {
            this.request.cacheMode(CacheMode.NO_CACHE);
        }
        if ((cacheMode = this.request.getCacheMode()) != CacheMode.NO_CACHE) {
            this.cacheEntity = CacheManager.getInstance().get(this.request.getCacheKey());
            HeaderParser.addCacheHeaders(this.request, this.cacheEntity, cacheMode);
            if (this.cacheEntity != null && this.cacheEntity.checkExpire(cacheMode, this.request.getCacheTime(), System.currentTimeMillis())) {
                this.cacheEntity.setExpire(true);
            }
        }
        if (this.cacheEntity == null || this.cacheEntity.isExpire() || this.cacheEntity.getData() == null || this.cacheEntity.getResponseHeaders() == null) {
            this.cacheEntity = null;
        }
        return this.cacheEntity;
    }

    @Override
    public synchronized Call prepareRawCall() throws Throwable {
        if (this.executed) {
            throw HttpException.COMMON("Already executed!");
        }
        this.executed = true;
        this.rawCall = this.request.getRawCall();
        if (this.canceled) {
            this.rawCall.cancel();
        }
        return this.rawCall;
    }

    protected com.lzy.okgo.model.Response<T> requestNetworkSync() {
        try {
            Response response = this.rawCall.execute();
            int responseCode = response.code();
            if (responseCode == 404 || responseCode >= 500) {
                return com.lzy.okgo.model.Response.error(false, this.rawCall, response, HttpException.NET_ERROR());
            }
            T body = this.request.getConverter().convertResponse(response);
            this.saveCache(response.headers(), body);
            return com.lzy.okgo.model.Response.success(false, body, this.rawCall, response);
        }
        catch (Throwable throwable) {
            if (throwable instanceof SocketTimeoutException && this.currentRetryCount < this.request.getRetryCount()) {
                ++this.currentRetryCount;
                this.rawCall = this.request.getRawCall();
                if (this.canceled) {
                    this.rawCall.cancel();
                } else {
                    this.requestNetworkSync();
                }
            }
            return com.lzy.okgo.model.Response.error(false, this.rawCall, null, throwable);
        }
    }

    protected void requestNetworkAsync() {
        this.rawCall.enqueue(new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                if (e instanceof SocketTimeoutException && BaseCachePolicy.this.currentRetryCount < BaseCachePolicy.this.request.getRetryCount()) {
                    ++BaseCachePolicy.this.currentRetryCount;
                    BaseCachePolicy.this.rawCall = BaseCachePolicy.this.request.getRawCall();
                    if (BaseCachePolicy.this.canceled) {
                        BaseCachePolicy.this.rawCall.cancel();
                    } else {
                        BaseCachePolicy.this.rawCall.enqueue((okhttp3.Callback)this);
                    }
                } else if (!call.isCanceled()) {
                    com.lzy.okgo.model.Response error = com.lzy.okgo.model.Response.error(false, call, null, e);
                    BaseCachePolicy.this.onError(error);
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                int responseCode = response.code();
                if (responseCode == 404 || responseCode >= 500) {
                    com.lzy.okgo.model.Response error = com.lzy.okgo.model.Response.error(false, call, response, HttpException.NET_ERROR());
                    BaseCachePolicy.this.onError(error);
                    return;
                }
                if (BaseCachePolicy.this.onAnalysisResponse(call, response)) {
                    return;
                }
                try {
                    Object body = BaseCachePolicy.this.request.getConverter().convertResponse(response);
                    BaseCachePolicy.this.saveCache(response.headers(), body);
                    com.lzy.okgo.model.Response success = com.lzy.okgo.model.Response.success(false, body, call, response);
                    BaseCachePolicy.this.onSuccess(success);
                }
                catch (Throwable throwable) {
                    com.lzy.okgo.model.Response error = com.lzy.okgo.model.Response.error(false, call, response, throwable);
                    BaseCachePolicy.this.onError(error);
                }
            }
        });
    }

    private void saveCache(Headers headers, T data) {
        if (this.request.getCacheMode() == CacheMode.NO_CACHE) {
            return;
        }
        if (data instanceof Bitmap) {
            return;
        }
        CacheEntity<T> cache = HeaderParser.createCacheEntity(headers, data, this.request.getCacheMode(), this.request.getCacheKey());
        if (cache == null) {
            CacheManager.getInstance().remove(this.request.getCacheKey());
        } else {
            CacheManager.getInstance().replace(this.request.getCacheKey(), cache);
        }
    }

    protected void runOnUiThread(Runnable run) {
        OkGo.getInstance().getDelivery().post(run);
    }

    @Override
    public boolean isExecuted() {
        return this.executed;
    }

    @Override
    public void cancel() {
        this.canceled = true;
        if (this.rawCall != null) {
            this.rawCall.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        if (this.canceled) {
            return true;
        }
        BaseCachePolicy baseCachePolicy = this;
        synchronized (baseCachePolicy) {
            return this.rawCall != null && this.rawCall.isCanceled();
        }
    }
}

