/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.adapter;

import com.lzy.okgo.adapter.Call;
import com.lzy.okgo.cache.CacheEntity;
import com.lzy.okgo.cache.policy.CachePolicy;
import com.lzy.okgo.cache.policy.DefaultCachePolicy;
import com.lzy.okgo.cache.policy.FirstCacheRequestPolicy;
import com.lzy.okgo.cache.policy.NoCachePolicy;
import com.lzy.okgo.cache.policy.NoneCacheRequestPolicy;
import com.lzy.okgo.cache.policy.RequestFailedCachePolicy;
import com.lzy.okgo.callback.Callback;
import com.lzy.okgo.model.Response;
import com.lzy.okgo.request.base.Request;
import com.lzy.okgo.utils.HttpUtils;

public class CacheCall<T>
implements Call<T> {
    private CachePolicy<T> policy = null;
    private Request<T, ? extends Request> request;

    public CacheCall(Request<T, ? extends Request> request) {
        this.request = request;
        this.policy = this.preparePolicy();
    }

    @Override
    public Response<T> execute() {
        CacheEntity<T> cacheEntity = this.policy.prepareCache();
        return this.policy.requestSync(cacheEntity);
    }

    @Override
    public void execute(Callback<T> callback) {
        HttpUtils.checkNotNull(callback, "callback == null");
        CacheEntity<T> cacheEntity = this.policy.prepareCache();
        this.policy.requestAsync(cacheEntity, callback);
    }

    private CachePolicy<T> preparePolicy() {
        switch (this.request.getCacheMode()) {
            case DEFAULT: {
                this.policy = new DefaultCachePolicy<T>(this.request);
                break;
            }
            case NO_CACHE: {
                this.policy = new NoCachePolicy<T>(this.request);
                break;
            }
            case IF_NONE_CACHE_REQUEST: {
                this.policy = new NoneCacheRequestPolicy<T>(this.request);
                break;
            }
            case FIRST_CACHE_THEN_REQUEST: {
                this.policy = new FirstCacheRequestPolicy<T>(this.request);
                break;
            }
            case REQUEST_FAILED_READ_CACHE: {
                this.policy = new RequestFailedCachePolicy<T>(this.request);
            }
        }
        if (this.request.getCachePolicy() != null) {
            this.policy = this.request.getCachePolicy();
        }
        HttpUtils.checkNotNull(this.policy, "policy == null");
        return this.policy;
    }

    @Override
    public boolean isExecuted() {
        return this.policy.isExecuted();
    }

    @Override
    public void cancel() {
        this.policy.cancel();
    }

    @Override
    public boolean isCanceled() {
        return this.policy.isCanceled();
    }

    @Override
    public Call<T> clone() {
        return new CacheCall<T>(this.request);
    }

    @Override
    public Request getRequest() {
        return this.request;
    }
}

