/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.lzy.okgo.cache.CacheMode;
import com.lzy.okgo.cookie.CookieJarImpl;
import com.lzy.okgo.https.HttpsUtils;
import com.lzy.okgo.interceptor.HttpLoggingInterceptor;
import com.lzy.okgo.model.HttpHeaders;
import com.lzy.okgo.model.HttpParams;
import com.lzy.okgo.request.DeleteRequest;
import com.lzy.okgo.request.GetRequest;
import com.lzy.okgo.request.HeadRequest;
import com.lzy.okgo.request.OptionsRequest;
import com.lzy.okgo.request.PatchRequest;
import com.lzy.okgo.request.PostRequest;
import com.lzy.okgo.request.PutRequest;
import com.lzy.okgo.request.TraceRequest;
import com.lzy.okgo.utils.HttpUtils;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkGo {
    public static final long DEFAULT_MILLISECONDS = 60000L;
    public static long REFRESH_TIME = 300L;
    private Application context;
    private Handler mDelivery = new Handler(Looper.getMainLooper());
    private OkHttpClient okHttpClient;
    private HttpParams mCommonParams;
    private HttpHeaders mCommonHeaders;
    private int mRetryCount = 3;
    private CacheMode mCacheMode = CacheMode.NO_CACHE;
    private long mCacheTime = -1L;

    private OkGo() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor("OkGo");
        loggingInterceptor.setPrintLevel(HttpLoggingInterceptor.Level.BODY);
        loggingInterceptor.setColorLevel(Level.INFO);
        builder.addInterceptor((Interceptor)loggingInterceptor);
        builder.readTimeout(60000L, TimeUnit.MILLISECONDS);
        builder.writeTimeout(60000L, TimeUnit.MILLISECONDS);
        builder.connectTimeout(60000L, TimeUnit.MILLISECONDS);
        HttpsUtils.SSLParams sslParams = HttpsUtils.getSslSocketFactory();
        builder.sslSocketFactory(sslParams.sSLSocketFactory, sslParams.trustManager);
        builder.hostnameVerifier(HttpsUtils.UnSafeHostnameVerifier);
        this.okHttpClient = builder.build();
    }

    public static OkGo getInstance() {
        return OkGoHolder.holder;
    }

    public static <T> GetRequest<T> get(String url) {
        return new GetRequest(url);
    }

    public static <T> PostRequest<T> post(String url) {
        return new PostRequest(url);
    }

    public static <T> PutRequest<T> put(String url) {
        return new PutRequest(url);
    }

    public static <T> HeadRequest<T> head(String url) {
        return new HeadRequest(url);
    }

    public static <T> DeleteRequest<T> delete(String url) {
        return new DeleteRequest(url);
    }

    public static <T> OptionsRequest<T> options(String url) {
        return new OptionsRequest(url);
    }

    public static <T> PatchRequest<T> patch(String url) {
        return new PatchRequest(url);
    }

    public static <T> TraceRequest<T> trace(String url) {
        return new TraceRequest(url);
    }

    public OkGo init(Application app) {
        this.context = app;
        return this;
    }

    public Context getContext() {
        HttpUtils.checkNotNull(this.context, "please call OkGo.getInstance().init() first in application!");
        return this.context;
    }

    public Handler getDelivery() {
        return this.mDelivery;
    }

    public OkHttpClient getOkHttpClient() {
        HttpUtils.checkNotNull(this.okHttpClient, "please call OkGo.getInstance().setOkHttpClient() first in application!");
        return this.okHttpClient;
    }

    public OkGo setOkHttpClient(OkHttpClient okHttpClient) {
        HttpUtils.checkNotNull(okHttpClient, "okHttpClient == null");
        this.okHttpClient = okHttpClient;
        return this;
    }

    public CookieJarImpl getCookieJar() {
        return (CookieJarImpl)this.okHttpClient.cookieJar();
    }

    public OkGo setRetryCount(int retryCount) {
        if (retryCount < 0) {
            throw new IllegalArgumentException("retryCount must > 0");
        }
        this.mRetryCount = retryCount;
        return this;
    }

    public int getRetryCount() {
        return this.mRetryCount;
    }

    public OkGo setCacheMode(CacheMode cacheMode) {
        this.mCacheMode = cacheMode;
        return this;
    }

    public CacheMode getCacheMode() {
        return this.mCacheMode;
    }

    public OkGo setCacheTime(long cacheTime) {
        if (cacheTime <= -1L) {
            cacheTime = -1L;
        }
        this.mCacheTime = cacheTime;
        return this;
    }

    public long getCacheTime() {
        return this.mCacheTime;
    }

    public HttpParams getCommonParams() {
        return this.mCommonParams;
    }

    public OkGo addCommonParams(HttpParams commonParams) {
        if (this.mCommonParams == null) {
            this.mCommonParams = new HttpParams();
        }
        this.mCommonParams.put(commonParams);
        return this;
    }

    public HttpHeaders getCommonHeaders() {
        return this.mCommonHeaders;
    }

    public OkGo addCommonHeaders(HttpHeaders commonHeaders) {
        if (this.mCommonHeaders == null) {
            this.mCommonHeaders = new HttpHeaders();
        }
        this.mCommonHeaders.put(commonHeaders);
        return this;
    }

    public void cancelTag(Object tag) {
        if (tag == null) {
            return;
        }
        for (Call call : this.getOkHttpClient().dispatcher().queuedCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
        for (Call call : this.getOkHttpClient().dispatcher().runningCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
    }

    public static void cancelTag(OkHttpClient client, Object tag) {
        if (client == null || tag == null) {
            return;
        }
        for (Call call : client.dispatcher().queuedCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
        for (Call call : client.dispatcher().runningCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
    }

    public void cancelAll() {
        for (Call call : this.getOkHttpClient().dispatcher().queuedCalls()) {
            call.cancel();
        }
        for (Call call : this.getOkHttpClient().dispatcher().runningCalls()) {
            call.cancel();
        }
    }

    public static void cancelAll(OkHttpClient client) {
        if (client == null) {
            return;
        }
        for (Call call : client.dispatcher().queuedCalls()) {
            call.cancel();
        }
        for (Call call : client.dispatcher().runningCalls()) {
            call.cancel();
        }
    }

    private static class OkGoHolder {
        private static OkGo holder = new OkGo();

        private OkGoHolder() {
        }
    }
}

