/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.utils;

import android.text.TextUtils;
import com.lzy.okgo.model.HttpHeaders;
import com.lzy.okgo.model.HttpParams;
import com.lzy.okgo.utils.OkLogger;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpUtils {
    public static String createUrlFromParams(String url, Map<String, List<String>> params) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(url);
            if (url.indexOf(38) > 0 || url.indexOf(63) > 0) {
                sb.append("&");
            } else {
                sb.append("?");
            }
            for (Map.Entry<String, List<String>> urlParams : params.entrySet()) {
                List<String> urlValues = urlParams.getValue();
                for (String value : urlValues) {
                    String urlValue = URLEncoder.encode(value, "UTF-8");
                    sb.append(urlParams.getKey()).append("=").append(urlValue).append("&");
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            OkLogger.e(e);
            return url;
        }
    }

    public static Request.Builder appendHeaders(HttpHeaders headers) {
        Request.Builder requestBuilder = new Request.Builder();
        if (headers.headersMap.isEmpty()) {
            return requestBuilder;
        }
        Headers.Builder headerBuilder = new Headers.Builder();
        try {
            for (Map.Entry<String, String> entry : headers.headersMap.entrySet()) {
                headerBuilder.add(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            OkLogger.e(e);
        }
        requestBuilder.headers(headerBuilder.build());
        return requestBuilder;
    }

    public static RequestBody generateMultipartRequestBody(HttpParams params, boolean isMultipart) {
        if (params.fileParamsMap.isEmpty() && !isMultipart) {
            FormBody.Builder bodyBuilder = new FormBody.Builder();
            for (String string : params.urlParamsMap.keySet()) {
                List<String> urlValues = params.urlParamsMap.get(string);
                for (String string2 : urlValues) {
                    bodyBuilder.add(string, string2);
                }
            }
            return bodyBuilder.build();
        }
        MultipartBody.Builder multipartBodybuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (!params.urlParamsMap.isEmpty()) {
            for (Map.Entry<String, List<Object>> entry : params.urlParamsMap.entrySet()) {
                List<Object> urlValues = entry.getValue();
                for (String string : urlValues) {
                    multipartBodybuilder.addFormDataPart(entry.getKey(), string);
                }
            }
        }
        for (Map.Entry<String, List<Object>> entry : params.fileParamsMap.entrySet()) {
            List<Object> fileValues = entry.getValue();
            for (HttpParams.FileWrapper fileWrapper : fileValues) {
                RequestBody fileBody = RequestBody.create((MediaType)fileWrapper.contentType, (File)fileWrapper.file);
                multipartBodybuilder.addFormDataPart(entry.getKey(), fileWrapper.fileName, fileBody);
            }
        }
        return multipartBodybuilder.build();
    }

    public static String getNetFileName(Response response, String url) {
        String fileName = HttpUtils.getHeaderFileName(response);
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            fileName = HttpUtils.getUrlFileName(url);
        }
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            fileName = "nofilename";
        }
        return fileName;
    }

    private static String getHeaderFileName(Response response) {
        String split;
        int indexOf;
        String dispositionHeader = response.header("Content-Disposition");
        if (dispositionHeader != null && (indexOf = dispositionHeader.indexOf(split = "filename=")) != -1) {
            String fileName = dispositionHeader.substring(indexOf + split.length(), dispositionHeader.length());
            fileName = fileName.replaceAll("\"", "");
            return fileName;
        }
        return null;
    }

    private static String getUrlFileName(String url) {
        int index = url.lastIndexOf(63);
        String filename = index > 1 ? url.substring(url.lastIndexOf(47) + 1, index) : url.substring(url.lastIndexOf(47) + 1);
        return filename;
    }

    public static boolean deleteFile(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return true;
        }
        File file = new File(path);
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            boolean delete = file.delete();
            OkLogger.e("deleteFile:" + delete + " path:" + path);
            return delete;
        }
        return false;
    }
}

