/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.request;

import com.lzy.okgo.OkGo;
import com.lzy.okgo.utils.OkLogger;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class ProgressRequestBody
extends RequestBody {
    protected RequestBody delegate;
    protected Listener listener;
    protected CountingSink countingSink;

    public ProgressRequestBody(RequestBody delegate) {
        this.delegate = delegate;
    }

    public ProgressRequestBody(RequestBody delegate, Listener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public MediaType contentType() {
        return this.delegate.contentType();
    }

    public long contentLength() {
        try {
            return this.delegate.contentLength();
        }
        catch (IOException e) {
            OkLogger.e(e);
            return -1L;
        }
    }

    public void writeTo(BufferedSink sink) throws IOException {
        this.countingSink = new CountingSink((Sink)sink);
        BufferedSink bufferedSink = Okio.buffer((Sink)this.countingSink);
        this.delegate.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    public static interface Listener {
        public void onRequestProgress(long var1, long var3, long var5);
    }

    protected final class CountingSink
    extends ForwardingSink {
        private long bytesWritten;
        private long contentLength;
        private long lastRefreshUiTime;
        private long lastWriteBytes;

        public CountingSink(Sink delegate) {
            super(delegate);
            this.bytesWritten = 0L;
            this.contentLength = 0L;
        }

        public void write(Buffer source, long byteCount) throws IOException {
            super.write(source, byteCount);
            if (this.contentLength <= 0L) {
                this.contentLength = ProgressRequestBody.this.contentLength();
            }
            this.bytesWritten += byteCount;
            long curTime = System.currentTimeMillis();
            if (curTime - this.lastRefreshUiTime >= (long)OkGo.REFRESH_TIME || this.bytesWritten == this.contentLength) {
                long diffTime = (curTime - this.lastRefreshUiTime) / 1000L;
                if (diffTime == 0L) {
                    ++diffTime;
                }
                long diffBytes = this.bytesWritten - this.lastWriteBytes;
                long networkSpeed = diffBytes / diffTime;
                if (ProgressRequestBody.this.listener != null) {
                    ProgressRequestBody.this.listener.onRequestProgress(this.bytesWritten, this.contentLength, networkSpeed);
                }
                this.lastRefreshUiTime = System.currentTimeMillis();
                this.lastWriteBytes = this.bytesWritten;
            }
        }
    }
}

