/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.request;

import android.text.TextUtils;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.adapter.CacheCall;
import com.lzy.okgo.adapter.Call;
import com.lzy.okgo.adapter.CallAdapter;
import com.lzy.okgo.adapter.DefaultCallAdapter;
import com.lzy.okgo.cache.CacheMode;
import com.lzy.okgo.callback.AbsCallback;
import com.lzy.okgo.convert.Converter;
import com.lzy.okgo.model.HttpHeaders;
import com.lzy.okgo.model.HttpParams;
import com.lzy.okgo.request.ProgressRequestBody;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class BaseRequest<R extends BaseRequest> {
    protected String url;
    protected String method;
    protected String baseUrl;
    protected Object tag;
    protected long readTimeOut;
    protected long writeTimeOut;
    protected long connectTimeout;
    protected int retryCount;
    protected CacheMode cacheMode;
    protected String cacheKey;
    protected long cacheTime = -1L;
    protected HttpParams params = new HttpParams();
    protected HttpHeaders headers = new HttpHeaders();
    protected List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private AbsCallback mCallback;
    private Converter mConverter;
    private Request mRequest;

    public BaseRequest(String url) {
        String userAgent;
        this.url = url;
        this.baseUrl = url;
        OkGo go = OkGo.getInstance();
        String acceptLanguage = HttpHeaders.getAcceptLanguage();
        if (!TextUtils.isEmpty((CharSequence)acceptLanguage)) {
            this.headers("Accept-Language", acceptLanguage);
        }
        if (!TextUtils.isEmpty((CharSequence)(userAgent = HttpHeaders.getUserAgent()))) {
            this.headers("User-Agent", userAgent);
        }
        if (go.getCommonParams() != null) {
            this.params.put(go.getCommonParams());
        }
        if (go.getCommonHeaders() != null) {
            this.headers.put(go.getCommonHeaders());
        }
        if (go.getCacheMode() != null) {
            this.cacheMode = go.getCacheMode();
        }
        this.cacheTime = go.getCacheTime();
        this.retryCount = go.getRetryCount();
    }

    public R url(String url) {
        this.url = url;
        return (R)this;
    }

    public R tag(Object tag) {
        this.tag = tag;
        return (R)this;
    }

    public R readTimeOut(long readTimeOut) {
        this.readTimeOut = readTimeOut;
        return (R)this;
    }

    public R writeTimeOut(long writeTimeOut) {
        this.writeTimeOut = writeTimeOut;
        return (R)this;
    }

    public R connTimeOut(long connTimeOut) {
        this.connectTimeout = connTimeOut;
        return (R)this;
    }

    public R cacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return (R)this;
    }

    public R cacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return (R)this;
    }

    public R cacheTime(long cacheTime) {
        if (cacheTime <= -1L) {
            cacheTime = -1L;
        }
        this.cacheTime = cacheTime;
        return (R)this;
    }

    public R headers(HttpHeaders headers) {
        this.headers.put(headers);
        return (R)this;
    }

    public R headers(String key, String value) {
        this.headers.put(key, value);
        return (R)this;
    }

    public R removeHeader(String key) {
        this.headers.remove(key);
        return (R)this;
    }

    public R removeAllHeaders() {
        this.headers.clear();
        return (R)this;
    }

    public R params(HttpParams params) {
        this.params.put(params);
        return (R)this;
    }

    public R params(Map<String, String> params, boolean ... isReplace) {
        this.params.put(params, isReplace);
        return (R)this;
    }

    public R params(String key, String value, boolean ... isReplace) {
        this.params.put(key, value, isReplace);
        return (R)this;
    }

    public R params(String key, int value, boolean ... isReplace) {
        this.params.put(key, value, isReplace);
        return (R)this;
    }

    public R params(String key, float value, boolean ... isReplace) {
        this.params.put(key, value, isReplace);
        return (R)this;
    }

    public R params(String key, double value, boolean ... isReplace) {
        this.params.put(key, value, isReplace);
        return (R)this;
    }

    public R params(String key, long value, boolean ... isReplace) {
        this.params.put(key, value, isReplace);
        return (R)this;
    }

    public R params(String key, char value, boolean ... isReplace) {
        this.params.put(key, value, isReplace);
        return (R)this;
    }

    public R params(String key, boolean value, boolean ... isReplace) {
        this.params.put(key, value, isReplace);
        return (R)this;
    }

    public R addUrlParams(String key, List<String> values) {
        this.params.putUrlParams(key, values);
        return (R)this;
    }

    public R removeParam(String key) {
        this.params.remove(key);
        return (R)this;
    }

    public R removeAllParams() {
        this.params.clear();
        return (R)this;
    }

    public R setCallback(AbsCallback callback) {
        this.mCallback = callback;
        return (R)this;
    }

    public R addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
        return (R)this;
    }

    public String getUrlParam(String key) {
        List<String> values = this.params.urlParamsMap.get(key);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public HttpParams.FileWrapper getFileParam(String key) {
        List<HttpParams.FileWrapper> values = this.params.fileParamsMap.get(key);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public HttpParams getParams() {
        return this.params;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Object getTag() {
        return this.tag;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public long getCacheTime() {
        return this.cacheTime;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public Request getRequest() {
        return this.mRequest;
    }

    public AbsCallback getCallback() {
        return this.mCallback;
    }

    public Converter getConverter() {
        return this.mConverter;
    }

    public String getMethod() {
        return this.method;
    }

    public abstract RequestBody generateRequestBody();

    public RequestBody wrapRequestBody(RequestBody requestBody) {
        ProgressRequestBody progressRequestBody = new ProgressRequestBody(requestBody);
        progressRequestBody.setListener(new ProgressRequestBody.Listener(){

            @Override
            public void onRequestProgress(final long bytesWritten, final long contentLength, final long networkSpeed) {
                OkGo.getInstance().getDelivery().post(new Runnable(){

                    @Override
                    public void run() {
                        if (BaseRequest.this.mCallback != null) {
                            BaseRequest.this.mCallback.upProgress(bytesWritten, contentLength, (float)bytesWritten * 1.0f / (float)contentLength, networkSpeed);
                        }
                    }
                });
            }
        });
        return progressRequestBody;
    }

    public abstract Request generateRequest(RequestBody var1);

    public okhttp3.Call generateCall(Request request) {
        this.mRequest = request;
        if (this.readTimeOut <= 0L && this.writeTimeOut <= 0L && this.connectTimeout <= 0L && this.interceptors.size() == 0) {
            return OkGo.getInstance().getOkHttpClient().newCall(request);
        }
        OkHttpClient.Builder newClientBuilder = OkGo.getInstance().getOkHttpClient().newBuilder();
        if (this.readTimeOut > 0L) {
            newClientBuilder.readTimeout(this.readTimeOut, TimeUnit.MILLISECONDS);
        }
        if (this.writeTimeOut > 0L) {
            newClientBuilder.writeTimeout(this.writeTimeOut, TimeUnit.MILLISECONDS);
        }
        if (this.connectTimeout > 0L) {
            newClientBuilder.connectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS);
        }
        if (this.interceptors.size() > 0) {
            for (Interceptor interceptor : this.interceptors) {
                newClientBuilder.addInterceptor(interceptor);
            }
        }
        return newClientBuilder.build().newCall(request);
    }

    public okhttp3.Call getCall() {
        RequestBody requestBody = this.generateRequestBody();
        this.mRequest = this.generateRequest(this.wrapRequestBody(requestBody));
        return this.generateCall(this.mRequest);
    }

    public <T> Call<T> getCall(Converter<T> converter) {
        this.mConverter = converter;
        return DefaultCallAdapter.create().adapt((Call)new CacheCall(this));
    }

    public <T, E> E getCall(Converter<T> converter, CallAdapter<E> adapter) {
        this.mConverter = converter;
        return adapter.adapt(this.getCall(converter));
    }

    public Response execute() throws IOException {
        return this.getCall().execute();
    }

    public <T> void execute(AbsCallback<T> callback) {
        this.mCallback = callback;
        this.mConverter = callback;
        new CacheCall<T>(this).execute(callback);
    }
}

